/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DispoOseeTypes;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;

public class DispoItemArtifact
extends BaseIdentity<String>
implements DispoItem {
    private final ArtifactReadable artifact;
    private Boolean isIncludeDetails;
    public static DispoItemArtifact SENTINEL = DispoItemArtifact.valueOf(ArtifactReadable.SENTINEL);

    public static DispoItemArtifact valueOf(ArtifactReadable artifact) {
        final class DispoItemArtifactImpl
        extends DispoItemArtifact {
            private final /* synthetic */ ArtifactReadable val$artifact;

            public DispoItemArtifactImpl(ArtifactReadable artifact, ArtifactReadable artifactReadable) {
                this.val$artifact = artifactReadable;
                super(artifact);
            }

            @Override
            public String getName() {
                return this.val$artifact.getName();
            }
        }
        return new DispoItemArtifactImpl(artifact, artifact);
    }

    public DispoItemArtifact(ArtifactReadable artifact) {
        super((Object)artifact.getIdString());
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public void setIsIncludeDetails(Boolean isIncludeDetails) {
        this.isIncludeDetails = isIncludeDetails;
    }

    public Boolean getIsIncludeDetails() {
        return this.isIncludeDetails;
    }

    public Map<String, Discrepancy> getDiscrepanciesList() {
        String discrepanciesJson = this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageDiscrepanciesJson, "{}");
        return DispoUtil.jsonStringToDiscrepanciesMap(discrepanciesJson);
    }

    public List<DispoAnnotationData> getAnnotationsList() {
        String annotationsList = this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageAnnotationsJson, "[]");
        return DispoUtil.jsonStringToList(annotationsList, DispoAnnotationData.class);
    }

    public String toString() {
        return this.getName();
    }

    public String getAssignee() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageAssignee, "");
    }

    public Date getCreationDate() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.CoverageCreatedDate);
    }

    public Date getLastUpdate() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.CoverageLastUpdated);
    }

    public String getStatus() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageStatus);
    }

    public String getVersion() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoOseeTypes.DispoItemVersion);
    }

    public Boolean getNeedsRerun() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.CoverageNeedsRerun, (Object)false);
    }

    public String getTotalPoints() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageTotalPoints, "0");
    }

    public String getMachine() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoOseeTypes.DispoItemMachine, "n/a");
    }

    public String getCategory() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoOseeTypes.CoverageItemCategory, "");
    }

    public String getElapsedTime() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoOseeTypes.DispoItemElapsedTime, "0.0");
    }

    public Boolean getAborted() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeToken)DispoOseeTypes.DispoItemAborted, (Object)false);
    }

    public String getItemNotes() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageNotes, "");
    }

    public String getMethodNumber() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageMethodNumber, "");
    }

    public String getFileNumber() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageFileNumber, "");
    }

    public Boolean getNeedsReview() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeToken)DispoOseeTypes.DispoItemNeedsReview, (Object)false);
    }

    public String getTeam() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageTeam, "");
    }

    public Boolean isValid() {
        return !this.equals(DispoItemData.SENTINEL);
    }
}

