/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithGammas;
import org.eclipse.osee.accessor.types.AttributePojo;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class InterfaceStructureToken
extends ArtifactAccessorResultWithGammas {
    public static final InterfaceStructureToken SENTINEL = new InterfaceStructureToken();
    private AttributePojo<String> nameAbbrev = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.NameAbbrev, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<String> InterfaceStructureCategory = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceStructureCategory, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<String> InterfaceMinSimultaneity = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceMinSimultaneity, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<String> InterfaceMaxSimultaneity = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceMaxSimultaneity, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<Integer> InterfaceTaskFileType = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceTaskFileType, (GammaId)GammaId.SENTINEL, (Object)0, (String)"");
    private Integer numElements = 0;
    private Double sizeInBytes = 0.0;
    private AttributePojo<String> Description = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Description, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private boolean autogenerated = false;
    private Collection<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
    private ApplicabilityToken applicability;

    public InterfaceStructureToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceStructureToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Name, (Object)"")));
        this.setNameAbbrev((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.NameAbbrev, (Object)"")));
        this.setDescription((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Description, (Object)"")));
        this.setInterfaceMaxSimultaneity((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceMaxSimultaneity, (Object)"")));
        this.setInterfaceMinSimultaneity((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceMinSimultaneity, (Object)"")));
        this.setInterfaceStructureCategory((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceStructureCategory, (Object)"")));
        this.setInterfaceTaskFileType((AttributePojo<Integer>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceTaskFileType, (Object)0)));
        this.setElements(art.getRelated(CoreRelationTypes.InterfaceStructureContent_DataElement).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceStructureElementToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceStructureToken(Long id, String name) {
        super(id, AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)""));
    }

    public InterfaceStructureToken() {
    }

    public AttributePojo<String> getNameAbbrev() {
        return this.nameAbbrev;
    }

    public void setNameAbbrev(String nameAbbrev) {
        this.nameAbbrev = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.NameAbbrev, (GammaId)GammaId.SENTINEL, (Object)nameAbbrev, (String)"");
    }

    @JsonProperty
    public void setNameAbbrev(AttributePojo<String> nameAbbrev) {
        this.nameAbbrev = nameAbbrev;
    }

    public AttributePojo<String> getInterfaceStructureCategory() {
        return this.InterfaceStructureCategory;
    }

    public void setInterfaceStructureCategory(String interfaceStructureCategory) {
        this.InterfaceStructureCategory = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceStructureCategory, (GammaId)GammaId.SENTINEL, (Object)interfaceStructureCategory, (String)"");
    }

    @JsonProperty
    public void setInterfaceStructureCategory(AttributePojo<String> interfaceStructureCategory) {
        this.InterfaceStructureCategory = interfaceStructureCategory;
    }

    public AttributePojo<String> getInterfaceMinSimultaneity() {
        return this.InterfaceMinSimultaneity;
    }

    public void setInterfaceMinSimultaneity(String interfaceMinSimultaneity) {
        this.InterfaceMinSimultaneity = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceMinSimultaneity, (GammaId)GammaId.SENTINEL, (Object)interfaceMinSimultaneity, (String)"");
    }

    @JsonProperty
    public void setInterfaceMinSimultaneity(AttributePojo<String> interfaceMinSimultaneity) {
        this.InterfaceMinSimultaneity = interfaceMinSimultaneity;
    }

    public AttributePojo<String> getInterfaceMaxSimultaneity() {
        return this.InterfaceMaxSimultaneity;
    }

    public void setInterfaceMaxSimultaneity(String interfaceMaxSimultaneity) {
        this.InterfaceMaxSimultaneity = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceMaxSimultaneity, (GammaId)GammaId.SENTINEL, (Object)interfaceMaxSimultaneity, (String)"");
    }

    @JsonProperty
    public void setInterfaceMaxSimultaneity(AttributePojo<String> interfaceMaxSimultaneity) {
        this.InterfaceMaxSimultaneity = interfaceMaxSimultaneity;
    }

    public AttributePojo<Integer> getInterfaceTaskFileType() {
        return this.InterfaceTaskFileType;
    }

    public void setInterfaceTaskFileType(Integer interfaceTaskFileType) {
        this.InterfaceTaskFileType = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceTaskFileType, (GammaId)GammaId.SENTINEL, (Object)interfaceTaskFileType, (String)"");
    }

    @JsonProperty
    public void setInterfaceTaskFileType(AttributePojo<Integer> interfaceTaskFileType) {
        this.InterfaceTaskFileType = interfaceTaskFileType;
    }

    public AttributePojo<String> getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Description, (GammaId)GammaId.SENTINEL, (Object)description, (String)"");
    }

    @JsonProperty
    public void setDescription(AttributePojo<String> description) {
        this.Description = description;
    }

    public List<InterfaceStructureElementToken> getElements() {
        return (List)this.elements;
    }

    public void setElements(Collection<InterfaceStructureElementToken> elements) {
        this.elements = elements;
        this.setNumElements(elements.stream().filter(e -> e.isIncludedInCounts()).collect(Collectors.toList()).size());
        this.setSizeInBytes(elements.stream().filter(e -> e.isIncludedInCounts()).collect(Collectors.summingDouble(InterfaceStructureElementToken::getElementSizeInBytes)));
    }

    public Integer getNumElements() {
        return this.numElements;
    }

    public void setNumElements(Integer numElements) {
        this.numElements = numElements;
    }

    public Double getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Double sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public boolean getIncorrectlySized() {
        return this.getSizeInBytes() % 8.0 != 0.0;
    }

    public Double getBytesPerSecondMaximum() {
        return this.getSizeInBytes() * (Strings.isNumeric((String)((String)this.getInterfaceMaxSimultaneity().getValue())) ? Double.parseDouble((String)this.getInterfaceMaxSimultaneity().getValue()) : 0.0);
    }

    public Double getBytesPerSecondMinimum() {
        return this.getSizeInBytes() * (Strings.isNumeric((String)((String)this.getInterfaceMinSimultaneity().getValue())) ? Double.parseDouble((String)this.getInterfaceMinSimultaneity().getValue()) : 0.0);
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public void setAutogenerated(boolean autogenerated) {
        this.autogenerated = autogenerated;
    }

    public CreateArtifact createArtifact(String key, ApplicabilityId applicId) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.Description, (String)this.getDescription().getValue());
        values.put(CoreAttributeTypes.NameAbbrev, (String)this.getNameAbbrev().getValue());
        values.put(CoreAttributeTypes.InterfaceStructureCategory, (String)this.getInterfaceStructureCategory().getValue());
        values.put(CoreAttributeTypes.InterfaceMinSimultaneity, (String)this.getInterfaceMinSimultaneity().getValue());
        values.put(CoreAttributeTypes.InterfaceMaxSimultaneity, (String)this.getInterfaceMaxSimultaneity().getValue());
        values.put(CoreAttributeTypes.InterfaceTaskFileType, Integer.toString((Integer)this.getInterfaceTaskFileType().getValue()));
        CreateArtifact art = new CreateArtifact();
        art.setName((String)this.getName().getValue());
        art.setTypeId(CoreArtifactTypes.InterfaceStructure.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.InterfaceStructure.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setApplicabilityId(applicId.getIdString());
        art.setkey(key);
        return art;
    }
}

