/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithGammas;
import org.eclipse.osee.accessor.types.AttributePojo;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.TransportType;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class InterfaceConnection
extends ArtifactAccessorResultWithGammas {
    public static final InterfaceConnection SENTINEL = new InterfaceConnection();
    private AttributePojo<String> Description = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Description, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private TransportType TransportType;
    private List<InterfaceNode> nodes;
    private ApplicabilityToken applicability;

    public InterfaceConnection(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceConnection(ArtifactReadable art) {
        super(art);
        this.setNodes(art.getRelated(CoreRelationTypes.InterfaceConnectionNode_Node).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(n -> new InterfaceNode((ArtifactReadable)n)).collect(Collectors.toList()));
        ArtifactReadable transportType = (ArtifactReadable)art.getRelated(CoreRelationTypes.InterfaceConnectionTransportType_TransportType).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (!transportType.getExistingAttributeTypes().isEmpty()) {
            this.setTransportType(new TransportType((ArtifactReadable)art.getRelated(CoreRelationTypes.InterfaceConnectionTransportType_TransportType).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)));
        } else {
            this.setTransportType(org.eclipse.osee.mim.types.TransportType.SENTINEL);
        }
        this.setDescription((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.Description, (Object)"")));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceConnection(Long id, String name) {
        super(id, AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)""));
        this.setNodes(new LinkedList<InterfaceNode>());
    }

    public InterfaceConnection() {
    }

    public AttributePojo<String> getDescription() {
        return this.Description;
    }

    @JsonProperty
    public void setDescription(AttributePojo<String> description) {
        this.Description = description;
    }

    public void setDescription(String description) {
        this.Description = AttributePojo.valueOf((Long)this.Description.getId(), (AttributeTypeToken)this.Description.getTypeId(), (GammaId)this.Description.getGammaId(), (Object)description, (String)this.Description.getDisplayableString());
    }

    public TransportType getTransportType() {
        return this.TransportType;
    }

    public void setTransportType(TransportType transportType) {
        this.TransportType = transportType;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public List<InterfaceNode> getNodes() {
        return this.nodes;
    }

    private void setNodes(List<InterfaceNode> nodes) {
        this.nodes = nodes;
    }

    public CreateArtifact createArtifact(String key, ApplicabilityId applicId) {
        HashMap<AttributeTypeString, String> values = new HashMap<AttributeTypeString, String>();
        values.put(CoreAttributeTypes.Description, (String)this.getDescription().getValue());
        CreateArtifact art = new CreateArtifact();
        art.setName((String)this.getName().getValue());
        art.setTypeId(CoreArtifactTypes.InterfaceConnection.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.InterfaceConnection.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setApplicabilityId(applicId.getIdString());
        art.setkey(key);
        return art;
    }
}

