/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.applicability.NameValuePair;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.types.InterfaceConnection;

public class CrossReference
extends ArtifactAccessorResultWithoutGammas {
    public static final CrossReference SENTINEL = new CrossReference();
    private String crossReferenceValue;
    private String crossReferenceArrayValues;
    private String crossReferenceAdditionalContent;
    private Collection<InterfaceConnection> connections = new LinkedList<InterfaceConnection>();
    private ApplicabilityToken applicability;

    public CrossReference(ArtifactToken art) {
        super(art);
    }

    public CrossReference(ArtifactReadable art) {
        super(art);
        if (art.isValid()) {
            this.setCrossReferenceValue(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CrossReferenceValue, ""));
            this.setCrossReferenceArrayValues(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CrossReferenceArrayValues, ""));
            this.setCrossReferenceAdditionalContent(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CrossReferenceAdditionalContent, ""));
            this.setConnections(art.getRelated(CoreRelationTypes.InterfaceConnectionCrossReference_InterfaceConnection).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceConnection((ArtifactReadable)a)).collect(Collectors.toList()));
            this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        } else {
            this.setCrossReferenceValue("");
            this.setCrossReferenceArrayValues("");
            this.setCrossReferenceAdditionalContent("");
            this.setApplicability(ApplicabilityToken.SENTINEL);
        }
    }

    public CrossReference(Long id, String name, String value, String arrayValues, String additionalContent) {
        super(id, name);
        this.setCrossReferenceValue(value);
        this.setCrossReferenceArrayValues(arrayValues);
        this.setCrossReferenceAdditionalContent(additionalContent);
    }

    public CrossReference() {
    }

    public String getCrossReferenceValue() {
        return this.crossReferenceValue;
    }

    public void setCrossReferenceValue(String crossReferenceValue) {
        this.crossReferenceValue = crossReferenceValue;
    }

    public String getCrossReferenceArrayValues() {
        return this.crossReferenceArrayValues;
    }

    public void setCrossReferenceArrayValues(String crossReferenceArrayValues) {
        this.crossReferenceArrayValues = crossReferenceArrayValues;
    }

    public String getCrossReferenceAdditionalContent() {
        return this.crossReferenceAdditionalContent;
    }

    public void setCrossReferenceAdditionalContent(String crossReferenceAdditionalContent) {
        this.crossReferenceAdditionalContent = crossReferenceAdditionalContent;
    }

    @JsonIgnore
    public List<NameValuePair> getNameValuePairs() {
        return Arrays.asList(this.getCrossReferenceArrayValues().split(";")).stream().map(arv -> {
            if (Strings.isValid((String)arv)) {
                return new NameValuePair(arv.split("=")[1], arv.split("=")[0]);
            }
            return null;
        }).collect(Collectors.toList());
    }

    public void setConnections(Collection<InterfaceConnection> connections) {
        this.connections = connections;
    }

    public Collection<InterfaceConnection> getConnections() {
        return this.connections;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }
}

