/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.MimUserPreferenceEndpoint;
import org.eclipse.osee.mim.types.MimUserGlobalPreferences;
import org.eclipse.osee.mim.types.MimUserPreference;
import org.eclipse.osee.orcs.search.BranchQuery;

public class MimUserPreferenceEndpointImpl
implements MimUserPreferenceEndpoint {
    private final MimApi mimApi;

    public MimUserPreferenceEndpointImpl(MimApi mimApi) {
        this.mimApi = mimApi;
    }

    @Override
    public MimUserPreference getPreferences(BranchId branch) {
        if (this.mimApi.getOrcsApi().userService().getUser().isValid()) {
            ArtifactReadable user = this.mimApi.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)this.mimApi.getOrcsApi().userService().getUser()).follow(CoreRelationTypes.UserMimGlobalPreferences_MimGlobalPreferences).asArtifact();
            BranchToken selectedBranch = ((BranchQuery)this.mimApi.getOrcsApi().getQueryFactory().branchQuery().andId(branch)).getOneOrSentinel();
            boolean hasWriteAccess = !this.mimApi.getOrcsApi().getAccessControlService().hasBranchPermission((ArtifactToken)user, selectedBranch, PermissionEnum.WRITE, null).isErrors();
            MimUserGlobalPreferences userGlobalPrefs = new MimUserGlobalPreferences((ArtifactReadable)user.getRelated(CoreRelationTypes.UserMimGlobalPreferences_MimGlobalPreferences).getOneOrDefault((Object)ArtifactReadable.SENTINEL));
            return new MimUserPreference(user, userGlobalPrefs, branch, hasWriteAccess);
        }
        return MimUserPreference.SENTINEL;
    }

    @Override
    public List<String> getBranchPreferences() {
        LinkedList<String> prefs = new LinkedList<String>();
        List tempPrefs = this.mimApi.getOrcsApi().getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)this.mimApi.getOrcsApi().userService().getUser()).asArtifact().getAttributeValues((AttributeTypeToken)CoreAttributeTypes.MimBranchPreferences);
        prefs.addAll(tempPrefs);
        return prefs;
    }
}

