/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.mim.MimReportsApi;
import org.eclipse.osee.mim.types.NodeTraceReportItem;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class MimReportsApiImpl
implements MimReportsApi {
    private final OrcsApi orcsApi;

    public MimReportsApiImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Override
    public List<NodeTraceReportItem> getAllRequirementsToInterface(BranchId branch) {
        return this.getAllRequirementsToInterface(branch, 0L, 0L);
    }

    @Override
    public List<NodeTraceReportItem> getAllRequirementsToInterface(BranchId branch, long pageNum, long pageSize) {
        LinkedList<NodeTraceReportItem> results = new LinkedList();
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Requirement}).andRelationExists(CoreRelationTypes.RequirementsToInterface);
        if (pageNum != 0L && pageSize != 0L) {
            query = query.isOnPage(pageNum, pageSize);
        }
        query = query.follow(CoreRelationTypes.RequirementsToInterface_InterfaceArtifact);
        List requirements = query.asArtifacts();
        results = requirements.stream().map(r -> new NodeTraceReportItem((ArtifactReadable)r, CoreRelationTypes.RequirementsToInterface_InterfaceArtifact)).collect(Collectors.toList());
        return results;
    }

    @Override
    public List<NodeTraceReportItem> getAllRequirementsToInterfaceWithNoMatch(BranchId branch) {
        return this.getAllRequirementsToInterfaceWithNoMatch(branch, 0L, 0L);
    }

    @Override
    public List<NodeTraceReportItem> getAllRequirementsToInterfaceWithNoMatch(BranchId branch, long pageNum, long pageSize) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Requirement}).andRelationNotExists(CoreRelationTypes.RequirementsToInterface);
        if (pageNum != 0L && pageSize != 0L) {
            query = query.isOnPage(pageNum, pageSize);
        }
        return query.asArtifacts().stream().map(r -> new NodeTraceReportItem((ArtifactReadable)r, CoreRelationTypes.RequirementsToInterface_InterfaceArtifact)).collect(Collectors.toList());
    }

    @Override
    public List<NodeTraceReportItem> getAllInterfaceToRequirements(BranchId branch) {
        return this.getAllInterfaceToRequirements(branch, 0L, 0L);
    }

    @Override
    public List<NodeTraceReportItem> getAllInterfaceToRequirements(BranchId branch, long pageNum, long pageSize) {
        LinkedList<NodeTraceReportItem> results = new LinkedList();
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceArtifact}).andRelationExists(CoreRelationTypes.RequirementsToInterface);
        if (pageNum != 0L && pageSize != 0L) {
            query = query.isOnPage(pageNum, pageSize);
        }
        query = query.follow(CoreRelationTypes.RequirementsToInterface_Artifact);
        List arts = query.asArtifacts();
        results = arts.stream().map(a -> new NodeTraceReportItem((ArtifactReadable)a, CoreRelationTypes.RequirementsToInterface_Artifact)).collect(Collectors.toList());
        return results;
    }

    @Override
    public List<NodeTraceReportItem> getAllInterfaceToRequirementsWithNoMatch(BranchId branch) {
        return this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceArtifact}).andRelationNotExists(CoreRelationTypes.RequirementsToInterface).asArtifacts().stream().map(a -> new NodeTraceReportItem((ArtifactReadable)a, CoreRelationTypes.RequirementsToInterface_Artifact)).collect(Collectors.toList());
    }

    @Override
    public List<NodeTraceReportItem> getAllInterfaceToRequirementsWithNoMatch(BranchId branch, long pageNum, long pageSize) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceArtifact}).andRelationNotExists(CoreRelationTypes.RequirementsToInterface);
        if (pageNum != 0L && pageSize != 0L) {
            query = query.isOnPage(pageNum, pageSize);
        }
        return query.asArtifacts().stream().map(a -> new NodeTraceReportItem((ArtifactReadable)a, CoreRelationTypes.RequirementsToInterface_Artifact)).collect(Collectors.toList());
    }

    @Override
    public NodeTraceReportItem getInterfacesFromRequirement(BranchId branch, ArtifactId artId) {
        ArtifactReadable requirement = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.RequirementsToInterface_InterfaceArtifact).asArtifact();
        return new NodeTraceReportItem(requirement, CoreRelationTypes.RequirementsToInterface_InterfaceArtifact);
    }

    @Override
    public NodeTraceReportItem getRequirementsFromInterface(BranchId branch, ArtifactId artId) {
        ArtifactReadable interfaceReadable = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.RequirementsToInterface_Artifact).asArtifact();
        return new NodeTraceReportItem(interfaceReadable, CoreRelationTypes.RequirementsToInterface_Artifact);
    }

    @Override
    public int getCountRequirementsToInterface(BranchId branch) {
        return this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Requirement}).andRelationExists(CoreRelationTypes.RequirementsToInterface).getCount();
    }

    @Override
    public int getCountRequirementsToInterfaceWithNoMatch(BranchId branch) {
        return this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Requirement}).andRelationNotExists(CoreRelationTypes.RequirementsToInterface).getCount();
    }

    @Override
    public int getCountInterfaceToRequirements(BranchId branch) {
        return this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceArtifact}).andRelationExists(CoreRelationTypes.RequirementsToInterface).getCount();
    }

    @Override
    public int getCountInterfaceToRequirementsWithNoMatch(BranchId branch) {
        return this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceArtifact}).andRelationNotExists(CoreRelationTypes.RequirementsToInterface).getCount();
    }

    @Override
    public List<ArtifactToken> getImpactedConnections(BranchId branch) {
        String query = "with " + this.orcsApi.getJdbcService().getClient().getDbType().getRecursiveWithSql() + " impactedArts as " + "        (select distinct attr.art_id from osee_txs txs, osee_attribute attr " + "               where branch_id = ? and transaction_id > (select baseline_transaction_id from osee_branch b where b.branch_id = ?) and txs.gamma_id = attr.gamma_id union all" + "         select distinct art.art_id  from osee_txs txs, osee_artifact art where branch_id = ? and transaction_id > (select baseline_transaction_id from osee_branch b where b.branch_id = ?) and txs.gamma_id = art.gamma_id union all" + "         select distinct art.a_art_id from osee_txs txs, osee_relation art where branch_id = ? and transaction_id > (select baseline_transaction_id from osee_branch b where b.branch_id = ?) and txs.gamma_id = art.gamma_id)," + "  allRels (a_art_id, b_art_id, gamma_id, rel_type) as " + "        (select a_art_id, b_art_id, txs.gamma_id, rel_type " + "          from osee_txs txs, osee_relation rel " + "          where txs.branch_id = ? and txs.tx_current = ? and txs.gamma_id = rel.gamma_id " + "         union all" + "         select a_art_id, b_art_id, txs.gamma_id, rel_link_type_id rel_type " + "          from osee_txs txs, osee_relation_link rel " + "          where txs.branch_id = ? and txs.tx_current = ? and txs.gamma_id = rel.gamma_id), " + "  cte_query (b_art_id, a_art_id, rel_type) as " + "        (select b_art_id, a_art_id, rel_type " + "          from allRels " + "          where b_art_id in (select art_id from impactedArts)" + "         union all" + "          select e.b_art_id, e.a_art_id, e.rel_type " + "          from allRels e " + "          inner join cte_query c on c.a_art_id = e.b_art_id) " + " select distinct attr.art_id, attr.value " + " from cte_query cq, osee_txs txs, osee_artifact art, osee_txs attrTxs, osee_attribute attr " + " where cq.a_art_id = art.art_id and art.art_type_id = ? and txs.branch_id = ? and txs.tx_current = ? and " + " txs.gamma_id = art.gamma_id and attrTxs.branch_id = ? and attrTxs.tx_current = ? and attrTxs.gamma_id = attr.gamma_id and attr.art_id = art.art_id " + " and attr.attr_type_id = ?";
        ArrayList<ArtifactToken> conns = new ArrayList<ArtifactToken>();
        if (((Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getExactlyOne()).getBranchType().equals((Object)BranchType.WORKING)) {
            Consumer<JdbcStatement> consumer = stmt -> conns.add(ArtifactToken.valueOf((ArtifactId)ArtifactId.valueOf((Long)stmt.getLong("art_id")), (String)stmt.getString("value")));
            this.orcsApi.getJdbcService().getClient().runQuery(consumer, query, new Object[]{branch, branch, branch, branch, branch, branch, branch, TxCurrent.CURRENT.getIdIntValue(), branch, TxCurrent.CURRENT.getIdIntValue(), CoreArtifactTypes.InterfaceConnection.getId(), branch, TxCurrent.CURRENT.getIdIntValue(), branch, TxCurrent.CURRENT.getIdIntValue(), CoreAttributeTypes.Name.getId()});
        }
        return conns;
    }
}

