/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.NewActionData;
import org.eclipse.osee.ats.api.workflow.NewActionResult;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.MimDatabaseInitApi;
import org.eclipse.osee.mim.MimDemoBranches;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceEnumOrdinalType;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.InterfaceUnitToken;
import org.eclipse.osee.mim.types.MIMImportUtil;
import org.eclipse.osee.mim.types.MimImportSummary;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.mim.types.TransportType;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderDataFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class MimDatabaseInitApiImpl
implements MimDatabaseInitApi {
    private final MimApi mimApi;

    public MimDatabaseInitApiImpl(MimApi mimApi) {
        this.mimApi = mimApi;
    }

    @Override
    public NewActionResult createDemoBranches() {
        NewActionData data = new NewActionData();
        data.setAiIds(Arrays.asList(DemoArtifactToken.SAW_PL_MIM_AI.getIdString()));
        data.setAsUserId(DemoUsers.Joe_Smith.getIdString());
        data.setChangeType(ChangeTypes.Improvement);
        data.setCreatedByUserId(DemoUsers.Joe_Smith.getIdString());
        data.setDescription("MIM demo data");
        data.setOriginator(ArtifactId.valueOf((Long)DemoUsers.Joe_Smith.getId()));
        data.setPriority("3");
        data.setTitle("MIM Demo");
        data.setVersionId(ArtifactId.valueOf((Long)DemoArtifactToken.SAW_Product_Line.getId()));
        NewActionResult result = new NewActionResult();
        IAtsChangeSet changes = this.mimApi.getAtsApi().createChangeSet(this.getClass().getSimpleName());
        ActionResult actionResult = this.mimApi.getAtsApi().getActionService().createAction(data, changes);
        if (actionResult.getResults().isFailed()) {
            result.getResults().error("Error creating action");
            return result;
        }
        changes.execute();
        IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)actionResult.getTeamWfs().iterator().next();
        Branch workingBranch = this.mimApi.getOrcsApi().getBranchOps().createWorkingBranch(MimDemoBranches.MIM_DEMO, DemoBranches.SAW_PL, teamWf.getArtifactId());
        result.setWorkingBranchId((BranchId)workingBranch);
        return result;
    }

    @Override
    public TransactionResult populateDemoBranch(BranchId branchId) {
        TransactionResult txResult = new TransactionResult();
        XResultData resultData = new XResultData();
        try {
            TransactionBuilderData txData = this.getDemoTxData(branchId, this.getDemoImportSummary());
            TransactionBuilderDataFactory txBdf = new TransactionBuilderDataFactory(this.mimApi.getOrcsApi());
            TransactionBuilder tx = txBdf.loadFromJson(new ObjectMapper().writeValueAsString((Object)txData));
            TransactionToken token = tx.commit();
            txResult.setTx(token);
            resultData.setIds(tx.getTxDataReadables().stream().map(readable -> readable.getIdString()).collect(Collectors.toList()));
        }
        catch (JsonProcessingException jsonProcessingException) {
            resultData.error("Error processing tx json");
        }
        return txResult;
    }

    @Override
    public MimImportSummary getDemoImportSummary() {
        MimImportSummary summary = new MimImportSummary();
        TransportType transportType = this.createTransportType();
        summary.getTransportTypes().add(transportType);
        InterfaceConnection connection = this.createConnection();
        summary.getConnections().add(connection);
        List<InterfaceNode> nodes = this.createNodes();
        summary.getNodes().addAll(nodes);
        InterfaceMessageToken message = this.createMessage();
        summary.getMessages().add(message);
        InterfaceSubMessageToken submessage = this.createSubmessage();
        summary.getSubMessages().add(submessage);
        InterfaceStructureToken structure = this.createStructure();
        summary.getStructures().add(structure);
        List<InterfaceStructureElementToken> elements = this.createElements();
        summary.getElements().addAll(elements);
        List<PlatformTypeToken> pTypes = this.createPlatformTypes(summary);
        summary.getPlatformTypes().addAll(pTypes);
        summary.getUnits().addAll(this.createUnits());
        summary.getMessagePeriodicities().addAll(this.createMessagePeriodicities());
        summary.getMessageRates().addAll(this.createMessageRates());
        summary.getMessageTypes().addAll(this.createMessageTypes());
        summary.getStructureCategories().addAll(this.createStructureCategories());
        summary.getConnectionTransportTypeRelations().put(connection.getIdString(), Arrays.asList(transportType.getIdString()));
        summary.getConnectionNodeRelations().put(connection.getIdString(), nodes.stream().map(node -> node.getIdString()).collect(Collectors.toList()));
        summary.getConnectionMessageRelations().put(connection.getIdString(), Arrays.asList(message.getIdString()));
        summary.getMessagePublisherNodeRelations().put(message.getIdString(), Arrays.asList(nodes.get(0).getIdString()));
        summary.getMessageSubscriberNodeRelations().put(message.getIdString(), Arrays.asList(nodes.get(1).getIdString()));
        summary.getMessageSubmessageRelations().put(message.getIdString(), Arrays.asList(submessage.getIdString()));
        summary.getSubMessageStructureRelations().put(submessage.getIdString(), Arrays.asList(structure.getIdString()));
        summary.getStructureElementRelations().put(structure.getIdString(), elements.stream().map(element -> element.getIdString()).collect(Collectors.toList()));
        int i = 0;
        while (i < elements.size()) {
            InterfaceStructureElementToken element2 = elements.get(i);
            PlatformTypeToken pType = pTypes.get(i);
            summary.getElementPlatformTypeRelations().put(element2.getIdString(), Arrays.asList(pType.getIdString()));
            ++i;
        }
        return summary;
    }

    @Override
    public TransactionBuilderData getDemoTxData() {
        return this.getDemoTxData((BranchId)MimDemoBranches.MIM_DEMO, this.getDemoImportSummary());
    }

    private TransactionBuilderData getDemoTxData(BranchId branchId, MimImportSummary summary) {
        return MIMImportUtil.getTxBuilderDataFromImportSummary(branchId, ApplicabilityId.BASE, summary);
    }

    private TransportType createTransportType() {
        TransportType transportType = new TransportType(this.getRandomId(), "Ethernet");
        transportType.setByteAlignValidation(true);
        transportType.setByteAlignValidationSize(8);
        transportType.setMinimumPublisherMultiplicity(1);
        transportType.setMaximumPublisherMultiplicity(1);
        transportType.setMinimumSubscriberMultiplicity(1);
        transportType.setMaximumSubscriberMultiplicity(1);
        transportType.setMessageGeneration(true);
        transportType.setMessageGenerationPosition("0");
        transportType.setMessageGenerationType("Operational");
        return transportType;
    }

    private InterfaceConnection createConnection() {
        InterfaceConnection connection = new InterfaceConnection(this.getRandomId(), "Connection A-B");
        connection.setDescription("This is a demo connection");
        return connection;
    }

    private List<InterfaceNode> createNodes() {
        LinkedList<InterfaceNode> nodes = new LinkedList<InterfaceNode>();
        InterfaceNode nodeA = new InterfaceNode(this.getRandomId(), "Node A");
        InterfaceNode nodeB = new InterfaceNode(this.getRandomId(), "Node B");
        nodes.add(nodeA);
        nodes.add(nodeB);
        return nodes;
    }

    private InterfaceMessageToken createMessage() {
        InterfaceMessageToken message = new InterfaceMessageToken(this.getRandomId(), "Message 1");
        message.setInterfaceMessageNumber("1");
        message.setInterfaceMessagePeriodicity("Periodic");
        message.setInterfaceMessageRate("5");
        message.setInterfaceMessageType("Operational");
        message.setInterfaceMessageWriteAccess(true);
        return message;
    }

    private InterfaceSubMessageToken createSubmessage() {
        InterfaceSubMessageToken submessage = new InterfaceSubMessageToken(this.getRandomId(), "Submessage 1");
        submessage.setInterfaceSubMessageNumber("1");
        return submessage;
    }

    private InterfaceStructureToken createStructure() {
        InterfaceStructureToken structure = new InterfaceStructureToken(this.getRandomId(), "Structure 1");
        structure.setInterfaceMinSimultaneity("1");
        structure.setInterfaceMaxSimultaneity("1");
        structure.setInterfaceStructureCategory("Miscellaneous");
        structure.setInterfaceTaskFileType(0);
        return structure;
    }

    private List<InterfaceStructureElementToken> createElements() {
        LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
        InterfaceStructureElementToken element = new InterfaceStructureElementToken(this.getRandomId(), "Integer Element");
        element.setInterfaceElementAlterable(true);
        elements.add(element);
        element = new InterfaceStructureElementToken(this.getRandomId(), "Boolean Element");
        element.setInterfaceElementIndexStart(1);
        element.setInterfaceElementIndexEnd(4);
        elements.add(element);
        element = new InterfaceStructureElementToken(this.getRandomId(), "Float Element");
        elements.add(element);
        element = new InterfaceStructureElementToken(this.getRandomId(), "Demo Fault");
        elements.add(element);
        return elements;
    }

    private List<PlatformTypeToken> createPlatformTypes(MimImportSummary summary) {
        LinkedList<PlatformTypeToken> pTypes = new LinkedList<PlatformTypeToken>();
        PlatformTypeToken pType = new PlatformTypeToken(this.getRandomId(), "Integer", "unsigned integer", "32", "0", "2^31-1", "", "", "", "");
        pTypes.add(pType);
        pType = new PlatformTypeToken(this.getRandomId(), "Boolean", "boolean", "8", "0", "1", "", "", "", "");
        pTypes.add(pType);
        pType = new PlatformTypeToken(this.getRandomId(), "Float", "float", "32", "", "", "", "", "", "");
        pTypes.add(pType);
        pType = new PlatformTypeToken(this.getRandomId(), "Demo Fault", "enumeration", "32", "", "", "", "", "", "");
        pTypes.add(pType);
        InterfaceEnumerationSet enumSet = new InterfaceEnumerationSet(this.getRandomId(), "Demo Fault");
        summary.getEnumSets().add(enumSet);
        summary.getPlatformTypeEnumSetRelations().put(pType.getIdString(), Arrays.asList(enumSet.getIdString()));
        InterfaceEnumeration enumeration = new InterfaceEnumeration(this.getRandomId(), "Fault 1");
        enumeration.setOrdinal(1L);
        enumeration.setOrdinalType(InterfaceEnumOrdinalType.LONG);
        summary.getEnums().add(enumeration);
        enumeration = new InterfaceEnumeration(this.getRandomId(), "Fault 2");
        enumeration.setOrdinal(2L);
        enumeration.setOrdinalType(InterfaceEnumOrdinalType.LONG);
        summary.getEnums().add(enumeration);
        enumeration = new InterfaceEnumeration(this.getRandomId(), "Fault 3");
        enumeration.setOrdinal(3L);
        enumeration.setOrdinalType(InterfaceEnumOrdinalType.LONG);
        summary.getEnums().add(enumeration);
        enumeration = new InterfaceEnumeration(this.getRandomId(), "Fault 4");
        enumeration.setOrdinal(4L);
        enumeration.setOrdinalType(InterfaceEnumOrdinalType.LONG);
        summary.getEnums().add(enumeration);
        summary.getEnumSetEnumRelations().put(enumSet.getIdString(), summary.getEnums().stream().map(e -> e.getIdString()).collect(Collectors.toList()));
        return pTypes;
    }

    private List<InterfaceUnitToken> createUnits() {
        LinkedList<InterfaceUnitToken> units = new LinkedList<InterfaceUnitToken>();
        InterfaceUnitToken unit = new InterfaceUnitToken(this.getRandomId(), "Seconds");
        unit.setMeasurement("Time");
        units.add(unit);
        unit = new InterfaceUnitToken(this.getRandomId(), "Meters");
        unit.setMeasurement("Distance");
        units.add(unit);
        unit = new InterfaceUnitToken(this.getRandomId(), "Meters/second");
        unit.setMeasurement("Speed");
        units.add(unit);
        unit = new InterfaceUnitToken(this.getRandomId(), "Hertz");
        unit.setMeasurement("Frequency");
        units.add(unit);
        return units;
    }

    private List<ArtifactAccessorResultWithoutGammas> createMessagePeriodicities() {
        LinkedList<ArtifactAccessorResultWithoutGammas> periodicities = new LinkedList<ArtifactAccessorResultWithoutGammas>();
        periodicities.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "Periodic"));
        periodicities.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "Aperiodic"));
        return periodicities;
    }

    private List<ArtifactAccessorResultWithoutGammas> createMessageRates() {
        LinkedList<ArtifactAccessorResultWithoutGammas> rates = new LinkedList<ArtifactAccessorResultWithoutGammas>();
        rates.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "1"));
        rates.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "5"));
        rates.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "10"));
        rates.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "25"));
        rates.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "Aperiodic"));
        return rates;
    }

    private List<ArtifactAccessorResultWithoutGammas> createMessageTypes() {
        LinkedList<ArtifactAccessorResultWithoutGammas> messageTypes = new LinkedList<ArtifactAccessorResultWithoutGammas>();
        messageTypes.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "Operational"));
        messageTypes.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "Connection"));
        return messageTypes;
    }

    private List<ArtifactAccessorResultWithoutGammas> createStructureCategories() {
        LinkedList<ArtifactAccessorResultWithoutGammas> categories = new LinkedList<ArtifactAccessorResultWithoutGammas>();
        categories.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "Misc"));
        categories.add(new ArtifactAccessorResultWithoutGammas(Long.valueOf(this.getRandomId()), "Test"));
        return categories;
    }

    private long getRandomId() {
        return Math.abs(UUID.randomUUID().getMostSignificantBits());
    }
}

