/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceUnitApi;
import org.eclipse.osee.mim.InterfaceUnitEndpoint;
import org.eclipse.osee.mim.types.InterfaceUnitToken;

public class InterfaceUnitEndpointImpl
implements InterfaceUnitEndpoint {
    private final InterfaceUnitApi unitApi;
    private final BranchId branch;

    public InterfaceUnitEndpointImpl(BranchId branch, InterfaceUnitApi unitApi) {
        this.unitApi = unitApi;
        this.branch = branch;
    }

    @Override
    public Collection<InterfaceUnitToken> getAllUnits(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.unitApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.unitApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public InterfaceUnitToken getUnit(ArtifactId unitId) {
        return this.unitApi.get(this.branch, unitId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.unitApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

