/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceStructureSearchEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureToken;

public class InterfaceStructureSearchEndpointImpl
implements InterfaceStructureSearchEndpoint {
    private final BranchId branch;
    private final InterfaceStructureApi interfaceStructureApi;

    public InterfaceStructureSearchEndpointImpl(BranchId branch, InterfaceStructureApi interfaceStructureApi) {
        this.branch = branch;
        this.interfaceStructureApi = interfaceStructureApi;
    }

    @Override
    public Collection<InterfaceStructureToken> getStructures(String filter, long pageNum, long pageSize, AttributeTypeToken orderByAttributeTypeId) {
        if (Strings.isValid((String)filter)) {
            return this.interfaceStructureApi.getFiltered(this.branch, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
        }
        return this.interfaceStructureApi.getAll(this.branch, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
    }

    @Override
    public Collection<InterfaceStructureToken> getStructuresByName(String name, long pageNum, long pageSize) {
        return this.interfaceStructureApi.getAllByName(this.branch, name, pageNum, pageSize);
    }

    @Override
    public int getStructuresByNameCount(String name) {
        return this.interfaceStructureApi.getAllByNameCount(this.branch, name);
    }
}

