/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.dto.ChangeReportRowDto;
import org.eclipse.osee.mim.InterfaceDifferenceReportApi;
import org.eclipse.osee.mim.types.MimChangeSummary;
import org.eclipse.osee.mim.types.MimChangeSummaryItem;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class InterfaceDifferenceReportApiImpl
implements InterfaceDifferenceReportApi {
    private final OrcsApi orcsApi;

    InterfaceDifferenceReportApiImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Override
    public Map<ArtifactId, MimChangeSummaryItem> getChangeSummaryItems(BranchId branch1, BranchId branch2, ArtifactId view) {
        TransactionToken sourceTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch1)).getResults().getExactlyOne();
        TransactionToken destinationTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branch2)).getResults().getExactlyOne();
        List changes = this.orcsApi.getTransactionFactory().getTxChangeReport(branch1, branch2, (TransactionId)sourceTx, (TransactionId)destinationTx);
        List applicTokens = view.isValid() ? this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens(view, branch1) : this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(branch1).values().stream().collect(Collectors.toList());
        HashMap<ArtifactId, MimChangeSummaryItem> changeMap = new HashMap<ArtifactId, MimChangeSummaryItem>();
        for (ChangeReportRowDto change : changes) {
            if (!change.getArtType().getSuperTypes().contains(CoreArtifactTypes.InterfaceArtifact)) continue;
            ArtifactId artId = change.getArtA().getArtifactId();
            MimChangeSummaryItem item = (MimChangeSummaryItem)changeMap.get(artId);
            if (item == null) {
                item = new MimChangeSummaryItem(change.getArtA());
                changeMap.put(artId, item);
            }
            if (change.getItemKindType().equals((Object)ChangeType.Attribute) && !change.getIsValue().equals(change.getWasValue())) {
                item.getAttributeChanges().add(change);
                continue;
            }
            if (change.getItemKindType().equals((Object)ChangeType.Relation)) {
                item.getRelationChanges().add(change);
                continue;
            }
            if (!change.getItemKindType().equals((Object)ChangeType.Artifact)) continue;
            if (change.getChangeType().equals("Applicability")) {
                item.setIsApplic(change.getIsApplic());
                item.setWasApplic(change.getWasApplic());
                boolean isApplic = applicTokens.contains(change.getIsApplic());
                boolean wasApplic = applicTokens.contains(change.getWasApplic());
                if (isApplic && !wasApplic) {
                    item.setAdded(true);
                    item.setAddedDueToApplicChange(true);
                    continue;
                }
                if (isApplic || !wasApplic) continue;
                item.setDeleted(true);
                item.setDeletedDueToApplicChange(true);
                continue;
            }
            if (change.getModType().equals(ModificationType.NEW) || change.getModType().equals(ModificationType.INTRODUCED)) {
                item.setAdded(true);
                continue;
            }
            if (!change.getModType().equals(ModificationType.DELETED)) continue;
            item.setDeleted(true);
        }
        return changeMap;
    }

    @Override
    public MimChangeSummary getChangeSummary(BranchId branch1, BranchId branch2, ArtifactId view) {
        return this.getChangeSummary(branch1, branch2, view, ArtifactId.SENTINEL);
    }

    @Override
    public MimChangeSummary getChangeSummary(BranchId branch1, BranchId branch2, ArtifactId view, ArtifactId connectionId) {
        Map<ArtifactId, MimChangeSummaryItem> changes = this.getChangeSummaryItems(branch1, branch2, view);
        return this.getChangeSummary(branch1, branch2, view, connectionId, changes, new LinkedList<ApplicabilityToken>());
    }

    @Override
    public MimChangeSummary getChangeSummary(BranchId branch1, BranchId branch2, ArtifactId view, ArtifactId connectionId, Map<ArtifactId, MimChangeSummaryItem> changes) {
        return this.getChangeSummary(branch1, branch2, view, connectionId, changes, new LinkedList<ApplicabilityToken>());
    }

    @Override
    public MimChangeSummary getChangeSummary(BranchId branch1, BranchId branch2, ArtifactId view, ArtifactId connectionId, Map<ArtifactId, MimChangeSummaryItem> changes, List<ApplicabilityToken> applicTokenList) {
        ArtifactTypeToken artType;
        List applicTokens = applicTokenList;
        if (applicTokenList.isEmpty()) {
            applicTokens = view.isValid() ? this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens(view, branch1) : this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(branch1).values().stream().collect(Collectors.toList());
        }
        List<ArtifactTypeToken> elementTypes = Arrays.asList(CoreArtifactTypes.InterfaceDataElement, CoreArtifactTypes.InterfaceDataElementArray, CoreArtifactTypes.InterfacePlatformType, CoreArtifactTypes.InterfaceEnumSet, CoreArtifactTypes.InterfaceEnum, CoreArtifactTypes.InterfaceArrayIndexDescription);
        Map<ArtifactId, MimChangeSummaryItem> changeMap = changes.isEmpty() ? this.getChangeSummaryItems(branch1, branch2, view) : changes;
        MimChangeSummary summary = new MimChangeSummary(changeMap);
        HashMap<ArtifactId, List<ArtifactReadable>> elementMap = new HashMap<ArtifactId, List<ArtifactReadable>>();
        HashMap<ArtifactId, MimChangeSummaryItem> elementsAndTypes = new HashMap<ArtifactId, MimChangeSummaryItem>();
        LinkedList<MimChangeSummaryItem> items = new LinkedList<MimChangeSummaryItem>();
        items.addAll(changeMap.values());
        for (MimChangeSummaryItem item : items) {
            if (!elementTypes.contains(item.getArtType())) {
                for (ChangeReportRowDto change : item.getRelationChanges()) {
                    if (item.getChildren().stream().filter(c -> c.getArtifactReadable().equals(change.getArtB())).findFirst().orElse(null) != null) continue;
                    MimChangeSummaryItem child2 = changeMap.get(ArtifactId.valueOf((Long)change.getArtB().getId()));
                    if (child2 == null) {
                        child2 = new MimChangeSummaryItem(change.getArtB());
                    }
                    if (change.getModType().equals(ModificationType.NEW)) {
                        child2.setAdded(true);
                    } else if (change.getModType().equals(ModificationType.DELETED)) {
                        child2.setDeleted(true);
                    }
                    item.getChildren().add(child2);
                }
            }
            if (!(applicTokens.contains(item.getArtifactReadable().getApplicabilityToken()) || item.isAddedDueToApplicChange() || item.isDeletedDueToApplicChange())) {
                changeMap.remove(item.getArtId());
                continue;
            }
            if (!item.isAdded() && !item.isDeleted() && !item.isAddedDueToApplicChange() && !item.isApplicabilityChanged() && !item.isDeletedDueToApplicChange() && item.getAttributeChanges().isEmpty() && item.getRelationChanges().isEmpty() && item.getChildren().isEmpty()) {
                changeMap.remove(item.getArtId());
                continue;
            }
            ArtifactId artId = item.getArtId();
            artType = item.getArtType();
            if (!elementTypes.contains(artType)) continue;
            List<Object> currentElements = new LinkedList();
            if (elementMap.containsKey(artId)) {
                currentElements = (List)elementMap.get(artId);
            } else {
                BranchId branchToUse = item.isDeleted() && !item.isDeletedDueToApplicChange() ? branch2 : branch1;
                currentElements = this.getElements(artId, artType, branchToUse, elementMap);
                elementMap.put(artId, currentElements);
            }
            for (ArtifactReadable element : currentElements) {
                if (!CoreArtifactTypes.InterfaceDataElement.equals(artType) && !CoreArtifactTypes.InterfaceDataElement.equals(artType) && !applicTokens.contains(element.getApplicabilityToken())) continue;
                Object elementItem = changeMap.get(element.getArtifactId());
                if (elementItem == null) {
                    if (CoreArtifactTypes.InterfaceDataElement.equals(artType) || CoreArtifactTypes.InterfaceDataElement.equals(artType)) {
                        elementItem = item;
                    } else {
                        elementItem = new MimChangeSummaryItem(element);
                        changeMap.put(element.getArtifactId(), (MimChangeSummaryItem)elementItem);
                    }
                }
                for (ArtifactReadable arrayHeader : element.getRelated(CoreRelationTypes.InterfaceElementArrayElement_Element).getList()) {
                    if (!applicTokens.contains(arrayHeader.getApplicabilityToken())) continue;
                    MimChangeSummaryItem arrayHeaderItem = changeMap.get(arrayHeader.getArtifactId());
                    if (arrayHeaderItem == null) {
                        arrayHeaderItem = new MimChangeSummaryItem(arrayHeader);
                        changeMap.put(arrayHeader.getArtifactId(), arrayHeaderItem);
                    }
                    if (!arrayHeaderItem.getChildren().contains(elementItem)) {
                        arrayHeaderItem.getChildren().add((MimChangeSummaryItem)elementItem);
                    }
                    for (ArtifactReadable structure : arrayHeader.getRelated(CoreRelationTypes.InterfaceStructureContent_Structure).getList()) {
                        if (!applicTokens.contains(structure.getApplicabilityToken())) continue;
                        MimChangeSummaryItem structureItem = changeMap.get(structure.getArtifactId());
                        if (structureItem == null) {
                            structureItem = new MimChangeSummaryItem(structure);
                            changeMap.put(structure.getArtifactId(), structureItem);
                        }
                        if (structureItem.getChildren().contains(arrayHeaderItem)) continue;
                        structureItem.getChildren().add(arrayHeaderItem);
                    }
                }
                for (ArtifactReadable structure : element.getRelated(CoreRelationTypes.InterfaceStructureContent_Structure).getList()) {
                    if (!applicTokens.contains(structure.getApplicabilityToken())) continue;
                    Object structureItem = changeMap.get(structure.getArtifactId());
                    if (structureItem == null) {
                        structureItem = new MimChangeSummaryItem(structure);
                        changeMap.put(structure.getArtifactId(), (MimChangeSummaryItem)structureItem);
                    }
                    if (((MimChangeSummaryItem)structureItem).getChildren().contains(elementItem)) continue;
                    ((MimChangeSummaryItem)structureItem).getChildren().add((MimChangeSummaryItem)elementItem);
                }
            }
            elementsAndTypes.put(artId, item);
        }
        for (MimChangeSummaryItem item : elementsAndTypes.values()) {
            Object elementItem2;
            List<ChangeReportRowDto> attrChanges;
            ArtifactTypeToken artType2 = item.getArtType();
            List elementItems = ((List)elementMap.get(item.getArtId())).stream().map(a -> (MimChangeSummaryItem)changeMap.get(ArtifactId.valueOf((Long)a.getId()))).filter(i -> i != null).collect(Collectors.toList());
            if (CoreArtifactTypes.InterfaceDataElement.equals(artType2) || CoreArtifactTypes.InterfaceDataElementArray.equals(artType2)) {
                ChangeReportRowDto deletedPType = null;
                ChangeReportRowDto addedPType = null;
                for (ChangeReportRowDto relationChange : item.getRelationChanges()) {
                    if (relationChange.getModType().equals(ModificationType.DELETED) && CoreArtifactTypes.InterfacePlatformType.equals(relationChange.getArtB().getArtifactType())) {
                        deletedPType = relationChange;
                    } else if (relationChange.getModType().equals(ModificationType.NEW) && CoreArtifactTypes.InterfacePlatformType.equals(relationChange.getArtB().getArtifactType())) {
                        addedPType = relationChange;
                    }
                    if (deletedPType == null || addedPType == null) continue;
                    ArtifactReadable oldPType = deletedPType.getArtB();
                    ArtifactReadable newPType = addedPType.getArtB();
                    Arrays.asList(CoreAttributeTypes.InterfaceLogicalType, CoreAttributeTypes.InterfacePlatformTypeBitSize, CoreAttributeTypes.InterfacePlatformType2sComplement, CoreAttributeTypes.InterfacePlatformTypeMinval, CoreAttributeTypes.InterfacePlatformTypeMaxval, CoreAttributeTypes.InterfacePlatformTypeUnits, CoreAttributeTypes.InterfaceDefaultValue, CoreAttributeTypes.InterfacePlatformTypeMsbValue, CoreAttributeTypes.InterfacePlatformTypeBitsResolution, CoreAttributeTypes.InterfacePlatformTypeCompRate, CoreAttributeTypes.InterfacePlatformTypeAnalogAccuracy, CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription).stream().forEach(attr -> {
                        String isValue;
                        String wasValue = oldPType.getSoleAttributeAsString((AttributeTypeToken)attr, "");
                        if (!wasValue.equals(isValue = newPType.getSoleAttributeAsString((AttributeTypeToken)attr, ""))) {
                            ChangeReportRowDto attrChange = new ChangeReportRowDto(relationChange.getArtA(), ArtifactReadable.SENTINEL, item.getName(), attr.getName(), attr.getId(), "Modified", isValue, wasValue, ChangeType.Attribute, ModificationType.MODIFIED, relationChange.getIsApplic(), relationChange.getWasApplic(), relationChange.getTxId());
                            item.getAttributeChanges().add(attrChange);
                        }
                    });
                }
            }
            if (CoreArtifactTypes.InterfacePlatformType.equals(artType2) && !item.isAdded()) {
                attrChanges = item.getAttributeChanges().stream().filter(a -> !CoreAttributeTypes.Name.getName().equals(a.getItemType())).collect(Collectors.toList());
                elementItems.stream().forEach(e -> {
                    boolean bl = e.getAttributeChanges().addAll(attrChanges);
                });
                continue;
            }
            if (CoreArtifactTypes.InterfaceEnumSet.equals(artType2)) {
                attrChanges = item.getAttributeChanges().stream().filter(a -> CoreAttributeTypes.Name.getName().equals(a.getItemType())).collect(Collectors.toList());
                attrChanges.forEach(a -> a.setItemType("Enum Set Name"));
                elementItems.stream().forEach(e -> {
                    boolean bl = e.getAttributeChanges().addAll(attrChanges);
                });
                continue;
            }
            if (!CoreArtifactTypes.InterfaceEnum.equals(artType2)) continue;
            String isOrdinal = item.getArtifactReadable().getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinal);
            String isName = item.getName();
            if (item.isAdded() || item.isAddedDueToApplicChange() || item.isDeleted() || item.isDeletedDueToApplicChange()) {
                String isValue = "";
                String wasValue = "";
                String itemType = "";
                if (item.isDeleted() || item.isDeletedDueToApplicChange()) {
                    wasValue = String.valueOf(isOrdinal) + " = " + isName;
                    itemType = "Deleted Enum Literal";
                } else {
                    isValue = String.valueOf(isOrdinal) + " = " + isName;
                    itemType = "Added Enum Literal";
                }
                for (Object elementItem2 : elementItems) {
                    ChangeReportRowDto newChange = new ChangeReportRowDto(((MimChangeSummaryItem)elementItem2).getArtifactReadable(), ArtifactReadable.SENTINEL, ((MimChangeSummaryItem)elementItem2).getName(), itemType, AttributeId.SENTINEL.getId(), "Modified", isValue, wasValue, ChangeType.Attribute, ModificationType.MODIFIED, ApplicabilityToken.SENTINEL, ApplicabilityToken.SENTINEL, item.getArtifactReadable().getTransaction());
                    ((MimChangeSummaryItem)elementItem2).getAttributeChanges().add(newChange);
                }
                continue;
            }
            String wasOrdinal = isOrdinal;
            String wasName = isName;
            elementItem2 = item.getAttributeChanges().iterator();
            while (elementItem2.hasNext()) {
                ChangeReportRowDto attrChange = elementItem2.next();
                if (CoreAttributeTypes.Name.getName().equals(attrChange.getItemType())) {
                    wasName = attrChange.getWasValue();
                    continue;
                }
                if (!CoreAttributeTypes.InterfaceEnumOrdinal.getName().equals(attrChange.getItemType())) continue;
                wasOrdinal = attrChange.getWasValue();
            }
            String isValue = String.valueOf(isOrdinal) + " = " + isName;
            String wasValue = String.valueOf(wasOrdinal) + " = " + wasName;
            for (MimChangeSummaryItem elementItem3 : elementItems) {
                ChangeReportRowDto newChange = new ChangeReportRowDto(elementItem3.getArtifactReadable(), ArtifactReadable.SENTINEL, elementItem3.getName(), "Enum Literal", AttributeId.SENTINEL.getId(), "Modified", isValue, wasValue, ChangeType.Attribute, ModificationType.MODIFIED, ApplicabilityToken.SENTINEL, ApplicabilityToken.SENTINEL, elementItem3.getArtifactReadable().getTransaction());
                elementItem3.getAttributeChanges().add(newChange);
            }
        }
        for (ArtifactId artId : changeMap.keySet()) {
            MimChangeSummaryItem item = changeMap.get(artId);
            artType = item.getArtType();
            if (item.getRelationChanges().isEmpty() && item.getAttributeChanges().isEmpty() && !item.isApplicabilityChanged() && !item.isAdded() && !item.isDeleted() && item.getChildren().isEmpty()) continue;
            if (CoreArtifactTypes.InterfaceNode.equals(artType)) {
                summary.getNodes().put(artId, item);
                continue;
            }
            if (CoreArtifactTypes.InterfaceConnection.equals(artType)) {
                summary.getConnections().put(artId, item);
                item.getChildren().forEach(child -> {
                    if (child.getArtType().equals(CoreArtifactTypes.InterfaceMessage) && !summary.getMessages().containsKey(child.getArtId())) {
                        summary.getMessages().put(child.getArtId(), (MimChangeSummaryItem)child);
                    }
                });
                continue;
            }
            if (CoreArtifactTypes.InterfaceMessage.equals(artType)) {
                summary.getMessages().put(artId, item);
                item.getChildren().forEach(child -> {
                    if (child.getArtType().equals(CoreArtifactTypes.InterfaceSubMessage) && !summary.getMessages().containsKey(child.getArtId())) {
                        summary.getSubMessages().put(child.getArtId(), (MimChangeSummaryItem)child);
                    }
                });
                continue;
            }
            if (CoreArtifactTypes.InterfaceSubMessage.equals(artType)) {
                summary.getSubMessages().put(artId, item);
                item.getChildren().forEach(child -> {
                    if (child.getArtType().equals(CoreArtifactTypes.InterfaceStructure) && !summary.getMessages().containsKey(child.getArtId())) {
                        summary.getStructures().put(child.getArtId(), (MimChangeSummaryItem)child);
                    }
                });
                continue;
            }
            if (!CoreArtifactTypes.InterfaceStructure.equals(artType)) continue;
            summary.getStructures().put(artId, item);
        }
        this.narrowDiffsToConnection(summary, branch1, branch2, connectionId, view);
        return summary;
    }

    private List<ArtifactReadable> getElements(ArtifactId artId, ArtifactTypeToken artType, BranchId branch, Map<ArtifactId, List<ArtifactReadable>> elementMap) {
        if (elementMap.containsKey(artId)) {
            return elementMap.get(artId);
        }
        QueryBuilder subQuery = new QueryData(QueryType.SELECT, this.orcsApi.tokenService()).follow(CoreRelationTypes.InterfaceStructureContent_Structure);
        LinkedList<ArtifactReadable> elements = new LinkedList<ArtifactReadable>();
        if (CoreArtifactTypes.InterfaceEnum.equals(artType)) {
            ArtifactReadable enumeration = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.InterfaceEnumeration_EnumerationSet).follow(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element).follow(CoreRelationTypes.InterfaceElementPlatformType_Element).followFork(CoreRelationTypes.InterfaceElementArrayElement_Element, subQuery).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
            for (ArtifactReadable enumSet : enumeration.getRelated(CoreRelationTypes.InterfaceEnumeration_EnumerationSet).getList()) {
                for (ArtifactReadable pType : enumSet.getRelated(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element)) {
                    for (ArtifactReadable element : pType.getRelated(CoreRelationTypes.InterfaceElementPlatformType_Element)) {
                        elements.add(element);
                    }
                }
            }
        } else if (CoreArtifactTypes.InterfaceEnumSet.equals(artType)) {
            ArtifactReadable enumSet = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element).follow(CoreRelationTypes.InterfaceElementPlatformType_Element).followFork(CoreRelationTypes.InterfaceElementArrayElement_Element, subQuery).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
            for (ArtifactReadable pType : enumSet.getRelated(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element)) {
                for (ArtifactReadable element : pType.getRelated(CoreRelationTypes.InterfaceElementPlatformType_Element)) {
                    elements.add(element);
                }
            }
        } else if (CoreArtifactTypes.InterfaceArrayIndexDescription.equals(artType)) {
            ArtifactReadable desc = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.InterfaceArrayIndexDescription_Set).follow(CoreRelationTypes.InterfaceElementArrayIndexDescriptionSet_Element).followFork(CoreRelationTypes.InterfaceElementArrayElement_Element, subQuery).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
            for (ArtifactReadable descSet : desc.getRelated(CoreRelationTypes.InterfaceArrayIndexDescription_Set)) {
                for (ArtifactReadable element : descSet.getRelated(CoreRelationTypes.InterfaceElementArrayIndexDescriptionSet_Element)) {
                    elements.add(element);
                }
            }
        } else if (CoreArtifactTypes.InterfacePlatformType.equals(artType)) {
            ArtifactReadable pType = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).follow(CoreRelationTypes.InterfaceElementPlatformType_Element).followFork(CoreRelationTypes.InterfaceElementArrayElement_Element, subQuery).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
            for (ArtifactReadable element : pType.getRelated(CoreRelationTypes.InterfaceElementPlatformType_Element)) {
                elements.add(element);
            }
        } else if (CoreArtifactTypes.InterfaceDataElement.equals(artType) || CoreArtifactTypes.InterfaceDataElementArray.equals(artType)) {
            ArtifactReadable element = this.orcsApi.getQueryFactory().fromBranch(branch).andId(artId).followFork(CoreRelationTypes.InterfaceElementArrayElement_Element, subQuery).follow(CoreRelationTypes.InterfaceStructureContent_Structure).asArtifact();
            elements.add(element);
        }
        elementMap.put(artId, elements);
        return elements;
    }

    private void narrowDiffsToConnection(MimChangeSummary summary, BranchId branch1, BranchId branch2, ArtifactId connectionId, ArtifactId view) {
        if (connectionId.isValid()) {
            LinkedList<ArtifactId> branch1Ids = new LinkedList<ArtifactId>();
            LinkedList<ArtifactId> branch2Ids = new LinkedList<ArtifactId>();
            for (MimChangeSummaryItem node : summary.getNodes().values()) {
                if (node.isDeleted()) {
                    branch2Ids.add(node.getArtId());
                    continue;
                }
                branch1Ids.add(node.getArtId());
            }
            LinkedList nodes = new LinkedList();
            if (!branch1Ids.isEmpty()) {
                nodes.addAll(this.orcsApi.getQueryFactory().fromBranch(branch1, view).andIds(branch1Ids).follow(CoreRelationTypes.InterfaceConnectionNode_Connection).asArtifacts());
            }
            if (!branch2Ids.isEmpty()) {
                nodes.addAll(this.orcsApi.getQueryFactory().fromBranch(branch1, view).andIds(branch2Ids).follow(CoreRelationTypes.InterfaceConnectionNode_Connection).asArtifacts());
            }
            for (ArtifactReadable node : nodes) {
                if (!node.getRelated(CoreRelationTypes.InterfaceConnectionNode_Connection).getList().stream().filter(c -> c.getArtifactId().equals(connectionId)).findAny().isEmpty()) continue;
                summary.getNodes().remove(node.getArtifactId());
            }
            LinkedList<MimChangeSummaryItem> connectionItems = new LinkedList<MimChangeSummaryItem>(summary.getConnections().values());
            for (MimChangeSummaryItem connection : connectionItems) {
                if (connection.getArtId().equals(connectionId)) continue;
                summary.getConnections().remove(connection.getArtId());
            }
            branch1Ids = new LinkedList();
            branch2Ids = new LinkedList();
            for (MimChangeSummaryItem message : summary.getMessages().values()) {
                if (message.isDeleted()) {
                    branch2Ids.add(message.getArtId());
                    continue;
                }
                branch1Ids.add(message.getArtId());
            }
            LinkedList messages = new LinkedList();
            if (!branch1Ids.isEmpty()) {
                messages.addAll(this.orcsApi.getQueryFactory().fromBranch(branch1, view).andIds(branch1Ids).follow(CoreRelationTypes.InterfaceConnectionMessage_Connection).asArtifacts());
            }
            if (!branch2Ids.isEmpty()) {
                messages.addAll(this.orcsApi.getQueryFactory().fromBranch(branch2, view).andIds(branch2Ids).follow(CoreRelationTypes.InterfaceConnectionMessage_Connection).asArtifacts());
            }
            for (ArtifactReadable message : messages) {
                if (!message.getRelated(CoreRelationTypes.InterfaceConnectionMessage_Connection).getList().stream().filter(c -> c.getArtifactId().equals(connectionId)).findAny().isEmpty()) continue;
                summary.getMessages().remove(message.getArtifactId());
            }
            branch1Ids = new LinkedList();
            branch2Ids = new LinkedList();
            for (MimChangeSummaryItem submessage : summary.getSubMessages().values()) {
                if (submessage.isDeleted()) {
                    branch2Ids.add(submessage.getArtId());
                    continue;
                }
                branch1Ids.add(submessage.getArtId());
            }
            LinkedList submessages = new LinkedList();
            if (!branch1Ids.isEmpty()) {
                submessages.addAll(this.orcsApi.getQueryFactory().fromBranch(branch1, view).andIds(branch1Ids).follow(CoreRelationTypes.InterfaceMessageSubMessageContent_Message).follow(CoreRelationTypes.InterfaceConnectionMessage_Connection).asArtifacts());
            }
            if (!branch2Ids.isEmpty()) {
                submessages.addAll(this.orcsApi.getQueryFactory().fromBranch(branch2, view).andIds(branch2Ids).follow(CoreRelationTypes.InterfaceMessageSubMessageContent_Message).follow(CoreRelationTypes.InterfaceConnectionMessage_Connection).asArtifacts());
            }
            for (ArtifactReadable submessage : submessages) {
                LinkedList connections = new LinkedList();
                for (ArtifactReadable msg : submessage.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_Message)) {
                    connections.addAll(msg.getRelated(CoreRelationTypes.InterfaceConnectionMessage_Connection).getList());
                }
                if (!connections.stream().filter(c -> c.getArtifactId().equals(connectionId)).findAny().isEmpty()) continue;
                summary.getSubMessages().remove(submessage.getArtifactId());
            }
            branch1Ids = new LinkedList();
            branch2Ids = new LinkedList();
            for (MimChangeSummaryItem structure : summary.getStructures().values()) {
                if (structure.isDeleted()) {
                    branch2Ids.add(structure.getArtId());
                    continue;
                }
                branch1Ids.add(structure.getArtId());
            }
            LinkedList structures = new LinkedList();
            if (!branch1Ids.isEmpty()) {
                structures.addAll(this.orcsApi.getQueryFactory().fromBranch(branch1, view).andIds(branch1Ids).follow(CoreRelationTypes.InterfaceSubMessageContent_SubMessage).follow(CoreRelationTypes.InterfaceMessageSubMessageContent_Message).follow(CoreRelationTypes.InterfaceConnectionMessage_Connection).asArtifacts());
            }
            if (!branch2Ids.isEmpty()) {
                structures.addAll(this.orcsApi.getQueryFactory().fromBranch(branch2, view).andIds(branch2Ids).follow(CoreRelationTypes.InterfaceSubMessageContent_SubMessage).follow(CoreRelationTypes.InterfaceMessageSubMessageContent_Message).follow(CoreRelationTypes.InterfaceConnectionMessage_Connection).asArtifacts());
            }
            for (ArtifactReadable structure : structures) {
                LinkedList connections = new LinkedList();
                for (ArtifactReadable sub : structure.getRelated(CoreRelationTypes.InterfaceSubMessageContent_SubMessage)) {
                    for (ArtifactReadable msg : sub.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_Message)) {
                        connections.addAll(msg.getRelated(CoreRelationTypes.InterfaceConnectionMessage_Connection).getList());
                    }
                }
                if (!connections.stream().filter(c -> c.getArtifactId().equals(connectionId)).findAny().isEmpty()) continue;
                summary.getStructures().remove(structure.getArtifactId());
            }
        }
    }
}

