/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.osee.define.rest.internal.TraceMatch;
import org.eclipse.osee.framework.jdk.core.type.CaseInsensitiveString;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class TraceAccumulator {
    private final SetMultimap<CaseInsensitiveString, String> traceMarkToFiles = HashMultimap.create();
    private final SetMultimap<String, String> fileToMalformeddMarks = HashMultimap.create();
    private final LinkedList<String> noTraceFiles = new LinkedList();
    private final Pattern filePattern;
    private final Iterable<TraceMatch> traceMatches;
    private SetMultimap<String, CaseInsensitiveString> fileToTraceMarks;
    private String relativePath;

    public TraceAccumulator(String filePattern, Iterable<TraceMatch> traceMatches) {
        this.filePattern = Pattern.compile(filePattern);
        this.traceMatches = traceMatches;
    }

    public TraceAccumulator(String filePattern, TraceMatch traceMatch) {
        this(filePattern, Collections.singletonList(traceMatch));
    }

    public void extractTraces(File root) throws IOException {
        if (root == null || root.getParentFile() == null) {
            throw new OseeArgumentException("The path [%s] is invalid.", new Object[]{root});
        }
        this.checkDirectory(root);
        if (root.isFile()) {
            for (String path : Lib.readListFromFile((File)root, (boolean)true)) {
                this.traceFile(new File(path));
            }
        } else if (root.isDirectory()) {
            this.traceFile(root);
        } else {
            throw new OseeArgumentException("Invalid directory path [%s]", new Object[]{root.getCanonicalPath()});
        }
        this.fileToTraceMarks = (SetMultimap)Multimaps.invertFrom(this.traceMarkToFiles, (Multimap)HashMultimap.create());
    }

    private void traceFile(File root) throws IOException {
        String canonicalPath = root.getCanonicalPath();
        int prefixLength = canonicalPath.length();
        int index = canonicalPath.indexOf(".ss\\");
        String virtualPrefix = index == -1 ? "" : canonicalPath.substring(canonicalPath.lastIndexOf(92, index) + 1, index + 4);
        for (File sourceFile : Lib.recursivelyListFilesAndDirectories(new ArrayList(400), (File)root, (Pattern)this.filePattern, (boolean)false)) {
            this.relativePath = String.valueOf(virtualPrefix) + sourceFile.toString().substring(prefixLength + 1);
            int traceCount = this.parseInputStream(new FileInputStream(sourceFile));
            if (traceCount != 0) continue;
            this.noTraceFiles.add(this.relativePath);
        }
    }

    public void addInvalidTrace(String invalidTrace) {
        this.fileToMalformeddMarks.put((Object)this.relativePath, (Object)invalidTrace);
    }

    public void addValidTrace(String traceMark) {
        this.traceMarkToFiles.put((Object)new CaseInsensitiveString(traceMark), (Object)this.relativePath);
    }

    public int parseInputStream(InputStream providedStream) {
        int numTracesInStream = 0;
        try (Scanner scanner = new Scanner(providedStream, "UTF-8");){
            block3: while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                for (TraceMatch traceMatch : this.traceMatches) {
                    int numTracesInLine = traceMatch.processLine(line, this);
                    numTracesInStream += numTracesInLine;
                    if (numTracesInLine > 0) continue block3;
                }
            }
        }
        return numTracesInStream;
    }

    private void checkDirectory(File file) throws IOException {
        if (!file.exists()) {
            throw new OseeArgumentException("Input file does not exist: %s", new Object[]{file.getPath()});
        }
        if (file.isFile()) {
            for (String path : Lib.readListFromFile((File)file, (boolean)true)) {
                File embeddedPath = new File(path);
                if (embeddedPath.exists()) continue;
                throw new OseeCoreException("Bad path embedded in file: %s", new Object[]{path});
            }
        }
    }

    public Set<String> getFiles(String requirement) {
        return this.traceMarkToFiles.get((Object)new CaseInsensitiveString(requirement));
    }

    public Set<String> getFiles() {
        return this.fileToTraceMarks.keySet();
    }

    public Set<CaseInsensitiveString> getTraceMarks(String codeUnit) {
        return this.fileToTraceMarks.get((Object)codeUnit);
    }

    public Set<CaseInsensitiveString> getTraceMarks() {
        return this.traceMarkToFiles.keySet();
    }

    public LinkedList<String> getNoTraceFiles() {
        return this.noTraceFiles;
    }

    public Set<String> getMalformedMarks(String file) {
        return this.fileToMalformeddMarks.get((Object)file);
    }

    public Set<String> getFilesWithMalformedMarks() {
        return this.fileToMalformeddMarks.keySet();
    }
}

