/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.define.rest.internal.SafetyCriticalityLookup;
import org.eclipse.osee.define.rest.internal.SafetyReportGenerator;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;

public final class SafetyInformationAccumulator {
    private final ISheetWriter writer;
    private final SafetyReportGenerator safetyReport;
    private String functionalCategory;
    private List<ArtifactReadable> subsystemFunctions;
    private final HashMap<ArtifactReadable, List<ArtifactReadable>> subsystemRequirements = Maps.newHashMap();
    private final HashMap<ArtifactReadable, List<ArtifactReadable>> softwareRequirements = Maps.newHashMap();
    private static final Predicate<ArtifactReadable> notSoftwareRequirement = new Predicate<ArtifactReadable>(){

        public boolean apply(ArtifactReadable input) {
            boolean toReturn = true;
            try {
                toReturn = !input.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SoftwareRequirementMsWord});
            }
            catch (OseeCoreException oseeCoreException) {}
            return toReturn;
        }
    };

    public SafetyInformationAccumulator(SafetyReportGenerator providedSafetyReport, ISheetWriter providedWriter) {
        this.safetyReport = providedSafetyReport;
        this.writer = providedWriter;
    }

    public String calculateBoeingEquivalentSWQualLevel(String softwareReqDAL, int partitionCount) {
        String toReturn = "";
        if (this.functionalCategory.equals("IFR/IMC")) {
            toReturn = this.checkLevel(softwareReqDAL) ? (partitionCount > 1 ? "C*" : "C") : "BP";
        } else if (this.functionalCategory.equals("Tactical")) {
            toReturn = "BP";
        }
        return toReturn;
    }

    public void reset(ArtifactReadable systemFunction) {
        this.functionalCategory = systemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FunctionalCategory, "");
        this.subsystemRequirements.clear();
        this.softwareRequirements.clear();
    }

    public void buildSubsystemsRequirementsMap(ArtifactReadable systemFunction) {
        this.subsystemFunctions = Lists.newArrayList((Iterable)systemFunction.getRelated(CoreRelationTypes.Dependency_Dependency));
        Iterator<ArtifactReadable> sfIter = this.subsystemFunctions.iterator();
        while (sfIter.hasNext()) {
            ArtifactReadable subsystemFunction = sfIter.next();
            List<ArtifactReadable> localSubsystemRequirements = this.checkSubsystemRequirements(subsystemFunction);
            if (localSubsystemRequirements.isEmpty()) {
                sfIter.remove();
                continue;
            }
            this.subsystemRequirements.put(subsystemFunction, localSubsystemRequirements);
        }
    }

    private List<ArtifactReadable> checkSubsystemRequirements(ArtifactReadable subsystemFunction) {
        ArrayList localSubsystemRequirements = Lists.newArrayList((Iterable)subsystemFunction.getRelated(CoreRelationTypes.Design_Requirement));
        Iterator ssrIter = localSubsystemRequirements.iterator();
        while (ssrIter.hasNext()) {
            ArtifactReadable subsystemRequirement = (ArtifactReadable)ssrIter.next();
            ArrayList localSoftwareRequirements = Lists.newArrayList((Iterable)subsystemRequirement.getRelated(CoreRelationTypes.RequirementTrace_LowerLevelRequirement));
            Iterables.removeIf((Iterable)localSoftwareRequirements, notSoftwareRequirement);
            if (localSoftwareRequirements.isEmpty()) {
                ssrIter.remove();
                continue;
            }
            this.softwareRequirements.put(subsystemRequirement, localSoftwareRequirements);
        }
        return localSubsystemRequirements;
    }

    public void output(String[] currentRowValues) throws IOException {
        for (ArtifactReadable subsystemFunction : this.subsystemFunctions) {
            this.processSubsystemFunction(subsystemFunction, currentRowValues);
        }
    }

    private boolean checkLevel(String input) {
        boolean toReturn = false;
        if (input.equals("A") || input.equals("B") || input.equals("C")) {
            toReturn = true;
        }
        return toReturn;
    }

    private String convertSafetyCriticalityToDAL(String inputSafetyCriticality) {
        if (inputSafetyCriticality.length() > 4) {
            return "Error";
        }
        return SafetyCriticalityLookup.getDALLevelFromSeverityCategory(inputSafetyCriticality);
    }

    private void processSubsystemFunction(ArtifactReadable subsystemFunction, String[] currentRowValues) throws IOException {
        this.writeCell(subsystemFunction.getName(), currentRowValues, SafetyReportGenerator.SUBSYSTEM_FUNCTION_INDEX);
        String sevCat = subsystemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.SeverityCategory, "Error: not available");
        this.writeCell(sevCat, currentRowValues, SafetyReportGenerator.SUBSYSTEM_FUNCTION_INDEX + 1);
        for (ArtifactReadable subsystemRequirement : this.subsystemRequirements.get(subsystemFunction)) {
            this.processSubsystemRequirement(subsystemRequirement, this.convertSafetyCriticalityToDAL(sevCat), currentRowValues);
        }
        this.writer.writeRow((Object[])currentRowValues);
    }

    private void writeCell(String value, String[] currentRow, int col) {
        currentRow[col] = value;
    }

    private void processSubsystemRequirement(ArtifactReadable subsystemRequirement, String criticality, String[] currentRowValues) throws IOException {
        this.writeCell(subsystemRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem, ""), currentRowValues, SafetyReportGenerator.SUBSYSTEM_INDEX);
        this.writeCell((String)subsystemRequirement.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)""), currentRowValues, SafetyReportGenerator.SUBSYSTEM_INDEX + 1);
        this.writeCell(subsystemRequirement.getName(), currentRowValues, SafetyReportGenerator.SUBSYSTEM_INDEX + 2);
        this.writeCell(subsystemRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LegacyDal, ""), currentRowValues, SafetyReportGenerator.SUBSYSTEM_INDEX + 3);
        for (ArtifactReadable softwareRequirement : this.softwareRequirements.get(subsystemRequirement)) {
            this.processSoftwareRequirement(softwareRequirement, currentRowValues);
        }
        this.writer.writeRow((Object[])currentRowValues);
    }

    private String writeCriticality(ArtifactReadable art, AttributeTypeToken thisType, String[] currentRowValues, int col) {
        String current = art.getSoleAttributeAsString(thisType, "Error");
        if ("Error".equals(current)) {
            this.writeCell("Error: invalid content", currentRowValues, col);
            return "Error";
        }
        if ("Unspecified".equals(current)) {
            this.writeCell("Unspecified", currentRowValues, col);
            return "Unspecified";
        }
        this.writeCell(current, currentRowValues, col);
        return current;
    }

    private void processSoftwareRequirement(ArtifactReadable softwareRequirement, String[] currentRowValues) throws IOException {
        this.writeCell(softwareRequirement.getName(), currentRowValues, SafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX);
        String softwareRequirementDAL = this.writeCriticality(softwareRequirement, (AttributeTypeToken)CoreAttributeTypes.LegacyDal, currentRowValues, SafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 1);
        this.writeCell(this.calculateBoeingEquivalentSWQualLevel(softwareRequirementDAL, softwareRequirement.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Partition)), currentRowValues, SafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 2);
        this.writeCell(this.functionalCategory, currentRowValues, SafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 3);
        this.writeCell(softwareRequirement.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.Partition), currentRowValues, SafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 4);
        this.writeCell(this.safetyReport.getComponentUtil().getQualifiedComponentNames(softwareRequirement), currentRowValues, SafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 5);
        Collection<String> codeUnits = this.safetyReport.getRequirementToCodeUnitsValues(softwareRequirement);
        if (Conditions.hasValues(codeUnits)) {
            for (String codeUnit : codeUnits) {
                this.writeCell(codeUnit, currentRowValues, SafetyReportGenerator.CODE_UNIT_INDEX);
                this.writer.writeRow((Object[])currentRowValues);
            }
        } else {
            this.writer.writeRow((Object[])currentRowValues);
        }
    }
}

