/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.ForeignThingFamily;
import org.eclipse.osee.define.operations.synchronization.SimpleForeignThingFamily;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder.ReqIFSynchronizationArtifactBuilder;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;

public class AttributeValueUtils {
    private AttributeValueUtils() {
    }

    public static Optional<String> getAttributeDefinitionIdentifier(AttributeValue attributeValue) {
        AttributeDefinitionBoolean attributeDefinition = attributeValue instanceof AttributeValueBoolean ? ((AttributeValueBoolean)attributeValue).getDefinition() : (attributeValue instanceof AttributeValueDate ? ((AttributeValueDate)attributeValue).getDefinition() : (attributeValue instanceof AttributeValueEnumeration ? ((AttributeValueEnumeration)attributeValue).getDefinition() : (attributeValue instanceof AttributeValueInteger ? ((AttributeValueInteger)attributeValue).getDefinition() : (attributeValue instanceof AttributeValueReal ? ((AttributeValueReal)attributeValue).getDefinition() : (attributeValue instanceof AttributeValueString ? ((AttributeValueString)attributeValue).getDefinition() : (attributeValue instanceof AttributeValueXHTML ? ((AttributeValueXHTML)attributeValue).getDefinition() : null))))));
        return Objects.nonNull(attributeDefinition) ? Optional.ofNullable(attributeDefinition.getIdentifier()) : Optional.empty();
    }

    static Stream<ForeignThingFamily> extract(ReqIFSynchronizationArtifactBuilder builder) {
        return Arrays.stream(new Stream[]{builder.reqIf.getCoreContent().getSpecifications().stream().flatMap(specification -> specification.getValues().stream().map(attributeValue -> new SimpleForeignThingFamily(attributeValue, new String[]{specification.getIdentifier(), "AV-" + Long.toString(builder.getAndIncrementAttributeValueCount())}, new IdentifierType[]{IdentifierType.SPECIFICATION, IdentifierType.ATTRIBUTE_VALUE}))), builder.reqIf.getCoreContent().getSpecObjects().stream().flatMap(specObject -> reqIFSynchronizationArtifactBuilder.specObjectMap.containsKey(specObject.getIdentifier()) ? specObject.getValues().stream().map(attributeValue -> new SimpleForeignThingFamily(attributeValue, new String[]{specObject.getIdentifier(), "AV-" + Long.toString(builder.getAndIncrementAttributeValueCount())}, new IdentifierType[]{IdentifierType.SPEC_OBJECT, IdentifierType.ATTRIBUTE_VALUE})) : specObject.getValues().stream().map(attributeValue -> new SimpleForeignThingFamily(attributeValue, new String[]{specObject.getIdentifier(), "AV-" + Long.toString(builder.getAndIncrementAttributeValueCount())}, new IdentifierType[]{IdentifierType.SPECTER_SPEC_OBJECT, IdentifierType.ATTRIBUTE_VALUE}))), builder.reqIf.getCoreContent().getSpecRelations().stream().flatMap(specRelation -> specRelation.getValues().stream().map(attributeValue -> new SimpleForeignThingFamily(attributeValue, new String[]{specRelation.getIdentifier(), "AV-" + Long.toString(builder.getAndIncrementAttributeValueCount())}, new IdentifierType[]{IdentifierType.SPEC_RELATION, IdentifierType.ATTRIBUTE_VALUE})))}).flatMap(inStream -> inStream);
    }
}

