/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.reports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.eclipse.osee.define.operations.api.DefineOperations;
import org.eclipse.osee.define.operations.api.publisher.publishing.PublishingOperations;
import org.eclipse.osee.define.rest.api.publisher.publishing.PublishingRequestData;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.framework.core.applicability.ApplicabilityUseResultToken;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.publishing.EnumRendererMap;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;

public final class FeatureImpactStreamingOutput
implements StreamingOutput {
    private static final String rendererIdentifier = "org.eclipse.osee.define.operation.reports.featureimpact";
    private static final PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest("org.eclipse.osee.define.operation.reports.featureimpact", null, PresentationType.PREVIEW.name(), null, FormatIndicator.WORD_ML);
    private static final RendererMap commonPublishingRendererOptions = RendererMap.of((Object[])new Object[]{RendererOption.PUBLISH_IDENTIFIER, "Feature Impact Streaming Output", RendererOption.LINK_TYPE, LinkType.INTERNAL_DOC_REFERENCE_USE_NAME, RendererOption.MAX_OUTLINE_DEPTH, 9, RendererOption.PUBLISHING_FORMAT, FormatIndicator.WORD_ML});
    private final Branch branchId;
    private final OrcsApi orcsApi;
    private final PublishingOperations publishingOperations;
    private final boolean publishUpdatedDocs;
    private final List<ArtifactTypeToken> artTypes;
    private final List<AttributeTypeToken> attrTypes;

    public FeatureImpactStreamingOutput(Branch branch, OrcsApi orcsApi, DefineOperations defineOperations, boolean publishUpdatedDocs, List<ArtifactTypeToken> artTypes, List<AttributeTypeToken> attrTypes) {
        this.branchId = branch;
        this.orcsApi = orcsApi;
        this.publishingOperations = defineOperations.getPublisherOperations().getPublishingOperations();
        this.publishUpdatedDocs = publishUpdatedDocs;
        this.artTypes = artTypes;
        this.attrTypes = attrTypes;
    }

    /*
     * WARNING - void declaration
     */
    public void write(OutputStream output) {
        block43: {
            Branch branch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId((BranchId)this.branchId)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
            BranchId parentBranchIdentifier = branch.getParentBranch();
            ZipOutputStream zipOut = new ZipOutputStream(output);
            List changes = this.orcsApi.getBranchOps().compareBranch((BranchId)branch);
            List viewsForBranch = this.orcsApi.getQueryFactory().applicabilityQuery().getViewsForBranch((BranchId)branch).stream().map(a -> a.getToken()).collect(Collectors.toList());
            TreeMap featureViewsImpacted = new TreeMap();
            TreeMap<String, Pair> artViewsToCompare = new TreeMap<String, Pair>();
            List collect = changes.stream().filter(a -> a.getChangeType().equals((Object)ChangeType.Tuple) && a.getItemTypeId().equals(CoreTupleTypes.ViewApplicability)).collect(Collectors.toList());
            for (ChangeItem changeItem : collect) {
                String value = changeItem.getNetChange().getValue();
                String viewStr = value.substring(value.indexOf("|") + 1, value.indexOf(","));
                ArtifactToken artifactToken = viewsForBranch.stream().filter(a -> a.getIdString().equals(viewStr)).findFirst().get();
                String appId = value.substring(value.indexOf(",") + 1).trim();
                ApplicabilityToken app = ApplicabilityToken.valueOf((long)Long.parseLong(appId), (String)this.orcsApi.getKeyValueOps().getByKey(Id.valueOf((String)appId)));
                if (featureViewsImpacted.get(app) == null) {
                    featureViewsImpacted.put(app, new TreeMap());
                    ((TreeMap)featureViewsImpacted.get(app)).put(artifactToken, changeItem.getNetChange().getModType().getName());
                    continue;
                }
                ((TreeMap)featureViewsImpacted.get(app)).put(artifactToken, changeItem.getNetChange().getModType().getName());
            }
            for (Map.Entry entry : featureViewsImpacted.entrySet()) {
                for (ApplicabilityUseResultToken usage : this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityUsage((BranchId)this.branchId, ((ApplicabilityToken)entry.getKey()).getName(), this.artTypes, this.attrTypes)) {
                    for (ArtifactReadable artifactReadable : usage.getArts()) {
                        for (Map.Entry viewEntry : ((TreeMap)entry.getValue()).entrySet()) {
                            artViewsToCompare.put(String.valueOf(artifactReadable.getName()) + "_" + ((ArtifactToken)viewEntry.getKey()).getName(), new Pair((Object)artifactReadable, (Object)((ArtifactToken)viewEntry.getKey())));
                        }
                    }
                }
            }
            try {
                Throwable throwable = null;
                Iterator<Object> iterator = null;
                try (OutputStreamWriter writer = new OutputStreamWriter(zipOut);){
                    if (artViewsToCompare.isEmpty()) break block43;
                    zipOut.putNextEntry(new ZipEntry("SummaryOfChanges.csv"));
                    PrintWriter summary = new PrintWriter(writer);
                    summary.println("Applicability Modified, Views Impacted (change type)");
                    summary.println();
                    for (Map.Entry entry : featureViewsImpacted.entrySet()) {
                        summary.print(String.valueOf(((ApplicabilityToken)entry.getKey()).getName()) + ",");
                        for (Map.Entry pair : ((TreeMap)entry.getValue()).entrySet()) {
                            summary.print(pair.getKey() + " (" + ((String)pair.getValue()).replace("New", "Added") + "); ");
                        }
                        summary.println();
                    }
                    summary.println();
                    summary.println("Artifact Impacted, Artifact Name, Artifact Applicability");
                    for (ArtifactReadable artifactReadable : artViewsToCompare.entrySet().stream().map(a -> (ArtifactReadable)((Pair)a.getValue()).getFirst()).distinct().collect(Collectors.toList())) {
                        summary.println(String.valueOf(artifactReadable.getIdString()) + "," + artifactReadable.getName() + "," + artifactReadable.getApplicabilityToken().getName());
                    }
                    summary.flush();
                    zipOut.closeEntry();
                    if (!this.publishUpdatedDocs) break block43;
                    for (Map.Entry entry : artViewsToCompare.entrySet()) {
                        ArtifactReadable previewHeadArtifactIdentifier = (ArtifactReadable)((Pair)entry.getValue()).getFirst();
                        ArtifactId previewViewArtifactIdentifier = ArtifactId.valueOf((Id)((Id)((Pair)entry.getValue()).getSecond()));
                        BranchId workingDocBranchWithoutView = BranchId.valueOf((Long)branch.getId());
                        BranchId baselineDocBranchWithoutView = BranchId.valueOf((Long)parentBranchIdentifier.getId());
                        EnumRendererMap workingDocRendererOptions = new EnumRendererMap(commonPublishingRendererOptions);
                        workingDocRendererOptions.setRendererOption(RendererOption.BRANCH, (Object)workingDocBranchWithoutView);
                        workingDocRendererOptions.setRendererOption(RendererOption.VIEW, (Object)previewViewArtifactIdentifier);
                        EnumRendererMap baselineDocRendererOptions = new EnumRendererMap(commonPublishingRendererOptions);
                        baselineDocRendererOptions.setRendererOption(RendererOption.BRANCH, (Object)baselineDocBranchWithoutView);
                        baselineDocRendererOptions.setRendererOption(RendererOption.VIEW, (Object)previewViewArtifactIdentifier);
                        PublishingRequestData workingDocMsWordPreviewRequestData = new PublishingRequestData(publishingTemplateRequest, (RendererMap)workingDocRendererOptions, List.of(previewHeadArtifactIdentifier));
                        PublishingRequestData baselineDocMsWordPreviewRequestData = new PublishingRequestData(publishingTemplateRequest, (RendererMap)baselineDocRendererOptions, List.of(previewHeadArtifactIdentifier));
                        Throwable throwable2 = null;
                        Object var25_42 = null;
                        try (InputStream workingDocStream = this.publishingOperations.msWordPreview(workingDocMsWordPreviewRequestData).getDataHandler().getInputStream();){
                            Throwable throwable3 = null;
                            Object var28_47 = null;
                            try (InputStream baselineDocStream = this.publishingOperations.msWordPreview(baselineDocMsWordPreviewRequestData).getDataHandler().getInputStream();){
                                workingDocStream.mark(0);
                                boolean equal = IOUtils.contentEquals((InputStream)workingDocStream, (InputStream)baselineDocStream);
                                baselineDocStream.close();
                                if (!equal) {
                                    PrintWriter docWriter = new PrintWriter(writer);
                                    workingDocStream.reset();
                                    zipOut.putNextEntry(new ZipEntry(String.valueOf((String)entry.getKey()) + ".xml"));
                                    try {
                                        String l;
                                        InputStreamReader reader = new InputStreamReader(workingDocStream, "UTF-8");
                                        BufferedReader br = new BufferedReader(reader);
                                        while ((l = br.readLine()) != null) {
                                            docWriter.println(l);
                                        }
                                        docWriter.flush();
                                        br.close();
                                        reader.close();
                                        workingDocStream.close();
                                    }
                                    catch (IOException ex) {
                                        OseeCoreException.wrapAndThrow((Throwable)ex);
                                    }
                                    zipOut.closeEntry();
                                    continue;
                                }
                                workingDocStream.close();
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable6) {
                    void var10_18;
                    if (throwable == null) {
                        Throwable throwable7 = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw var10_18;
                }
            }
            catch (IOException iOException) {
                OseeCoreException.wrapAndThrow((Throwable)iOException);
            }
        }
    }
}

