/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.publishing;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionDetails;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingArtifactBase;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class WordRenderArtifactWrapperServerImpl
extends PublishingArtifactBase {
    PublishingArtifact.Applicability applicable;
    private final ArtifactReadable artifact;
    private BranchToken branchToken;

    public WordRenderArtifactWrapperServerImpl(Object artifact) {
        Objects.requireNonNull(artifact, "WordRenderArtifactWrapperServerImpl::new, parameter \"artifact\" cannont be null.");
        if (!(artifact instanceof ArtifactReadable)) {
            throw new IllegalArgumentException("WordRenderArtifactWrapperServerImpl::new, parameter \"artifact\" must be an instance of \"ArtifactReadable\".");
        }
        if (((ArtifactReadable)artifact).isInvalid()) {
            throw new IllegalArgumentException("WordRenderArtifactWrapperServerImpl::new, parameter \"artifact\" cannont be sentinel.");
        }
        this.artifact = (ArtifactReadable)artifact;
        BranchToken artifactBranchToken = this.artifact.getBranch();
        this.branchToken = BranchToken.create((Long)artifactBranchToken.getId(), (String)artifactBranchToken.getName(), (ArtifactId)ArtifactId.SENTINEL);
        this.applicable = PublishingArtifact.Applicability.YES;
    }

    public WordRenderArtifactWrapperServerImpl(Object artifact, BranchSpecification branchSpecification) {
        Objects.requireNonNull(artifact, "WordRenderArtifactWrapperServerImpl::new, parameter \"artifact\" cannont be null.");
        if (!(artifact instanceof ArtifactReadable)) {
            throw new IllegalArgumentException("WordRenderArtifactWrapperServerImpl::new, parameter \"artifact\" must be an instance of \"ArtifactReadable\".");
        }
        if (((ArtifactReadable)artifact).isInvalid()) {
            throw new IllegalArgumentException("WordRenderArtifactWrapperServerImpl::new, parameter \"artifact\" cannont be sentinel.");
        }
        Objects.requireNonNull(branchSpecification);
        this.artifact = (ArtifactReadable)artifact;
        BranchToken artifactBranchToken = this.artifact.getBranch();
        assert (artifactBranchToken.isSameBranch(branchSpecification.getBranchId())) : new Message().title((CharSequence)"WordRenderArtifactWrapperServerImpl::new, parameter \"branchSpecification\" is for a different branch than the parameter \"artifact\".").indentInc().segment((CharSequence)"Artifact Branch", (Object)this.artifact.getBranch().getIdString()).segment((CharSequence)"Branch Specification Branch", (Object)branchSpecification.getBranchId().getIdString()).toString();
        this.branchToken = BranchToken.create((Long)artifactBranchToken.getId(), (String)artifactBranchToken.getName(), (ArtifactId)branchSpecification.getViewId());
        this.applicable = branchSpecification.getViewId().isValid() ? PublishingArtifact.Applicability.YES : PublishingArtifact.Applicability.UNKNOWN;
    }

    public boolean areRelated(RelationTypeSide typeAndSide, ArtifactReadable artifact) {
        throw new UnsupportedOperationException();
    }

    public boolean branchHasView() {
        ArtifactId viewId = this.branchToken.getViewId();
        return Objects.nonNull(viewId) && viewId.isValid();
    }

    public void clearBranchView() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        return this.artifact.equals(other);
    }

    public List<String> fetchAttributesAsStringList(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public ApplicabilityId getApplicability() {
        return this.artifact.getApplicability();
    }

    public ApplicabilityToken getApplicabilityToken() {
        throw new UnsupportedOperationException();
    }

    public ArtifactReadable getArtifact() {
        return this.artifact;
    }

    public ArtifactId getArtifactId() {
        return ArtifactId.create((Id)this.artifact);
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifact.getArtifactType();
    }

    public String getArtifactTypeName() {
        return this.artifact.getArtifactType().getName();
    }

    public AttributeReadable<Object> getAttributeById(AttributeId attributeId) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeCount(AttributeTypeToken type) {
        return this.artifact.getAttributeCount(type);
    }

    public int getAttributeCount(AttributeTypeToken type, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable() {
        throw new UnsupportedOperationException();
    }

    public <T> List<IAttribute<T>> getAttributeList(AttributeTypeGeneric<T> attributeType) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes() {
        throw new UnsupportedOperationException();
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType) {
        if (attributeType instanceof AttributeTypeEnum && this.artifact instanceof ArtifactReadable.ArtifactReadableImpl) {
            List list = this.artifact.getAttributeValues(attributeType).stream().filter(Objects::nonNull).map(enumToken -> ((EnumToken)enumToken).getName()).filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
        return this.artifact.getAttributeValues(attributeType);
    }

    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public String getAttributeValuesAsString(AttributeTypeToken attributeType) {
        return this.artifact.getAttributeValuesAsString(attributeType);
    }

    public BranchToken getBranch() {
        return this.branchToken;
    }

    public List<ArtifactReadable> getChildren() {
        int childOutlineLevel = this.getOutlineLevel() + 1;
        LinkedList children = this.artifact.getChildren().stream().map(WordRenderArtifactWrapperServerImpl::new).peek(artifact -> artifact.setOutlineLevel(childOutlineLevel)).collect(Collectors.toCollection(LinkedList::new));
        if (!children.isEmpty()) {
            ((PublishingArtifact)children.getFirst()).setStartOfSection();
            ((PublishingArtifact)children.getLast()).setEndOfSection();
        }
        List artifactReadableChildren = children;
        return artifactReadableChildren;
    }

    public List<PublishingArtifact> getChildrenAsPublishingArtifacts() {
        List<ArtifactReadable> publishingArtifactChildren = this.getChildren();
        return publishingArtifactChildren;
    }

    public Collection<ArtifactId> getChildrenIds() {
        return this.artifact.getChildrenIds();
    }

    public <T> T getComputedCharacteristicValue(ComputedCharacteristicToken<T> computedCharacteristic) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getDescendants() {
        return this.artifact.getDescendants().stream().map(WordRenderArtifactWrapperServerImpl::new).collect(Collectors.toList());
    }

    public void getDescendants(List<ArtifactReadable> descendants) {
        throw new UnsupportedOperationException();
    }

    public Collection<AttributeTypeToken> getExistingAttributeTypes() {
        throw new UnsupportedOperationException();
    }

    public Collection<RelationTypeToken> getExistingRelationTypes() {
        throw new UnsupportedOperationException();
    }

    public String getGuid() {
        return this.artifact.getGuid();
    }

    public Long getId() {
        return this.artifact.getId();
    }

    public TransactionId getLastModifiedTransaction() {
        throw new UnsupportedOperationException();
    }

    public int getMaximumRelationAllowed(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public ModificationType getModificationType() {
        return this.artifact.getModificationType();
    }

    public String getName() {
        return this.artifact.getName();
    }

    public PublishingArtifact getParent() {
        ArtifactReadable parent = this.artifact.getParent();
        return Objects.nonNull(parent) ? new WordRenderArtifactWrapperServerImpl(parent) : null;
    }

    public String getRationale(RelationTypeSide typeAndSide, ArtifactReadable readable) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, DeletionFlag deletionFlag) {
        return this.artifact.getRelated(relationTypeSide, deletionFlag);
    }

    public int getRelatedCount(RelationTypeSide typeAndSide) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactId> getRelatedIds(RelationTypeSide relationTypeSide) {
        return this.artifact.getRelatedIds(relationTypeSide);
    }

    public List<ArtifactReadable> getRelatedList(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<IRelationLink> getRelations(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public String getSafeName() {
        throw new UnsupportedOperationException();
    }

    public String getSoleAttributeAsString(AttributeTypeToken attributeType) {
        return this.artifact.getSoleAttributeAsString(attributeType);
    }

    public String getSoleAttributeAsString(AttributeTypeToken attributeTypeToken, String defaultValue) {
        return this.artifact.getSoleAttributeAsString(attributeTypeToken, defaultValue);
    }

    public AttributeId getSoleAttributeId(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public Long getSoleAttributeId(AttributeTypeToken attributeType, Long defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType) {
        return (T)this.artifact.getSoleAttributeValue(attributeType);
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, DeletionFlag flag, T defaultValue) {
        return (T)this.artifact.getSoleAttributeValue(attributeType, flag, defaultValue);
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeTypeToken, T defaultValue) {
        return (T)this.artifact.getSoleAttributeValue(attributeTypeToken, defaultValue);
    }

    public TransactionId getTransaction() {
        return this.artifact.getTransaction();
    }

    public Collection<AttributeTypeToken> getValidAttributeTypes() {
        return this.artifact.getValidAttributeTypes();
    }

    public Collection<RelationTypeToken> getValidRelationTypes() {
        throw new UnsupportedOperationException();
    }

    public boolean hasAttributeContent(AttributeTypeToken attributeTypeToken) {
        return attributeTypeToken != null && this.artifact.isAttributeTypeValid((AttributeTypeId)attributeTypeToken) && this.artifact.getAttributeCount(attributeTypeToken) > 0;
    }

    public int hashCode() {
        return this.artifact.hashCode();
    }

    public PublishingArtifact.Applicability isApplicable() {
        return this.applicable;
    }

    public boolean isAttributeTypeValid(AttributeTypeId attributeType) {
        return this.artifact.isAttributeTypeValid(attributeType);
    }

    public boolean isDescendantOf(ArtifactToken parent) {
        throw new UnsupportedOperationException();
    }

    public boolean isFound() {
        return true;
    }

    public boolean isHistorical() {
        return this.artifact.isHistorical();
    }

    public boolean isInvalid() {
        return this.artifact.isInvalid();
    }

    public boolean isOfType(ArtifactTypeId ... artifactTypeId) {
        return this.artifact.isOfType(artifactTypeId);
    }

    public PublishingArtifact.TryReload isReloadable() {
        return PublishingArtifact.TryReload.NO;
    }

    public void setApplicable() {
        this.applicable = PublishingArtifact.Applicability.YES;
    }

    public void clearApplicable() {
        this.applicable = PublishingArtifact.Applicability.NO;
    }

    public void setBranchView(BranchSpecification branchSpecification) {
        assert (Objects.nonNull(branchSpecification) && branchSpecification.hasView() && (Objects.isNull(this.branchToken.getViewId()) || this.branchToken.getViewId().isInvalid()) && branchSpecification.getBranchId().getId().equals(this.branchToken.getId())) : new Message().title((CharSequence)"WordRenderArtifactWrapperServerImpl::setBranchView, Artifact and/or branchSpecification have unexpected values.").indentInc().segment((CharSequence)"Branch Token Identifier", (Object)this.branchToken.getId()).segment((CharSequence)"Branch Token View Identifier", Objects.nonNull(this.branchToken.getViewId()) ? this.branchToken.getViewId().getId() : "(null)").segment((CharSequence)"Branch Has View", (Object)this.branchHasView()).segment((CharSequence)"Is Applicable", (Object)this.isApplicable()).toMessage((ToMessage)branchSpecification).toString();
        this.branchToken = BranchToken.create((Long)branchSpecification.getBranchId().getId(), (String)this.branchToken.getName(), (ArtifactId)branchSpecification.getViewId());
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.isNull(message) ? new Message() : message;
        outMessage.indent(indent).title((CharSequence)"PublishingArtifact (WordRenderArtifactWrapperServerImpl)").indentInc().segment((CharSequence)"Identifier", (Object)this.getIdString()).segment((CharSequence)"GUID", (Object)this.getGuid()).segment((CharSequence)"Name", (Object)this.getName()).segment((CharSequence)"Type", (Object)this.getArtifactTypeName()).segment((CharSequence)"Processed", (Object)this.isProcessed()).segment((CharSequence)"Publishing Content Cached", (Object)this.isPublishingContentCached()).segment((CharSequence)"Branch Identifier", (Object)this.branchToken.getId()).segment((CharSequence)"Branch View", (Object)this.branchToken.getViewId()).segment((CharSequence)"Applicable", (Object)this.applicable).segment((CharSequence)"Wrapped Implementation Class", (Object)this.artifact.getClass().getName()).segmentIfNotNull((CharSequence)"Hierarchy Position", () -> this.getHierarchyPosition().stream().map(integer -> integer.toString()).collect(Collectors.joining(",")), (Object)(this.isHierarchyPositionSet() ? this : null)).segment((CharSequence)"Is HyperLinked", (Object)this.isHyperlinked()).segment((CharSequence)"Is Bookmarked", (Object)this.isBookmarked()).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    public HashCollection<AttributeTypeToken, IAttribute<?>> getAttributesHashCollection() {
        throw new UnsupportedOperationException();
    }

    public <T> AttributeReadable<T> getSoleAttribute(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public TransactionDetails getTxDetails() {
        throw new UnsupportedOperationException();
    }

    public <T> IAttribute<T> getSoleAttribute(AttributeTypeToken attributeType, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getReferenceArtifactsByType(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public ArtifactReadable getReferenceArtifactByAttrId(AttributeId attributeId) {
        throw new UnsupportedOperationException();
    }

    public GammaId getGamma() {
        throw new UnsupportedOperationException();
    }
}

