/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.publishing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.operations.api.publisher.datarights.DataRightsOperations;
import org.eclipse.osee.define.operations.api.publisher.publishing.PublishingOperations;
import org.eclipse.osee.define.operations.api.publisher.templatemanager.TemplateManagerOperations;
import org.eclipse.osee.define.operations.api.utils.AttachmentFactory;
import org.eclipse.osee.define.operations.markdown.MarkdownCleaner;
import org.eclipse.osee.define.operations.markdown.MarkdownConverter;
import org.eclipse.osee.define.operations.publisher.publishing.ChangedArtifactsTracker;
import org.eclipse.osee.define.operations.publisher.publishing.GeneralPublishingWordTemplateProcessorServer;
import org.eclipse.osee.define.operations.publisher.publishing.PublishingSharedArtifactsFolder;
import org.eclipse.osee.define.operations.publisher.publishing.WordRenderArtifactWrapperServerImpl;
import org.eclipse.osee.define.operations.publisher.publishing.WordTemplateContentRendererHandler;
import org.eclipse.osee.define.rest.api.ArtifactUrlServer;
import org.eclipse.osee.define.rest.api.publisher.publishing.LinkHandlerResult;
import org.eclipse.osee.define.rest.api.publisher.publishing.PublishingRequestData;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordUpdateChange;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordUpdateData;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUpdateArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.publishing.Cause;
import org.eclipse.osee.framework.core.publishing.DataAccessException;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.publishing.ProcessRecursively;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingArtifactLoader;
import org.eclipse.osee.framework.core.publishing.PublishingErrorLog;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.publishing.WordTemplateContentData;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.osgi.service.event.EventAdmin;

public class PublishingOperationsImpl
implements PublishingOperations {
    private static final int SMALL_PUBLISH_SIZE = 256;
    private static PublishingOperationsImpl publishingOperationsImpl = null;
    private final AtsApi atsApi;
    private final AttachmentFactory attachmentFactory;
    private final DataAccessOperations dataAccessOperations;
    private final DataRightsOperations dataRightsOperations;
    private final EventAdmin eventAdmin;
    private final Log logger;
    private final OrcsApi orcsApi;
    private final String permanentLinkUrl;
    private final TemplateManagerOperations templateManagerOperations;

    public static synchronized PublishingOperationsImpl create(OrcsApi orcsApi, AtsApi atsApi, Log logger, EventAdmin eventAdmin, DataAccessOperations dataAccessOperations, DataRightsOperations dataRightsOperations, TemplateManagerOperations templateManagerOperations) {
        return Objects.isNull(publishingOperationsImpl) ? (publishingOperationsImpl = new PublishingOperationsImpl(Objects.requireNonNull(orcsApi), Objects.requireNonNull(atsApi), Objects.requireNonNull(logger), Objects.requireNonNull(eventAdmin), Objects.requireNonNull(dataAccessOperations), Objects.requireNonNull(dataRightsOperations), Objects.requireNonNull(templateManagerOperations))) : publishingOperationsImpl;
    }

    public static synchronized void free() {
        publishingOperationsImpl = null;
    }

    private PublishingOperationsImpl(OrcsApi orcsApi, AtsApi atsApi, Log logger, EventAdmin eventAdmin, DataAccessOperations dataAccessOperations, DataRightsOperations dataRightsOperations, TemplateManagerOperations templateManagerOperations) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.logger = logger;
        this.eventAdmin = eventAdmin;
        this.dataAccessOperations = dataAccessOperations;
        this.dataRightsOperations = dataRightsOperations;
        this.templateManagerOperations = templateManagerOperations;
        this.permanentLinkUrl = new ArtifactUrlServer(this.orcsApi).getSelectedPermanentLinkUrl();
        this.attachmentFactory = new AttachmentFactory("MsWordPreview", "xml", this.dataAccessOperations);
    }

    public List<PublishingArtifact> getSharedPublishingArtifacts(BranchId branch, ArtifactId view, ArtifactId sharedFolder, ArtifactTypeToken artifactType, AttributeTypeToken attributeType, String attributeValue) {
        PublishingPack publishingPack;
        Message message = null;
        message = Conditions.require(message, (Object)branch, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"branch", (String)"cannot be null or negative", (Predicate)Conditions.or((Predicate[])new Predicate[]{Objects::isNull, p -> p.getId() < 0L}));
        message = Conditions.require((Message)message, (Object)view, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"view", (String)"cannot be null or less than minus one", (Predicate)Conditions.or((Predicate[])new Predicate[]{Objects::isNull, p -> p.getId() < -1L}));
        message = Conditions.require((Message)message, (Object)sharedFolder, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"sharedFolder", (String)"cannot be null or negative", (Predicate)Conditions.or((Predicate[])new Predicate[]{Objects::isNull, p -> p.getId() < 0L}));
        message = Conditions.require((Message)message, (Object)artifactType, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"artifactType", (String)"cannot be null or less than minus one", (Predicate)Conditions.or((Predicate[])new Predicate[]{Objects::isNull, p -> p.getId() < -1L}));
        message = Conditions.require((Message)message, (Object)attributeType, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"attributeType", (String)"cannot be null or less than minus one", (Predicate)Conditions.or((Predicate[])new Predicate[]{Objects::isNull, p -> p.getId() < -1L}));
        if (Objects.nonNull(message = Conditions.require((Message)message, (Object)attributeValue, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"attributeValue", (String)"cannot be null or an empty string", (Predicate)Conditions.or((Predicate[])new Predicate[]{Objects::isNull, String::isEmpty})))) {
            throw new IllegalArgumentException(Conditions.buildIllegalArgumentExceptionMessage((String)this.getClass().getSimpleName(), (String)"getSharedPublishingArtifacts", (Message)message));
        }
        try {
            BranchSpecification branchSpecification = new BranchSpecification(branch, view);
            publishingPack = new PublishingPack(branchSpecification);
        }
        catch (DataAccessException dataAccessException) {
            if (dataAccessException.getPublishingUtilCause().equals((Object)Cause.NOT_FOUND)) {
                throw new OseeNotFoundException(new Message().title((CharSequence)"PublishingOperationsImpl::getSharedPublishingArtifacts, Unable to locate the shared folder.").indentInc().segment((CharSequence)"Branch Identifier", (Object)branch).segment((CharSequence)"View Identifier", (Object)view).segment((CharSequence)"Shared Folder", (Object)sharedFolder).segment((CharSequence)"Artifact Type", (Object)artifactType).segment((CharSequence)"Attribute Type", (Object)attributeType).segment((CharSequence)"Attribute Value", (Object)attributeValue).indentDec().reasonFollows((Throwable)dataAccessException).toString(), (Throwable)dataAccessException);
            }
            throw new OseeCoreException(new Message().title((CharSequence)"PublishingOperationsImpl::getSharedPublishingArtifacts, Failed to load the shared folder.").indentInc().segment((CharSequence)"Branch Identifier", (Object)branch).segment((CharSequence)"View Identifier", (Object)view).segment((CharSequence)"Shared Folder", (Object)sharedFolder).segment((CharSequence)"Artifact Type", (Object)artifactType).segment((CharSequence)"Attribute Type", (Object)attributeType).segment((CharSequence)"Attribute Value", (Object)attributeValue).indentDec().reasonFollows((Throwable)dataAccessException).toString(), (Throwable)dataAccessException);
        }
        PublishingSharedArtifactsFolder publishingSharedArtifactsFolder = ArtifactTypeToken.SENTINEL.equals(artifactType) ? PublishingSharedArtifactsFolder.create(publishingPack.publishingArtifactLoader, publishingPack.publishingErrorLog, new BranchSpecification(branch, view), "Shared Artifacts Folder", ArtifactToken.valueOf((long)sharedFolder.getId(), (BranchId)branch), attributeType, ProcessRecursively.YES) : PublishingSharedArtifactsFolder.create(publishingPack.publishingArtifactLoader, publishingPack.publishingErrorLog, new BranchSpecification(branch, view), "Shared Artifacts Folder", ArtifactToken.valueOf((long)sharedFolder.getId(), (BranchId)branch), artifactType, attributeType, ProcessRecursively.YES);
        List<PublishingArtifact> sharedArtifacts = publishingSharedArtifactsFolder.getSharedArtifacts(attributeValue);
        if (publishingPack.publishingErrorLog.size() > 0) {
            StringBuilder errorLogMessage = new StringBuilder(1024);
            publishingPack.publishingErrorLog.publishErrorLog(errorLogMessage);
            throw new OseeNotFoundException(errorLogMessage.toString(), new Object[0]);
        }
        return sharedArtifacts;
    }

    public LinkHandlerResult link(BranchId branchId, ArtifactId viewId, ArtifactId artifactId, TransactionId transactionId, LinkType linkType, PresentationType presentationType) {
        return null;
    }

    public Attachment msWordPreview(PublishingRequestData msWordPreviewRequestData) {
        RendererMap publishingRendererOptions = msWordPreviewRequestData.getPublishingRendererOptions();
        ArtifactId firstArtifactId = (ArtifactId)msWordPreviewRequestData.getArtifactIds().get(0);
        ByteArrayInputStream inputStream = this.processPublishingRequest(msWordPreviewRequestData, publishingRendererOptions);
        Attachment attachment = this.attachmentFactory.create((InputStream)inputStream, (CharSequence)publishingRendererOptions.getRendererOptionValue(RendererOption.PUBLISH_IDENTIFIER), (BranchId)publishingRendererOptions.getRendererOptionValue(RendererOption.BRANCH), firstArtifactId, new CharSequence[0]);
        return attachment;
    }

    private ByteArrayInputStream processPublishingRequest(PublishingRequestData publishingRequestData, RendererMap publishingRendererOptions) {
        Conditions.require((Object)publishingRequestData, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"publishingRequestData", (String)"cannot be null", Objects::isNull, NullPointerException::new, (String)"cannot be invalid", p -> !p.isValid(), IllegalArgumentException::new);
        PublishingTemplateRequest publishingTemplateRequest = publishingRequestData.getPublishingTemplateRequest();
        List publishArtifacts = publishingRequestData.getArtifactIds();
        PublishingTemplate publishingTemplate = this.templateManagerOperations.getPublishingTemplate(publishingTemplateRequest);
        if (publishingTemplate.isSentinel()) {
            String message = new Message().title((CharSequence)"PublishingOperationsImpl::msWordPreviewInternal: Failed to find a publishing template.").indentInc().toMessage((ToMessage)publishingRequestData).toString();
            this.logger.error(message, new Object[0]);
            throw new OseeCoreException(message, new Object[0]);
        }
        var outputStream = new ByteArrayOutputStream(){

            byte[] getBuffer() {
                return this.buf;
            }
        };
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
                new GeneralPublishingWordTemplateProcessorServer(this.orcsApi, this.atsApi, this.dataAccessOperations, this.dataRightsOperations).configure(publishingTemplate, publishingRendererOptions, publishingRequestData.getDesktopClientLoopbackUrl()).applyTemplate(publishArtifacts, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"PublishingOperationsImpl::msWordPreviewIntenal, Failed to publish document.").indentInc().toMessage((ToMessage)publishingRequestData).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
        return new ByteArrayInputStream(outputStream.getBuffer(), 0, outputStream.size());
    }

    public Attachment msWordWholeWordContentPublish(BranchId branchId, ArtifactId viewId, ArtifactId artifactId, TransactionId transactionId, LinkType linkType, PresentationType presentationType, boolean includeErrorLog) {
        return null;
    }

    public String renderPlainText(BranchId branchId, String data) {
        int lastIndex;
        String PL_STYLE_WITH_RETURN = "<w:rPr><w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>)).*?</w:rPr>";
        String PL_STYLE = "<w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>))";
        String PL_HIGHLIGHT = "<w:highlight w:val=\"light-gray\"></w:highlight><w:shd w:color=\"auto\" w:fill=\"BFBFBF\" w:val=\"clear\"></w:shd>";
        String EMPTY_PARAGRAPHS = "<w:r wsp:rsidRPr=\"\\d+\"><w:t></w:t></w:r>";
        CharSequence dataCharSequence = WordCoreUtil.replaceBinaryDataIdentifiers((CharSequence)data);
        data = WordMlLinkHandler.renderPlainTextWithoutLinks(this.orcsApi.getQueryFactory(), branchId, dataCharSequence.toString());
        data = WordCoreUtil.reassignBookMarkID((CharSequence)data).toString();
        CharSequence charSequenceData = WordCoreUtil.removeFootersAndNoDataRightsStatements((CharSequence)data);
        if (!(data = WordCoreUtil.replaceEmptySectionBreaksWithPageBreaks((CharSequence)charSequenceData).toString()).contains("<w:tbl>") && (lastIndex = data.lastIndexOf("<w:p wsp:rsidR=")) != -1) {
            String temp = data.substring(lastIndex);
            temp = temp.replaceAll("<w:p\\s[^>]*>(<w:pPr><w:spacing[^>]*></w:spacing></w:pPr>)?</w:p>", "");
            data = String.valueOf(data.substring(0, lastIndex)) + temp;
        }
        data = data.replaceAll(PL_STYLE_WITH_RETURN, "");
        data = data.replaceAll(PL_STYLE, "");
        data = data.replaceAll(PL_HIGHLIGHT, "");
        data = data.replaceAll(EMPTY_PARAGRAPHS, "");
        data = WordCoreUtil.removeReviewComments((CharSequence)data).toString();
        return data;
    }

    public Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData wordTemplateContentData) {
        Conditions.require((Object)wordTemplateContentData, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"wordTemplateContentData", (String)"cannot be null", Objects::isNull, NullPointerException::new, (String)"cannot be invalid", p -> !p.isValid(), IllegalArgumentException::new);
        WordTemplateContentRendererHandler wordRendererHandler = new WordTemplateContentRendererHandler(this.orcsApi, this.dataAccessOperations, this.logger);
        return wordRendererHandler.renderWordML(wordTemplateContentData);
    }

    public String renderWordTemplateContentWithApplicability(BranchId branchId, ArtifactId viewId, String data) {
        WordMLApplicabilityHandler wordHandler = new WordMLApplicabilityHandler(this.orcsApi, this.logger, branchId, viewId);
        return wordHandler.previewValidApplicabilityContent(data);
    }

    public LinkHandlerResult unlink(BranchId branchId, ArtifactId viewId, ArtifactId artifactId, TransactionId transactionId, LinkType linkType) {
        return null;
    }

    public String updateLinks(BranchId branchId) {
        return null;
    }

    public WordUpdateChange updateWordArtifacts(WordUpdateData wordUpdateData) {
        Conditions.require((Object)wordUpdateData, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"wordUpdateData", (String)"cannot be null", Objects::isNull, NullPointerException::new, (String)"is invalid", p -> !p.isValid(), IllegalArgumentException::new);
        WordUpdateArtifact updateArt = new WordUpdateArtifact(this.logger, this.orcsApi, this.eventAdmin);
        return updateArt.updateArtifacts(wordUpdateData);
    }

    public Attachment publishMarkdownAsHtml(PublishingRequestData publishMarkdownAsHtmlRequestData) {
        RendererMap publishingRendererOptions = publishMarkdownAsHtmlRequestData.getPublishingRendererOptions();
        ArtifactId firstArtifactId = (ArtifactId)publishMarkdownAsHtmlRequestData.getArtifactIds().get(0);
        ByteArrayInputStream inputStream = this.processPublishingRequest(publishMarkdownAsHtmlRequestData, publishingRendererOptions);
        MarkdownConverter mdConverter = new MarkdownConverter();
        ByteArrayInputStream htmlInputStream = mdConverter.convertToHtmlStream(inputStream);
        Attachment attachment = new AttachmentFactory("MsWordPreview", "html", this.dataAccessOperations).create((InputStream)htmlInputStream, (CharSequence)publishingRendererOptions.getRendererOptionValue(RendererOption.PUBLISH_IDENTIFIER), (BranchId)publishingRendererOptions.getRendererOptionValue(RendererOption.BRANCH), firstArtifactId, new CharSequence[0]);
        return attachment;
    }

    public String cleanAllMarkdownArtifactsForBranch(BranchId branchId) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAdmin});
        StringBuilder outputLog = new StringBuilder();
        List markdownArtifacts = this.orcsApi.getQueryFactory().fromBranch(branchId).andExists(new AttributeTypeToken[]{CoreAttributeTypes.MarkdownContent}).asArtifacts();
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branchId, "Cleaning and updating Markdown artifacts on branch that have special (non-Markdown) characters.");
        int artifactsProcessed = 0;
        int artifactsCleaned = 0;
        for (ArtifactReadable art : markdownArtifacts) {
            ++artifactsProcessed;
            boolean isArtifactCleaned = false;
            if (art.getExistingAttributeTypes().contains(CoreAttributeTypes.MarkdownContent)) {
                String mdContent = (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MarkdownContent, (Object)"");
                String name = art.getName();
                if (!mdContent.equals("")) {
                    boolean hasSpecialCharsInContent = MarkdownCleaner.containsSpecialCharacters(mdContent);
                    if (hasSpecialCharsInContent) {
                        outputLog.append("Issues detected in the Markdown content: ").append(mdContent).append("\n");
                        String cleanedMarkdownContent = MarkdownCleaner.removeSpecialCharacters(mdContent);
                        outputLog.append("Cleaned Markdown content: ").append(cleanedMarkdownContent).append("\n");
                        tx.setAttributeById(art.getArtifactId(), art.getSoleAttributeId((AttributeTypeToken)CoreAttributeTypes.MarkdownContent), cleanedMarkdownContent);
                        isArtifactCleaned = true;
                    } else {
                        outputLog.append("No special characters detected in the Markdown content.\n");
                    }
                }
                if (!name.equals("")) {
                    boolean hasSpecialCharsInName = MarkdownCleaner.containsSpecialCharacters(name);
                    if (hasSpecialCharsInName) {
                        outputLog.append("Issues detected in the name: ").append(name).append("\n");
                        String cleanedName = MarkdownCleaner.removeSpecialCharacters(name);
                        outputLog.append("Cleaned name: ").append(cleanedName).append("\n");
                        tx.setAttributeById(art.getArtifactId(), art.getSoleAttributeId((AttributeTypeToken)CoreAttributeTypes.Name), cleanedName);
                        isArtifactCleaned = true;
                    } else {
                        outputLog.append("No special characters detected in the name.\n");
                    }
                }
            }
            if (!isArtifactCleaned) continue;
            ++artifactsCleaned;
        }
        tx.commit();
        outputLog.append("Finished processing artifacts.\nTotal artifacts processed: ").append(artifactsProcessed).append("\nTotal artifacts cleaned: ").append(artifactsCleaned);
        return outputLog.toString();
    }

    public String removeMarkdownBoldSymbolsFromAllMarkdownArtifactsForBranch(BranchId branchId) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAdmin});
        StringBuilder outputLog = new StringBuilder();
        List markdownArtifacts = this.orcsApi.getQueryFactory().fromBranch(branchId).andExists(new AttributeTypeToken[]{CoreAttributeTypes.MarkdownContent}).asArtifacts();
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branchId, "Removing bold symbols (**) from all Markdown artifacts on branch.");
        int artifactsProcessed = 0;
        int artifactsCleaned = 0;
        for (ArtifactReadable art : markdownArtifacts) {
            ++artifactsProcessed;
            boolean isArtifactCleaned = false;
            if (art.getExistingAttributeTypes().contains(CoreAttributeTypes.MarkdownContent)) {
                String mdContent = (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MarkdownContent, (Object)"");
                String name = art.getName();
                if (!mdContent.equals("")) {
                    boolean hasMarkdownBoldsInContent = MarkdownCleaner.containsMarkdownBolds(mdContent);
                    if (hasMarkdownBoldsInContent) {
                        outputLog.append("Markdown bold symbols detected in the Markdown content: ").append(mdContent).append("\n");
                        String cleanedMarkdownContent = MarkdownCleaner.removeMarkdownBolds(mdContent);
                        outputLog.append("Cleaned Markdown content: ").append(cleanedMarkdownContent).append("\n");
                        tx.setAttributeById(art.getArtifactId(), art.getSoleAttributeId((AttributeTypeToken)CoreAttributeTypes.MarkdownContent), cleanedMarkdownContent);
                        isArtifactCleaned = true;
                    } else {
                        outputLog.append("No Markdown bold symbols detected in the Markdown content.\n");
                    }
                }
                if (!name.equals("")) {
                    boolean hasMarkdownBoldsInName = MarkdownCleaner.containsMarkdownBolds(name);
                    if (hasMarkdownBoldsInName) {
                        outputLog.append("Markdown bold symbols detected in the name: ").append(name).append("\n");
                        String cleanedName = MarkdownCleaner.removeMarkdownBolds(name);
                        outputLog.append("Cleaned name: ").append(cleanedName).append("\n");
                        tx.setAttributeById(art.getArtifactId(), art.getSoleAttributeId((AttributeTypeToken)CoreAttributeTypes.Name), cleanedName);
                        isArtifactCleaned = true;
                    } else {
                        outputLog.append("No Markdown bold symbols detected in the name.\n");
                    }
                }
            }
            if (!isArtifactCleaned) continue;
            ++artifactsCleaned;
        }
        tx.commit();
        outputLog.append("Finished processing artifacts.\nTotal artifacts processed: ").append(artifactsProcessed).append("\nTotal artifacts cleaned: ").append(artifactsCleaned);
        return outputLog.toString();
    }

    private class PublishingPack {
        @NonNull ChangedArtifactsTracker changedArtifactsTracker;
        @NonNull PublishingArtifactLoader publishingArtifactLoader;
        @NonNull PublishingErrorLog publishingErrorLog;
        @Nullable WordMLApplicabilityHandler wordMlApplicabilityHandler;

        PublishingPack(BranchSpecification branchSpecification) {
            BranchSpecification safeBranchSpecification = (BranchSpecification)Conditions.requireNonNull((Object)branchSpecification, (String)"branchSpecification");
            this.publishingErrorLog = new PublishingErrorLog();
            this.changedArtifactsTracker = new ChangedArtifactsTracker(PublishingOperationsImpl.this.atsApi, PublishingOperationsImpl.this.dataAccessOperations, this.publishingErrorLog);
            this.publishingArtifactLoader = new PublishingArtifactLoader(PublishingOperationsImpl.this.dataAccessOperations, this.publishingErrorLog, WordRenderArtifactWrapperServerImpl::new, WordRenderArtifactWrapperServerImpl::new, this.changedArtifactsTracker::loadByAtsTeamWorkflow).configure(safeBranchSpecification, 256);
            try {
                this.wordMlApplicabilityHandler = new WordMLApplicabilityHandler(PublishingOperationsImpl.this.orcsApi, PublishingOperationsImpl.this.logger, safeBranchSpecification.getBranchIdWithOutViewId(), safeBranchSpecification.getViewId());
            }
            catch (Exception exception) {
                this.wordMlApplicabilityHandler = null;
            }
        }
    }
}

