/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.logging;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.IHealthStatus;
import org.eclipse.osee.framework.logging.ILoggerListener;
import org.eclipse.osee.framework.logging.IStatusListener;
import org.eclipse.osee.framework.logging.IStatusListenerFilter;
import org.eclipse.osee.framework.logging.OseeLogger;
import org.eclipse.osee.framework.logging.StatusManager;

public class OseeLog {
    private static StatusManager sm;
    private static OseeLogger log;

    private static synchronized void makevalid() {
        if (log == null || sm == null) {
            sm = new StatusManager();
            log = new OseeLogger();
        }
    }

    private static synchronized OseeLogger getLog() {
        OseeLog.makevalid();
        return log;
    }

    private static synchronized StatusManager getSM() {
        OseeLog.makevalid();
        return sm;
    }

    public static void log(Class<?> activatorClass, Level level, String message) {
        if (level.intValue() == Level.SEVERE.intValue()) {
            OseeLog.getLog().log(activatorClass.getName(), level, message, new Exception("used to get a stack trace"));
        } else {
            OseeLog.getLog().log(activatorClass.getName(), level, message, null);
        }
    }

    public static void log(Class<?> activatorClass, Level level, Throwable th) {
        OseeLog.getLog().log(activatorClass.getName(), level, th.getLocalizedMessage(), th);
    }

    public static void log(Class<?> activatorClass, Level level, String message, Throwable th) {
        OseeLog.getLog().log(activatorClass.getName(), level, message, th);
    }

    public static void logf(Class<?> activatorClass, Level level, Throwable th, String message, Object ... objects) {
        OseeLog.getLog().format(th, activatorClass.getName(), level, message, objects);
    }

    public static void logf(Class<?> activatorClass, Level level, String message, Object ... objects) {
        OseeLog.getLog().format(activatorClass.getName(), level, message, objects);
    }

    public static void registerLoggerListener(ILoggerListener listener) {
        OseeLog.getLog().registerLoggerListener(listener);
    }

    public static void unregisterLoggerListener(ILoggerListener listener) {
        OseeLog.getLog().unregisterLoggerListener(listener);
    }

    public static void setLevel(String loggerName, Level level) {
        OseeLog.getLog().setLevel(loggerName, level);
    }

    public static void reportStatus(IHealthStatus status) {
        OseeLog.getSM().report(status);
    }

    public static String getStatusReport() {
        return OseeLog.getSM().getReport();
    }

    public static boolean isStatusOk() {
        return OseeLog.getSM().isStatusOk();
    }

    public static IHealthStatus getStatusByName(String sourceName) {
        return OseeLog.getSM().getHealthStatusByName(sourceName);
    }

    public static Collection<IHealthStatus> getStatus() {
        return OseeLog.getSM().getHealthStatus();
    }

    public static boolean register(IStatusListener listener, IStatusListenerFilter filter) {
        return OseeLog.getSM().register(listener, filter);
    }

    public static boolean register(IStatusListener listener) {
        return OseeLog.getSM().register(listener);
    }

    public static void deregister(IStatusListener listener) {
        OseeLog.getSM().deregister(listener);
    }

    public static void reportStatus(List<IHealthStatus> statuses) {
        for (IHealthStatus status : statuses) {
            OseeLog.reportStatus(status);
        }
    }
}

