/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.session;

import java.sql.Timestamp;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.server.internal.session.ISessionCollector;
import org.eclipse.osee.framework.core.server.internal.session.ISessionQuery;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;

public final class DatabaseSessionQuery
implements ISessionQuery {
    private static final String SELECT_ALL_SESSIONS = "select * from osee_session";
    private static final String SELECT_SESSION_BY_ID = "select * from osee_session WHERE session_id = ?";
    private final JdbcClient jdbcClient;

    public DatabaseSessionQuery(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    @Override
    public void selectAllServerManagedSessions(ISessionCollector collector) {
        this.querySessions(collector, SELECT_ALL_SESSIONS, new Object[0]);
    }

    @Override
    public void selectSessionById(ISessionCollector collector, String id) {
        this.querySessions(collector, SELECT_SESSION_BY_ID, id);
    }

    private void querySessions(ISessionCollector collector, String sql, Object ... params) {
        Consumer<JdbcStatement> consumer = stmt -> {
            String sessionGuid = stmt.getString("session_id");
            String userId = stmt.getString("user_id");
            Timestamp creationDate = stmt.getTimestamp("created_on");
            String clientVersion = stmt.getString("client_version");
            String clientMachineName = stmt.getString("client_machine_name");
            String clientAddress = stmt.getString("client_address");
            int clientPort = stmt.getInt("client_port");
            collector.collect(sessionGuid, userId, creationDate, clientVersion, clientMachineName, clientAddress, clientPort);
        };
        this.jdbcClient.runQuery(consumer, sql, params);
    }
}

