/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine.internal;

import java.net.URI;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.JaxRsTemplateContribution;
import org.eclipse.osee.jaxrs.JaxRsTemplateInfo;
import org.eclipse.osee.jaxrs.JaxRsTemplateLink;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.template.engine.internal.TemplateRegistry;
import org.osgi.framework.Bundle;

@Path(value="templates")
public class TemplateContributions {
    private final TemplateRegistry registry;

    public TemplateContributions(TemplateRegistry registry) {
        this.registry = registry;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection<JaxRsTemplateContribution> getTemplateContributions(final @Context HttpHeaders httpHeaders, final @Context UriInfo uriInfo) {
        final HashMap contribs = new HashMap();
        this.registry.accept(new TemplateRegistry.TemplateVisitor(){

            @Override
            public void onTemplate(Bundle bundle, ResourceToken template) {
                Dictionary headers = bundle.getHeaders();
                String bundleName = (String)headers.get("Bundle-SymbolicName");
                String bundleVersion = (String)headers.get("Bundle-Version");
                JaxRsTemplateContribution contrib = TemplateContributions.this.getOrCreateInfo(contribs, bundleName, bundleVersion);
                JaxRsTemplateLink info = new JaxRsTemplateLink();
                info.setName(template.getName());
                info.setUuid((Long)template.getGuid());
                MediaType mediaType = TemplateContributions.this.getMediaType(httpHeaders);
                String uri = TemplateContributions.this.getDetailsUri(uriInfo, template.getName(), mediaType);
                info.setDetails(uri);
                contrib.getTemplates().add(info);
            }
        });
        return contribs.values();
    }

    @Path(value="{template-id}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public JaxRsTemplateInfo getTemplateInfo(@PathParam(value="template-id") String templateId) {
        ResourceToken template;
        int index;
        String viewId = templateId;
        if (!Strings.isNumeric((String)templateId) && (index = viewId.lastIndexOf(95)) > 0) {
            viewId = String.format("%s.%s", viewId.substring(0, index), viewId.substring(index + 1, viewId.length()));
        }
        if ((template = this.registry.resolveTemplate(viewId, MediaType.WILDCARD_TYPE)) == null) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "Unable to find template [%s]", new Object[]{templateId});
        }
        JaxRsTemplateInfo info = new JaxRsTemplateInfo();
        info.setName(template.getName());
        info.setUuid((Long)template.getGuid());
        info.getAttributes().addAll(this.registry.getAttributes(template));
        return info;
    }

    private MediaType getMediaType(HttpHeaders httpHeaders) {
        MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
        List mediaTypes = httpHeaders.getAcceptableMediaTypes();
        mediaType = mediaTypes == null || mediaTypes.isEmpty() ? MediaType.APPLICATION_XML_TYPE : (MediaType)mediaTypes.iterator().next();
        return mediaType;
    }

    private String getDetailsUri(UriInfo uriInfo, String name, MediaType mediaType) {
        String key = name;
        int index = key.lastIndexOf(".");
        if (index > 0) {
            key = String.format("%s_%s.%s", key.substring(0, index), Lib.getExtension((String)name), mediaType.getSubtype());
        }
        URI build = uriInfo.getRequestUriBuilder().path(key).build(new Object[0]);
        return build.toASCIIString();
    }

    private JaxRsTemplateContribution getOrCreateInfo(Map<String, JaxRsTemplateContribution> map, String bundleName, String bundleVersion) {
        String key = this.key(bundleName, bundleVersion);
        JaxRsTemplateContribution info = map.get(key);
        if (info == null) {
            info = new JaxRsTemplateContribution();
            info.setBundleName(bundleName);
            info.setVersion(bundleVersion);
            map.put(key, info);
        }
        return info;
    }

    private String key(String bundleName, String bundleVersion) {
        return String.format("%s:%s", bundleName, bundleVersion);
    }
}

