/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.xml.publishing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osee.framework.core.xml.publishing.AbstractElement;
import org.eclipse.osee.framework.core.xml.publishing.AbstractElementList;
import org.eclipse.osee.framework.core.xml.publishing.WordDocument;
import org.eclipse.osee.framework.core.xml.publishing.WordElementParserFactory;
import org.eclipse.osee.framework.core.xml.publishing.WordMlTag;
import org.eclipse.osee.framework.core.xml.publishing.WordTable;
import org.eclipse.osee.framework.core.xml.publishing.WordTableColumn;
import org.eclipse.osee.framework.core.xml.publishing.WordTableColumnList;
import org.eclipse.osee.framework.core.xml.publishing.WordTableRowList;
import org.eclipse.osee.framework.core.xml.publishing.XmlTagSpecification;
import org.eclipse.osee.framework.jdk.core.type.Result;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PublishingXmlUtils {
    private static Void theVoid = null;
    private final ThreadLocal<Cause> lastCause = new ThreadLocal<Cause>(){

        @Override
        protected Cause initialValue() {
            return Cause.OK;
        }
    };
    private final ThreadLocal<Exception> lastError = new ThreadLocal();

    private static Optional<String> rawFindTableColumnText(WordTable wordTable, int row, int column, int text) {
        Optional<String> textOptional = wordTable.getWordTableRowList().flatMap(wordTableRowList -> wordTableRowList.get(row)).flatMap(wordTableRow -> wordTableRow.getWordTableColumnList()).flatMap(wordTableColumnList -> wordTableColumnList.get(column)).flatMap(wordTableColumn -> wordTableColumn.getWordTextList()).flatMap(wordTextList -> wordTextList.get(text)).map(wordText -> wordText.getText());
        return textOptional;
    }

    public Optional<WordTable> findTableByColumnText(WordDocument wordDocument, int row, int column, int text, String expectedColumnText) {
        this.startOperation();
        try {
            return wordDocument.getWordTableList().map(AbstractElementList::stream).orElseGet(Stream::empty).filter(wordTable -> PublishingXmlUtils.rawFindTableColumnText(wordTable, row, column, text).map(foundColumnText -> foundColumnText.equals(expectedColumnText)).orElse(false)).findFirst();
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<String> findTableColumnText(WordTable wordTable, int row, int column, int text) {
        this.startOperation();
        try {
            return PublishingXmlUtils.rawFindTableColumnText(wordTable, row, column, text);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Cause getLastCause() {
        return this.lastCause.get();
    }

    public Optional<Exception> getLastError() {
        return Optional.ofNullable(this.lastError.get());
    }

    public boolean isKo() {
        return !this.isOk();
    }

    public boolean isOk() {
        return this.lastCause.get().equals((Object)Cause.OK);
    }

    public static Result<Document, PublishingXmlError> parse(File file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream autoCloseInputStream = new FileInputStream(file);){
                Document document = PublishingXmlUtils.parseInternal(autoCloseInputStream);
                return Result.ofValue((Object)document);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return Result.ofError((Object)new PublishingXmlError(new Message().title((CharSequence)"PublishingXmlUtils::parse, Failed to parse XML file.").reasonFollows((Throwable)e), (Throwable)e));
        }
    }

    public static Result<Document, PublishingXmlError> parse(InputStream inputStream) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream autoCloseInputStream = inputStream;){
                Document document = PublishingXmlUtils.parseInternal(autoCloseInputStream);
                return Result.ofValue((Object)document);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return Result.ofError((Object)new PublishingXmlError(new Message().title((CharSequence)"PublishingXmlUtils::parse, Failed to parse XML input stream.").reasonFollows((Throwable)e), (Throwable)e));
        }
    }

    public static Result<Document, PublishingXmlError> parse(String xmlString) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayInputStream autoCloseInputStream = new ByteArrayInputStream(xmlString.getBytes());){
                Document document = PublishingXmlUtils.parseInternal(autoCloseInputStream);
                return Result.ofValue((Object)document);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return Result.ofError((Object)new PublishingXmlError(new Message().title((CharSequence)"PublishingXmlUtils::parse, Failed to parse XML string.").reasonFollows((Throwable)e), (Throwable)e));
        }
    }

    public <P extends AbstractElement, L extends AbstractElementList<? super P, ? super C>, C extends AbstractElement> Optional<L> parseAbstractElementList(P parent, Function<P, L> listFactory, BiFunction<P, Element, C> childFactory, String childTagName, Map<String, String> childAttributes) {
        this.startOperation();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (AbstractElementList list = (AbstractElementList)listFactory.apply(parent);){
                NodeList nodeList = parent.getElement().getElementsByTagName(childTagName);
                int nodeCount = nodeList.getLength();
                int i = 0;
                while (i < nodeCount) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        NamedNodeMap attributeMap = element.getAttributes();
                        boolean attributesFound = true;
                        for (Map.Entry<String, String> entry : childAttributes.entrySet()) {
                            Node attributeNode = attributeMap.getNamedItem(entry.getKey());
                            if (attributeNode == null) {
                                attributesFound = false;
                                break;
                            }
                            if (entry.getValue().equals(attributeNode.getNodeValue())) continue;
                            attributesFound = false;
                            break;
                        }
                        if (attributesFound) {
                            AbstractElement child = (AbstractElement)childFactory.apply(parent, element);
                            list.add(child);
                        }
                    }
                    ++i;
                }
                parent.setChild((AbstractElementList)list);
                return Optional.of(list);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public static <P extends AbstractElement, L extends AbstractElementList<? super P, ? super C>, C extends AbstractElement> Result<L, PublishingXmlError> parseDescendantsList(P parent, WordElementParserFactory<P, L, C> wordElementParserFactory) {
        try {
            Function<P, L> listFactory = wordElementParserFactory.getListFactory();
            BiFunction<P, Element, C> childFactory = wordElementParserFactory.getChildFactory();
            String childTagName = wordElementParserFactory.getChildTag().getFullname();
            Throwable throwable = null;
            Object var6_8 = null;
            try (AbstractElementList list = (AbstractElementList)listFactory.apply(parent);){
                NodeList nodeList = parent.getElement().getElementsByTagName(childTagName);
                int nodeCount = nodeList.getLength();
                int i = 0;
                while (i < nodeCount) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        AbstractElement child = (AbstractElement)childFactory.apply(parent, element);
                        list.add(child);
                    }
                    ++i;
                }
                parent.setChild((AbstractElementList)list);
                return Result.ofValue((Object)list);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return Result.ofError((Object)new PublishingXmlError(new Message().title((CharSequence)"Failed to parse descendant nodes.").indentInc().segment((CharSequence)"Parent", parent).segment((CharSequence)"Word Element Parser Factory", wordElementParserFactory).reasonFollows((Throwable)e).indentDec(), (Throwable)e));
        }
    }

    private static Document parseInternal(InputStream inputStream) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        return document;
    }

    public <P extends AbstractElement, C extends AbstractElement> Optional<C> parseChild(P parent, XmlTagSpecification childTag, BiFunction<P, Element, C> childFactory) {
        this.startOperation();
        try {
            Element parentElement = parent.getElement();
            String tagName = childTag.getFullname();
            Node node = parentElement.getFirstChild();
            while (Objects.nonNull(node)) {
                Element element;
                if (node.getNodeType() == 1 && tagName.equals((element = (Element)node).getTagName())) {
                    AbstractElement child = (AbstractElement)childFactory.apply(parent, element);
                    return Optional.of(child);
                }
                node = node.getNextSibling();
            }
            return Optional.empty();
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public static <P extends AbstractElement, L extends AbstractElementList<P, C>, C extends AbstractElement> Result<L, PublishingXmlError> parseChildList(P parent, WordElementParserFactory<P, L, C> wordElementParserFactory) {
        try {
            Function<P, L> listFactory = wordElementParserFactory.getListFactory();
            BiFunction<P, Element, C> childFactory = wordElementParserFactory.getChildFactory();
            String childTagName = wordElementParserFactory.getChildTag().getFullname();
            Throwable throwable = null;
            Object var6_8 = null;
            try (AbstractElementList list = (AbstractElementList)listFactory.apply(parent);){
                Element parentNode = parent.getElement();
                NodeList childNodeList = parentNode.getChildNodes();
                int childCount = childNodeList.getLength();
                int i = 0;
                while (i < childCount) {
                    Element childElement;
                    Node childNode = childNodeList.item(i);
                    if (1 == childNode.getNodeType() && childTagName.equals((childElement = (Element)childNode).getNodeName())) {
                        AbstractElement child = (AbstractElement)childFactory.apply(parent, childElement);
                        list.add(child);
                    }
                    ++i;
                }
                parent.setChild((AbstractElementList)list);
                return Result.ofValue((Object)list);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return Result.ofError((Object)new PublishingXmlError(new Message().title((CharSequence)"Failed to parse child nodes.").indentInc().segment((CharSequence)"Parent", parent).segment((CharSequence)"Word Element Parser Factory", wordElementParserFactory).reasonFollows((Throwable)e).indentDec(), (Throwable)e));
        }
    }

    public static Result<WordDocument, PublishingXmlError> parseWordDocument(Document document) {
        try {
            Element rootElement = document.getDocumentElement();
            if (WordMlTag.WORD_DOCUMENT.isTagName(rootElement.getTagName())) {
                WordDocument wordDocument = new WordDocument(rootElement);
                return Result.ofValue((Object)wordDocument);
            }
            return Result.empty();
        }
        catch (Exception e) {
            return Result.ofError((Object)new PublishingXmlError(new Message().title((CharSequence)"Failed to parse child nodes.").indentInc().segment((CharSequence)"Parent", (Object)document).reasonFollows((Throwable)e).indentDec(), (Throwable)e));
        }
    }

    public static <C extends AbstractElement, CL extends AbstractElementList<WordTableColumn, C>> Result<Void, PublishingXmlError> parseWordTable(WordTable wordTable, Function<WordTableColumn, Result<CL, PublishingXmlError>> columnParser) {
        try {
            PublishingXmlUtils.parseChildList(wordTable, WordTableRowList.wordTableParentFactory).ifErrorThrow(Result.ErrorToThrowableMapper.identity()).ifValueAction(wordTableRowList -> wordTableRowList.forEach(wordTableRow -> PublishingXmlUtils.parseChildList(wordTableRow, WordTableColumnList.wordTableRowParentFactory).ifErrorThrow(Result.ErrorToThrowableMapper.identity()).ifValueAction(wordTableColumnList -> wordTableColumnList.forEach(wordTableColumn -> {
                Result result = ((Result)columnParser.apply((WordTableColumn)wordTableColumn)).ifErrorThrow(Result.ErrorToThrowableMapper.identity());
            }))));
            return Result.ofValue((Object)theVoid);
        }
        catch (Exception e) {
            return Result.ofError((Object)new PublishingXmlError(new Message().title((CharSequence)"PublishingXmlUtils::parseWordTable, Failed to parse the rows, columns, and column content of a table.").indentInc().segment((CharSequence)"Parent", (Object)wordTable).reasonFollows((Throwable)e), (Throwable)e));
        }
    }

    public Optional<String> prettyPrint(Document document) {
        this.startOperation();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 3);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return Optional.of(stringWriter.toString());
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    private void startOperation() {
        this.lastCause.remove();
        this.lastError.remove();
    }

    public static enum Cause {
        ERROR,
        MORE_THAN_ONE,
        NODE_NOT_ELEMENT,
        NOT_FOUND,
        OK;

    }

    public static class PublishingXmlError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        PublishingXmlError(Message message, Throwable cause) {
            super(message.toString(), cause);
        }
    }
}

