/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactReadableDeserializer;
import org.eclipse.osee.framework.core.data.ArtifactReadableSerializer;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTokenDeserializer;
import org.eclipse.osee.framework.core.data.ArtifactTokenSerializer;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.TransactionTokenDeserializer;
import org.eclipse.osee.framework.core.data.TransactionTokenSerializer;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.data.UserTokenDeserializer;
import org.eclipse.osee.framework.core.data.UserTokenSerializer;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.IdDeserializer;
import org.eclipse.osee.framework.jdk.core.type.IdSerializer;
import org.eclipse.osee.framework.jdk.core.type.NamedIdDeserializer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class JsonUtil {
    private static ObjectMapper mapper = JsonUtil.createStandardDateObjectMapper((Module)JsonUtil.createModule());
    private static ObjectMapper mapper2 = JsonUtil.createObjectMapper((Module)JsonUtil.createModule()).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm a z"));

    public static JsonFactory getFactory() {
        return mapper2.getFactory();
    }

    public static JsonNode readTree(String json) {
        try {
            return mapper.readTree(json);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static String toJson(Object object) {
        return JsonUtil.toJson(mapper, object);
    }

    public static String toJson(ObjectMapper mapper, Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static <T> T readValue(String content, Class<T> valueType) {
        return JsonUtil.readValue(mapper, content, valueType);
    }

    public static <T> T readValue(ObjectMapper mapper, String content, Class<T> valueType) {
        try {
            return (T)mapper.readValue(content, valueType);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static <T> List<T> readValues(String content, Class<T> valueType) {
        return JsonUtil.readValues(mapper, content, valueType);
    }

    public static <T> List<T> readValues(ObjectMapper mapper, String content, Class<T> valueType) {
        try {
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, valueType);
            return (List)mapper.readValue(content, (JavaType)type);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static JsonNode getArrayElement(JsonNode array, String key, String value) {
        for (JsonNode element : array) {
            JsonNode node = element.get(key);
            if (node == null || !value.equals(node.asText())) continue;
            return element;
        }
        return null;
    }

    public static boolean hasAnnotation(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ObjectMapper createStandardDateObjectMapper(Module module) {
        return JsonUtil.createObjectMapper(module).setDateFormat((DateFormat)new SimpleDateFormat("MMM d, yyyy h:mm:ss aa"));
    }

    public static <T extends Id> void addDeserializer(SimpleModule module, Class<T> clazz, Function<Long, T> creator) {
        module.addDeserializer(clazz, (JsonDeserializer)new IdDeserializer(clazz, creator));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static SimpleModule createModule() {
        SimpleModule module = new SimpleModule("OSEE", new Version(1, 0, 0, "", "", ""));
        JsonUtil.addDeserializer(module, ArtifactId.class, ArtifactId::valueOf);
        JsonUtil.addDeserializer(module, TransactionId.class, TransactionId::valueOf);
        JsonUtil.addDeserializer(module, Id.class, Id::valueOf);
        JsonUtil.addDeserializer(module, ApplicabilityId.class, ApplicabilityId::valueOf);
        JsonUtil.addDeserializer(module, ArtifactTypeId.class, ArtifactTypeId::valueOf);
        module.addDeserializer(ApplicabilityToken.class, (JsonDeserializer)new NamedIdDeserializer(ApplicabilityToken::valueOf));
        module.addDeserializer(TransactionToken.class, (JsonDeserializer)new TransactionTokenDeserializer());
        module.addDeserializer(UserToken.class, (JsonDeserializer)new UserTokenDeserializer());
        module.addDeserializer(ArtifactReadable.class, (JsonDeserializer)new ArtifactReadableDeserializer());
        module.addDeserializer(ArtifactToken.class, (JsonDeserializer)new ArtifactTokenDeserializer());
        module.addSerializer(ArtifactToken.class, (JsonSerializer)new ArtifactTokenSerializer());
        module.addSerializer(TransactionToken.class, (JsonSerializer)new TransactionTokenSerializer());
        module.addSerializer(UserToken.class, (JsonSerializer)new UserTokenSerializer());
        @NonNull IdSerializer idSerializer = new IdSerializer();
        module.addSerializer(TransactionId.class, (JsonSerializer)idSerializer);
        module.addSerializer(BranchType.class, (JsonSerializer)idSerializer);
        module.addSerializer(BranchState.class, (JsonSerializer)idSerializer);
        module.addSerializer(ApplicabilityId.class, (JsonSerializer)idSerializer);
        module.addSerializer(Date.class, (JsonSerializer)DateSerializer.instance);
        module.addSerializer(ArtifactReadable.class, (JsonSerializer)new ArtifactReadableSerializer());
        return module;
    }

    private static ObjectMapper createObjectMapper(Module module) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(module);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, false);
        objectMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_CREATORS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_SETTERS, true);
        objectMapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        objectMapper.configure(MapperFeature.USE_ANNOTATIONS, true);
        objectMapper.configure(MapperFeature.USE_ANNOTATIONS, true);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.configure(SerializationFeature.WRAP_EXCEPTIONS, true);
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        objectMapper.configure(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS, true);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"));
        objectMapper.setDefaultPrettyPrinter((PrettyPrinter)prettyPrinter);
        return objectMapper;
    }
}

