/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing.relation.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableAppender;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableOptions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class RelationTableBuilder {
    private final RelationTableOptions relationTableOptions;
    private final PublishingArtifact artifact;
    private final OrcsTokenService orcsTokenService;
    private final RelationTableAppender appender;

    public RelationTableBuilder(RelationTableOptions relationTableOptions, PublishingArtifact artifact, OrcsTokenService orcsTokenService, RelationTableAppender appender) {
        this.relationTableOptions = relationTableOptions;
        this.artifact = artifact;
        this.orcsTokenService = orcsTokenService;
        this.appender = appender;
    }

    public void buildRelationTable() {
        List<String> relationTypeSides = this.relationTableOptions.getRelationTableRelationTypeSides();
        for (String relationTypeSide : relationTypeSides) {
            this.processRelationTypeSide(relationTypeSide);
        }
    }

    private void processRelationTypeSide(String relationTypeSide) {
        String[] parts = relationTypeSide.split("\\|");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid format for relationTypeSide: " + relationTypeSide);
        }
        String relationTypeNameOrId = parts[0].trim();
        String relationTypeSideName = parts[1].trim();
        RelationTypeToken relation = this.retrieveRelationType(relationTypeNameOrId);
        if (relation == null) {
            return;
        }
        List<ArtifactReadable> relatedArtifacts = this.getRelatedArtifacts(relation, relationTypeSideName);
        if (relatedArtifacts.isEmpty()) {
            return;
        }
        this.appender.startTable();
        this.appender.appendTableHeader(relation.getName(), relationTypeSideName, this.relationTableOptions.getRelationTableColumns().size());
        this.appender.appendColumnHeaders(this.relationTableOptions.getRelationTableColumns());
        for (ArtifactReadable artifact : relatedArtifacts) {
            List<String> cellValues = this.getCellValuesForArtifact(artifact);
            this.appender.appendRow(cellValues);
        }
        this.appender.endTable();
    }

    private RelationTypeToken retrieveRelationType(String relationTypeNameOrId) {
        if (Strings.isLong((String)relationTypeNameOrId)) {
            Long relTypeId = Long.parseLong(relationTypeNameOrId);
            return this.orcsTokenService.getRelationType(relTypeId);
        }
        return this.orcsTokenService.getRelationType(relationTypeNameOrId);
    }

    private List<ArtifactReadable> getRelatedArtifacts(RelationTypeToken relation, String relationTypeSideName) {
        RelationTypeSide sideA = RelationTypeSide.create(relation, RelationSide.SIDE_A);
        RelationTypeSide sideB = RelationTypeSide.create(relation, RelationSide.SIDE_B);
        RelationTypeSide properSide = relation.getSideName(RelationSide.SIDE_A).equals(relationTypeSideName) ? sideA : sideB;
        return this.artifact.getRelated(properSide, DeletionFlag.EXCLUDE_DELETED);
    }

    private List<String> getCellValuesForArtifact(ArtifactReadable artifact) {
        ArrayList<String> cellValues = new ArrayList<String>();
        for (String column : this.relationTableOptions.getRelationTableColumns()) {
            String cellValue = this.getCellValue(column, artifact);
            cellValues.add(cellValue);
        }
        return cellValues;
    }

    private String getCellValue(String column, ArtifactReadable relatedArtifact) {
        if (RelationTableOptions.isDefinedColumn(column)) {
            if (column.equals("Artifact Id")) {
                return String.valueOf(relatedArtifact.getArtifactId());
            }
            if (column.equals("Artifact Name")) {
                return relatedArtifact.getName();
            }
        } else {
            if (Strings.isLong((String)column)) {
                Long attrTypeId = Long.parseLong(column);
                return relatedArtifact.getAttributeValuesAsString(this.orcsTokenService.getAttributeType(attrTypeId));
            }
            return relatedArtifact.getAttributeValuesAsString(this.orcsTokenService.getAttributeType(column));
        }
        return "";
    }
}

