/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.AllowedOutlineTypes;
import org.eclipse.osee.framework.core.publishing.ArtifactHierarchyComparator;
import org.eclipse.osee.framework.core.publishing.AttributeOptions;
import org.eclipse.osee.framework.core.publishing.DataRightContentBuilder;
import org.eclipse.osee.framework.core.publishing.DataRightResult;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.core.publishing.IncludeBookmark;
import org.eclipse.osee.framework.core.publishing.IncludeHeadings;
import org.eclipse.osee.framework.core.publishing.IncludeMainContentForHeadings;
import org.eclipse.osee.framework.core.publishing.IncludeMetadataAttributes;
import org.eclipse.osee.framework.core.publishing.MetadataOptions;
import org.eclipse.osee.framework.core.publishing.OutlineNumber;
import org.eclipse.osee.framework.core.publishing.OutlineSectionResult;
import org.eclipse.osee.framework.core.publishing.PublishingAppender;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.publishing.WordTemplateContentData;
import org.eclipse.osee.framework.core.publishing.artifactacceptor.ArtifactAcceptor;
import org.eclipse.osee.framework.core.publishing.relation.table.HtmlRelationTableAppender;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableAppender;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableBuilder;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableOptions;
import org.eclipse.osee.framework.core.publishing.relation.table.WordRelationTableAppender;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.Triplet;
import org.eclipse.osee.framework.jdk.core.util.Collectors;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class WordRenderUtil {
    private static final String APPLICABILITY = "Applicability";
    private static final String ARTIFACT_ID = "Artifact Id";
    private static final String ARTIFACT_TYPE = "Artifact Type";

    public static Optional<DataRightContentBuilder> getDataRights(List<PublishingArtifact> artifacts, BranchId branchId, boolean recurse, boolean notHistorical, String overrideClassification, ArtifactAcceptor descendantArtifactAcceptor, DataRightsProvider dataRightsProvider) {
        assert (Objects.nonNull(branchId)) : "WordRenderUtil::getDataRights, parameter \"branchId\" cannot be null.";
        assert (Objects.nonNull(dataRightsProvider)) : "WordRenderUtil::getDataRights, parameter \"dataRightsProvider\" cannot be null.";
        try {
            if (Objects.isNull(artifacts) || artifacts.isEmpty()) {
                return Optional.empty();
            }
            List<PublishingArtifact> allArtifacts = WordRenderUtil.getPublishArtifacts(artifacts, recurse, notHistorical, descendantArtifactAcceptor);
            if (allArtifacts.isEmpty()) {
                return Optional.empty();
            }
            DataRightResult dataRightResult = dataRightsProvider.getDataRights(branchId, overrideClassification, allArtifacts.stream().map(ArtifactId::create).collect(java.util.stream.Collectors.toList()));
            DataRightContentBuilder dataRightContentBuilder = new DataRightContentBuilder(dataRightResult);
            return Optional.of(dataRightContentBuilder);
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"WordRenderUtil::getDataRights, failed to obtain data rights for publishing artifacts.").indentInc().segment((CharSequence)"Publishing Branch Identifier", (Object)branchId).segment((CharSequence)"Recursive", (Object)recurse).segment((CharSequence)"Not Historical", (Object)notHistorical).segment((CharSequence)"Override Classification", (Object)overrideClassification).segmentIndexed((CharSequence)"Top Level Publishing Artifacts", artifacts, Id::getId).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
    }

    private static Optional<String> getOverrideSectionNumber(@NonNull PublishingArtifact artifact, @NonNull OutlineNumber outlineNumber) {
        if (!artifact.isAttributeTypeValid(CoreAttributeTypes.ParagraphNumber)) {
            return Optional.empty();
        }
        String paragraphNumber = artifact.getSoleAttributeValue(CoreAttributeTypes.ParagraphNumber, "");
        if (outlineNumber.isValidOutlineNumber(paragraphNumber)) {
            return Optional.of(paragraphNumber);
        }
        ArtifactHierarchyComparator comparator = new ArtifactHierarchyComparator();
        paragraphNumber = comparator.getHierarchyPosition(artifact);
        if (outlineNumber.isValidOutlineNumber(paragraphNumber)) {
            return Optional.of(paragraphNumber);
        }
        return Optional.empty();
    }

    public static WordCoreUtil.pageType getPageOrientation(PublishingArtifact artifact) {
        WordCoreUtil.pageType defaultPageType = WordCoreUtil.pageType.getDefault();
        try {
            if (Objects.isNull(artifact) || artifact.isInvalid()) {
                return defaultPageType;
            }
            if (!artifact.isAttributeTypeValid(CoreAttributeTypes.PageOrientation)) {
                return defaultPageType;
            }
            String pageTypeString = artifact.getSoleAttributeAsString(CoreAttributeTypes.PageOrientation, defaultPageType.name());
            return WordCoreUtil.pageType.fromString(pageTypeString);
        }
        catch (Exception exception) {
            return defaultPageType;
        }
    }

    public static List<PublishingArtifact> getPublishArtifacts(List<PublishingArtifact> artifacts, boolean recursive, boolean notHistorical, ArtifactAcceptor descendantArtifactAcceptor) {
        if (Objects.isNull(artifacts) || artifacts.isEmpty()) {
            return null;
        }
        Iterator<PublishingArtifact> artifactIterator = artifacts.iterator();
        PublishingArtifact artifact = artifacts.iterator().next();
        artifact.setStartOfSection();
        artifact.clearEndOfSection();
        artifact.setOutlineLevel(0);
        while (artifactIterator.hasNext()) {
            artifact = artifactIterator.next();
            artifact.setStartOfSection();
            artifact.clearEndOfSection();
            artifact.setOutlineLevel(0);
        }
        artifact.setEndOfSection();
        LinkedList<PublishingArtifact> allArtifacts = new LinkedList<PublishingArtifact>();
        HashSet<ArtifactId> checkSet = recursive ? new HashSet<ArtifactId>() : null;
        WordRenderUtil.loadChildrenRecursive(allArtifacts, checkSet, artifacts, 0, recursive, notHistorical, descendantArtifactAcceptor);
        return allArtifacts;
    }

    public static String getStartingParagraphNumber(ArtifactReadable artifact, PublishingTemplate publishingTemplate) {
        String startParagraphNumber = "1";
        if (Objects.isNull(publishingTemplate) || Objects.isNull(artifact) || publishingTemplate.test(WordCoreUtil::isNotArtifactPublishingTemplateInsertToken) || !artifact.isAttributeTypeValid(CoreAttributeTypes.ParagraphNumber)) {
            return startParagraphNumber;
        }
        String paragraphNumber = artifact.getSoleAttributeAsString(CoreAttributeTypes.ParagraphNumber, "");
        if (Strings.isInvalidOrBlank((String)paragraphNumber)) {
            return startParagraphNumber;
        }
        return paragraphNumber;
    }

    public static ArtifactAcceptor getExcludedArtifactTypeArtifactAcceptor(@Nullable Collection<ArtifactTypeToken> excludeArtifactTypes) {
        if (excludeArtifactTypes == null || excludeArtifactTypes.isEmpty()) {
            return ArtifactAcceptor.ok();
        }
        final ArtifactTypeToken[] safeExcludeArtifactTypes = (ArtifactTypeToken[])excludeArtifactTypes.stream().filter(Objects::nonNull).filter(Id::isValid).collect(Collectors.toArray(s -> new ArtifactTypeToken[s.intValue()]));
        return new ArtifactAcceptor(){

            @Override
            public boolean isOk(ArtifactReadable artifact) {
                return !artifact.isOfType(safeExcludeArtifactTypes);
            }

            public String toString() {
                return new Message().title((CharSequence)"Excluded Artifact Type Artifact Acceptor").indentInc().segmentIndexed((CharSequence)"Artifact Types", (Object[])safeExcludeArtifactTypes).toString();
            }
        };
    }

    private static void loadChildrenRecursive(List<PublishingArtifact> allArtifacts, Set<ArtifactId> checkSet, List<PublishingArtifact> levelArtifacts, int outlineLevel, boolean recurse, boolean notHistorical, ArtifactAcceptor descendantArtifactAcceptor) {
        Iterator<PublishingArtifact> artifactIterator = levelArtifacts.iterator();
        PublishingArtifact artifact = null;
        while (artifactIterator.hasNext()) {
            artifact = artifactIterator.next();
            if (Objects.isNull(artifact) || artifact.isInvalid() || Objects.nonNull(checkSet) && checkSet.contains(artifact)) continue;
            if (outlineLevel > 0 && Objects.nonNull(descendantArtifactAcceptor) && !descendantArtifactAcceptor.isOk(artifact)) {
                checkSet.add(artifact);
                continue;
            }
            if (Objects.nonNull(checkSet)) {
                checkSet.add(artifact);
            }
            allArtifacts.add(artifact);
            if (!recurse || notHistorical && artifact.isHistorical()) continue;
            WordRenderUtil.loadChildrenRecursive(allArtifacts, checkSet, artifact.getChildrenAsPublishingArtifacts(), outlineLevel + 1, recurse, notHistorical, descendantArtifactAcceptor);
        }
    }

    public static @NonNull ArtifactAcceptor populateEmptyHeaders(@Nullable List<@Nullable PublishingArtifact> artifacts, @Nullable IncludeHeadings includeHeadings, @Nullable AllowedOutlineTypes allowedOutlineTypes, @Nullable ArtifactTypeToken headingArtifactTypeToken, @Nullable AttributeTypeToken mainContentAttributeTypeToken, @Nullable ArtifactAcceptor excludedArtifactTypeArtifactAcceptor, @Nullable ArtifactAcceptor artifactAcceptor) {
        if (artifacts == null || artifacts.isEmpty()) {
            return ArtifactAcceptor.ok();
        }
        if (includeHeadings == null || includeHeadings == IncludeHeadings.ALWAYS) {
            return ArtifactAcceptor.ok();
        }
        AllowedOutlineTypes safeAllowedOutlineTypes = allowedOutlineTypes != null ? allowedOutlineTypes : AllowedOutlineTypes.ANYTHING;
        ArtifactAcceptor safeExcludedArtifactTypeArtifactAcceptor = excludedArtifactTypeArtifactAcceptor != null ? excludedArtifactTypeArtifactAcceptor : ArtifactAcceptor.ok();
        ArtifactAcceptor safeArtifactAcceptor = artifactAcceptor != null ? artifactAcceptor : ArtifactAcceptor.ok();
        ArtifactTypeToken safeHeadingArtifactTypeToken = (ArtifactTypeToken)Conditions.require((Object)headingArtifactTypeToken, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"headingArtifactTypeToken", (String)"must not be null when \"allowedOutlineTypes\" is \"RESTRICTED\"", value -> safeAllowedOutlineTypes == AllowedOutlineTypes.RESTRICTED && value == null, NullPointerException::new);
        AttributeTypeToken safeMainContentAttributeTypeToken = (AttributeTypeToken)Conditions.require((Object)mainContentAttributeTypeToken, (Conditions.ValueType)Conditions.ValueType.PARAMETER, (String)"mainContentAttributeTypeToken", (String)"must not be null when \"includeHeadings\" is \"ONLY_WITH_MAIN_CONTENT\".", value -> includeHeadings == IncludeHeadings.ONLY_WITH_MAIN_CONTENT && value == null, NullPointerException::new);
        final HashSet<ArtifactId> emptyHeaders = new HashSet<ArtifactId>();
        for (PublishingArtifact artifact : artifacts) {
            if (artifact == null || !safeArtifactAcceptor.isOk(artifact)) continue;
            WordRenderUtil.populateEmptyHeadersInt(artifact, emptyHeaders, includeHeadings, safeAllowedOutlineTypes, safeHeadingArtifactTypeToken, safeMainContentAttributeTypeToken, safeExcludedArtifactTypeArtifactAcceptor, safeArtifactAcceptor);
        }
        return emptyHeaders.isEmpty() ? ArtifactAcceptor.ok() : new ArtifactAcceptor(){

            @Override
            public boolean isOk(ArtifactReadable artifact) {
                ArtifactId artifactId = ArtifactId.create(artifact);
                return !emptyHeaders.contains(artifactId);
            }

            public String toString() {
                return new Message().title((CharSequence)"Empty Headers Artifact Acceptor").indentInc().segment((CharSequence)"Size", (Object)emptyHeaders.size()).segmentIndexed((CharSequence)"Empty Headers", (Collection)emptyHeaders, Function.identity(), 20).toString();
            }
        };
    }

    private static @NonNull Triplet<Boolean, Boolean, Boolean> populateEmptyHeadersInt(@NonNull PublishingArtifact artifact, @NonNull Set<ArtifactId> emptyHeaders, @NonNull IncludeHeadings includeHeadings, @NonNull AllowedOutlineTypes allowedOutlineTypes, @Nullable ArtifactTypeToken headingArtifactTypeToken, @Nullable AttributeTypeToken mainContentAttributeTypeToken, @NonNull ArtifactAcceptor excludedArtifactTypeArtifactAcceptor, @NonNull ArtifactAcceptor artifactAcceptor) {
        List<Object> children;
        boolean artifactIncluded = false;
        boolean withNonHeading = !AllowedOutlineTypes.HEADERS_AND_FOLDERS_ONLY.isAllowed(artifact, headingArtifactTypeToken);
        boolean withMainContent = artifact.hasAttributeContent(mainContentAttributeTypeToken);
        List<Object> list = children = artifactAcceptor.isOk(artifact) ? artifact.getChildrenAsPublishingArtifacts() : List.of();
        if (children.isEmpty()) {
            switch (includeHeadings) {
                case ONLY_WITH_NON_HEADING_DESCENDANTS: {
                    if (withNonHeading) {
                        artifactIncluded = withNonHeading = excludedArtifactTypeArtifactAcceptor.isOk(artifact);
                        break;
                    }
                    if (!AllowedOutlineTypes.HEADERS_AND_FOLDERS_ONLY.isAllowed(artifact, null)) break;
                    emptyHeaders.add(ArtifactId.create(artifact));
                    break;
                }
                case ONLY_WITH_MAIN_CONTENT: {
                    if (withMainContent) {
                        artifactIncluded = withMainContent = excludedArtifactTypeArtifactAcceptor.isOk(artifact);
                        break;
                    }
                    if (!AllowedOutlineTypes.HEADERS_AND_FOLDERS_ONLY.isAllowed(artifact, null)) break;
                    emptyHeaders.add(ArtifactId.create(artifact));
                    break;
                }
                default: {
                    Conditions.invalidCase((Object)((Object)includeHeadings), (String)"includeHeadings", IllegalStateException::new);
                }
            }
            return Triplet.createNonNullImmutable((Object)artifactIncluded, (Object)withNonHeading, (Object)withMainContent);
        }
        for (PublishingArtifact publishingArtifact : children) {
            if (publishingArtifact == null) continue;
            Triplet<Boolean, Boolean, Boolean> triplet = WordRenderUtil.populateEmptyHeadersInt(publishingArtifact, emptyHeaders, includeHeadings, allowedOutlineTypes, headingArtifactTypeToken, mainContentAttributeTypeToken, excludedArtifactTypeArtifactAcceptor, artifactAcceptor);
            artifactIncluded |= ((Boolean)triplet.getFirst()).booleanValue();
            withNonHeading |= ((Boolean)triplet.getSecond()).booleanValue();
            withMainContent |= ((Boolean)triplet.getThird()).booleanValue();
        }
        if (!artifactIncluded) {
            switch (includeHeadings) {
                case ONLY_WITH_NON_HEADING_DESCENDANTS: {
                    if (withNonHeading) {
                        artifactIncluded = excludedArtifactTypeArtifactAcceptor.isOk(artifact);
                        break;
                    }
                    if (!AllowedOutlineTypes.HEADERS_AND_FOLDERS_ONLY.isAllowed(artifact, null)) break;
                    emptyHeaders.add(ArtifactId.create(artifact));
                    break;
                }
                case ONLY_WITH_MAIN_CONTENT: {
                    if (withMainContent) {
                        artifactIncluded = excludedArtifactTypeArtifactAcceptor.isOk(artifact);
                        break;
                    }
                    if (!AllowedOutlineTypes.HEADERS_AND_FOLDERS_ONLY.isAllowed(artifact, null)) break;
                    emptyHeaders.add(ArtifactId.create(artifact));
                    break;
                }
                default: {
                    Conditions.invalidCase((Object)((Object)includeHeadings), (String)"includeHeadings", IllegalStateException::new);
                }
            }
        }
        return Triplet.createNonNullImmutable((Object)artifactIncluded, (Object)withNonHeading, (Object)withMainContent);
    }

    private static boolean isMainContent(boolean isFirst, String attributeOptionsName, AttributeTypeToken contentAttributeType) {
        switch (attributeOptionsName) {
            case "*": {
                return isFirst;
            }
            case "<format-content-attribute>": {
                return true;
            }
        }
        return attributeOptionsName.equals(contentAttributeType.getName());
    }

    private static Optional<CharSequence> processMainContentAttribute(FormatIndicator formatIndicator, @NonNull List<AttributeOptions> attributeOptionsList, InternalAttributeProcessor internalAttributeProcessor, AttributeTypeTokenAcceptor attributeTypeTokenAcceptor, ArtifactReadable artifact, AttributeTypeToken contentAttributeType) {
        List safeAttributeOptionsList = (List)Conditions.requireNonNull(attributeOptionsList, (String)"attributeOptionsList");
        if (safeAttributeOptionsList.isEmpty()) {
            return Optional.empty();
        }
        boolean okToProcess = false;
        Iterator attributeOptionsIterator = safeAttributeOptionsList.iterator();
        AttributeOptions attributeOptions = (AttributeOptions)attributeOptionsIterator.next();
        String attributeName = attributeOptions.getAttributeName();
        okToProcess = WordRenderUtil.isMainContent(true, attributeName, contentAttributeType);
        if (!okToProcess) {
            while (attributeOptionsIterator.hasNext()) {
                attributeOptions = (AttributeOptions)attributeOptionsIterator.next();
                attributeName = attributeOptions.getAttributeName();
                okToProcess = WordRenderUtil.isMainContent(false, attributeName, contentAttributeType);
                if (okToProcess) break;
            }
        }
        if (!(okToProcess && artifact.isAttributeTypeValid(contentAttributeType) && attributeTypeTokenAcceptor.isOk(contentAttributeType))) {
            return Optional.empty();
        }
        StringBuilder stringBuilder = new StringBuilder(2048);
        PublishingAppender publishingAppender = formatIndicator.createPublishingAppender(stringBuilder);
        internalAttributeProcessor.process(publishingAppender, attributeOptions, contentAttributeType, true);
        Optional<CharSequence> result = stringBuilder.length() > 0 ? Optional.of(stringBuilder) : Optional.empty();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static Optional<CharSequence> processAttributes(FormatIndicator formatIndicator, @NonNull List<AttributeOptions> attributeOptionsList, InternalAttributeProcessor internalAttributeProcessor, AttributeTypeFunction attributeTypeFunction, OrderedAttributeTypeSupplier orderedAttributeTypeSupplier, AttributeTypeTokenAcceptor attributeTypeTokenAcceptor, ArtifactReadable artifact, Optional<CharSequence> mainContentOptional, OutlineSectionResult outlineSectionResult, IncludeMainContentForHeadings includeMainContentForHeadings, AttributeTypeToken contentAttributeType, boolean renderAllAttributes) {
        safeAttributeOptionsList = (List)Conditions.requireNonNull(attributeOptionsList, (String)"attributeOptionsList");
        stringBuilder = new StringBuilder(2048);
        publishingAppender = formatIndicator.createPublishingAppender(stringBuilder);
        if (safeAttributeOptionsList.size() == 1 && "*".equals((attributeOptions = (AttributeOptions)safeAttributeOptionsList.get(0)).getAttributeName())) {
            attributeTypeTokens = (Iterable)orderedAttributeTypeSupplier.get();
            for (AttributeTypeToken attributeTypeToken : attributeTypeTokens) {
                if (!artifact.isAttributeTypeValid(attributeTypeToken) || !attributeTypeTokenAcceptor.isOk(attributeTypeToken)) continue;
                if (attributeTypeToken.equals(contentAttributeType)) {
                    mainContentOptional.ifPresent((Consumer<CharSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, append(java.lang.CharSequence ), (Ljava/lang/CharSequence;)V)((PublishingAppender)publishingAppender));
                    continue;
                }
                internalAttributeProcessor.process(publishingAppender, attributeOptions, attributeTypeToken, true);
            }
            return stringBuilder.length() > 0 ? Optional.of(stringBuilder) : Optional.empty();
        }
        block9: for (AttributeOptions attributeOptions2 : safeAttributeOptionsList) {
            var20_23 = attributeName = attributeOptions2.getAttributeName();
            tmp = -1;
            switch (var20_23.hashCode()) {
                case -1913146416: {
                    if (var20_23.equals("<format-content-attribute>")) {
                        tmp = 1;
                    }
                    break;
                }
                case 42: {
                    if (var20_23.equals("*")) {
                        tmp = 2;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    attributeTypeToken = formatIndicator.getContentAttributeTypeToken();
                    ** GOTO lbl39
                }
                default: {
                    attributeTypeToken = (AttributeTypeToken)attributeTypeFunction.apply(attributeName);
lbl39:
                    // 2 sources

                    if (!artifact.isAttributeTypeValid(attributeTypeToken) || !attributeTypeTokenAcceptor.isOk(attributeTypeToken)) continue block9;
                    if (attributeTypeToken.equals(contentAttributeType)) {
                        mainContentOptional.ifPresent((Consumer<CharSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, append(java.lang.CharSequence ), (Ljava/lang/CharSequence;)V)((PublishingAppender)publishingAppender));
                        break;
                    }
                    internalAttributeProcessor.process(publishingAppender, attributeOptions2, attributeTypeToken, true);
                }
                case 2: 
            }
        }
        return stringBuilder.length() > 0 ? Optional.of(stringBuilder) : Optional.empty();
    }

    private static void processMetadataOptions(FormatIndicator formatIndicator, MetadataOptions[] metadataOptionsArray, Map<ApplicabilityId, ApplicabilityToken> applicabilityTokens, ArtifactReadable artifact, PublishingAppender publishingAppender) {
        if (Objects.isNull(metadataOptionsArray)) {
            return;
        }
        Arrays.asList(metadataOptionsArray).forEach(element -> {
            String value;
            String name = element.getType();
            String format = element.getFormat();
            String label = element.getLabel();
            switch (name) {
                case "Applicability": {
                    ApplicabilityToken applicabilityToken;
                    value = artifact.getApplicability().isValid() ? (Objects.nonNull(applicabilityToken = (ApplicabilityToken)applicabilityTokens.get(artifact.getApplicability())) ? applicabilityToken.getName() : artifact.getApplicability().getIdString()) : "unknown";
                    break;
                }
                case "Artifact Type": {
                    value = artifact.getArtifactType().getName();
                    break;
                }
                case "Artifact Id": {
                    value = artifact.getIdString();
                    break;
                }
                default: {
                    value = "";
                }
            }
            publishingAppender.startParagraph();
            publishingAppender.append(WordCoreUtil.replaceRendererOptionToken(formatIndicator, label, format, name, value));
            publishingAppender.endParagraph();
        });
    }

    private static boolean outliningNotAHeading(@NonNull PublishingArtifact artifact, @NonNull AllowedOutlineTypes allowedOutlineTypes, boolean contentAttributeOnly, @Nullable ArtifactTypeToken headingArtifactTypeToken, @Nullable Consumer<PublishingArtifact> invalidAttributesHandler) {
        boolean publishInline;
        boolean containsExcludedAttributes;
        if (contentAttributeOnly) {
            return true;
        }
        boolean okToOutline = allowedOutlineTypes.isAllowed(artifact, headingArtifactTypeToken);
        if (!okToOutline) {
            return true;
        }
        boolean bl = containsExcludedAttributes = artifact.isAttributeTypeValid(CoreAttributeTypes.WholeWordContent) || artifact.isAttributeTypeValid(CoreAttributeTypes.NativeContent);
        if (containsExcludedAttributes) {
            if (invalidAttributesHandler != null) {
                invalidAttributesHandler.accept(artifact);
            }
            return true;
        }
        boolean bl2 = publishInline = artifact.isAttributeTypeValid(CoreAttributeTypes.PublishInline) ? artifact.getSoleAttributeValue(CoreAttributeTypes.PublishInline, false) : false;
        return publishInline;
    }

    private static CharSequence outliningCreateHeading(@NonNull FormatIndicator formatIndicator, @NonNull PublishingArtifact artifact, @Nullable AttributeTypeToken headingAttributeTypeToken, @Nullable String headingFont, @Nullable Function<CharSequence, CharSequence> headingTextFunction, @NonNull IncludeBookmark includeBookmark, boolean overrideOutlineNumber, @NonNull OutlineNumber outlineNumber, @Nullable BiConsumer<PublishingArtifact, CharSequence> updateParagraphNumber) {
        CharSequence headingText;
        StringBuilder stringBuilder = new StringBuilder(2048);
        PublishingAppender publishingAppender = formatIndicator.createPublishingAppender(stringBuilder);
        String string = headingText = headingAttributeTypeToken != null && artifact.isAttributeTypeValid(headingAttributeTypeToken) ? artifact.getSoleAttributeAsString(headingAttributeTypeToken, "") : "";
        if (headingTextFunction != null) {
            headingText = headingTextFunction.apply(headingText);
        }
        Optional<String> paragraphNumberOptional = overrideOutlineNumber ? WordRenderUtil.getOverrideSectionNumber(artifact, outlineNumber).map(outlineNumber::setOutlineNumber) : outlineNumber.getOutlineNumberString();
        String paragraphNumber = paragraphNumberOptional.orElse(null);
        int paragraphLevel = outlineNumber.getOutlineLevel();
        String[] bookmark = null;
        if (includeBookmark.isYes()) {
            bookmark = WordCoreUtil.getWordMlBookmark(artifact.getId());
            artifact.setBookmarked();
        }
        publishingAppender.startOutlineSubSection(bookmark, paragraphNumber, paragraphLevel, headingText, null, headingFont);
        if (updateParagraphNumber != null) {
            updateParagraphNumber.accept(artifact, paragraphNumberOptional.orElse(""));
        }
        return stringBuilder;
    }

    private static OutlineSectionResult processOutlining(@NonNull FormatIndicator formatIndicator, @NonNull PublishingArtifact artifact, @NonNull OutlineNumber outlineNumber, @Nullable ArtifactTypeToken headingArtifactTypeToken, @Nullable AttributeTypeToken headingAttributeTypeToken, @Nullable Function<CharSequence, CharSequence> headingTextFunction, @Nullable String headingFont, @Nullable Consumer<PublishingArtifact> invalidAttributesHandler, @Nullable BiConsumer<PublishingArtifact, CharSequence> updateParagraphNumber, @Nullable ArtifactAcceptor publishArtifactAcceptor, boolean contentAttributeOnly, @NonNull AllowedOutlineTypes allowedOutlineTypes, boolean overrideOutlineNumber, @NonNull IncludeBookmark includeBookmark) {
        boolean excluded;
        FormatIndicator safeFormatIndicator = (FormatIndicator)((Object)Conditions.requireNonNull((Object)((Object)formatIndicator), (String)"formatIndicator"));
        PublishingArtifact safeArtifact = (PublishingArtifact)Conditions.requireNonNull((Object)artifact, (String)"artifact");
        OutlineNumber safeOutlineNumber = (OutlineNumber)Conditions.requireNonNull((Object)outlineNumber, (String)"outlineNumber");
        AllowedOutlineTypes safeAllowedOutlineTypes = (AllowedOutlineTypes)((Object)Conditions.requireNonNull((Object)((Object)allowedOutlineTypes), (String)"allowedOutlineTypes"));
        IncludeBookmark safeIncludeBookmark = (IncludeBookmark)((Object)Conditions.requireNonNull((Object)((Object)includeBookmark), (String)"includeBookmark"));
        boolean bl = publishArtifactAcceptor == null ? false : (excluded = !publishArtifactAcceptor.isOk(artifact));
        if (excluded) {
            return OutlineSectionResult.excluded();
        }
        boolean notAHeading = WordRenderUtil.outliningNotAHeading(safeArtifact, safeAllowedOutlineTypes, contentAttributeOnly, headingArtifactTypeToken, invalidAttributesHandler);
        if (notAHeading) {
            return OutlineSectionResult.notAHeading();
        }
        CharSequence headingText = WordRenderUtil.outliningCreateHeading(safeFormatIndicator, safeArtifact, headingAttributeTypeToken, headingFont, headingTextFunction, safeIncludeBookmark, overrideOutlineNumber, safeOutlineNumber, updateParagraphNumber);
        return OutlineSectionResult.of(headingText);
    }

    public static boolean renderArtifact(boolean allAttributes, AllowedOutlineTypes allowedOutlineTypes, Map<ApplicabilityId, ApplicabilityToken> applicabilityTokens, List<AttributeOptions> attributeOptionsList, AttributeProcessor attributeProcessor, PublishingArtifact artifact, ArtifactAcceptor artifactAcceptor, Consumer<PublishingArtifact> artifactPostProcess, boolean contentAttributeOnly, AttributeTypeToken contentAttributeType, DataRightContentBuilder dataRightContentBuilder, ArtifactAcceptor emptyFoldersArtifactAcceptor, ArtifactAcceptor excludedArtifactTypeArtifactAcceptor, FormatIndicator formatIndicator, ArtifactTypeToken headingArtifactTypeToken, AttributeTypeToken headingAttributeTypeToken, Function<CharSequence, CharSequence> headingTextFunction, ArtifactAcceptor includeBookmarkArtifactAcceptor, IncludeHeadings includeHeadings, IncludeMainContentForHeadings includeMainContentForHeadings, IncludeMetadataAttributes includeMetadataAttributes, Consumer<PublishingArtifact> invalidAttributesHandler, MetadataOptions[] metadataOptionsArray, RelationTableOptions relationTableOptions, OrcsTokenService orcsTokenService, PresentationType presentationType, PublishingAppender publishingAppender, boolean publishInline, OrderedAttributeTypeSupplier orderedAttributeTypeSupplier, OutlineNumber outlineNumber, boolean overrideOutlineNumber, BiConsumer<PublishingArtifact, CharSequence> updateParagraphNumber, ArtifactAcceptor wordRenderApplicabilityChecker) {
        OutlineSectionResult outlineSectionResult = WordRenderUtil.processOutlining(formatIndicator, artifact, outlineNumber, headingArtifactTypeToken, headingAttributeTypeToken, headingTextFunction, "", invalidAttributesHandler, updateParagraphNumber, ArtifactAcceptor.and(emptyFoldersArtifactAcceptor, wordRenderApplicabilityChecker, excludedArtifactTypeArtifactAcceptor, artifactAcceptor), contentAttributeOnly, allowedOutlineTypes, overrideOutlineNumber, includeBookmarkArtifactAcceptor.isOk(artifact) ? IncludeBookmark.YES : IncludeBookmark.NO);
        if (outlineSectionResult.isExcluded()) {
            return false;
        }
        outlineSectionResult.ifStarted(sectionHeading -> {
            if (outlineNumber.isAboveMaximumOutlingLevel()) {
                publishingAppender.endSubSection();
            }
            publishingAppender.append((CharSequence)sectionHeading);
        });
        String footer = dataRightContentBuilder != null && formatIndicator.isWordMl() ? dataRightContentBuilder.getContent(artifact, WordRenderUtil.getPageOrientation(artifact)) : "";
        Optional<CharSequence> mainContentOptional = !outlineSectionResult.isStarted() || includeMainContentForHeadings.isAlways() ? WordRenderUtil.processMainContentAttribute(formatIndicator, attributeOptionsList, (lPublishingAppender, lAttributeOptions, lAttributeType, lAllAttributes) -> attributeProcessor.process(artifact, lPublishingAppender, lAttributeOptions, lAttributeType, lAllAttributes, presentationType, publishInline, footer, !outlineSectionResult.isStarted() && includeBookmarkArtifactAcceptor.isOk(artifact) ? IncludeBookmark.YES : IncludeBookmark.NO), attributeTypeToken2 -> includeHeadings.isNever() || !allowedOutlineTypes.isAllowed(artifact, headingArtifactTypeToken) || !attributeTypeToken2.equals(headingAttributeTypeToken), artifact, contentAttributeType) : Optional.empty();
        boolean includeMetadata = false;
        switch (includeMetadataAttributes) {
            case ALWAYS: {
                includeMetadata = true;
                break;
            }
            case NEVER: {
                includeMetadata = false;
                break;
            }
            case NOT_FOR_HEADINGS: {
                includeMetadata = !outlineSectionResult.isStarted();
                break;
            }
            case ONLY_WITH_MAIN_CONTENT: {
                includeMetadata = mainContentOptional.isPresent();
                break;
            }
            case ONLY_WITH_REQUIREMENT_OR_DESIGN_MSWORD: {
                includeMetadata = artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Requirement, CoreArtifactTypes.DesignMsWord});
                break;
            }
            default: {
                includeMetadata = false;
            }
        }
        if (includeMetadata && !formatIndicator.isMarkdown()) {
            WordRenderUtil.processMetadataOptions(formatIndicator, metadataOptionsArray, applicabilityTokens, artifact, publishingAppender);
        }
        WordRenderUtil.processAttributes(formatIndicator, attributeOptionsList, (lPublishingAppender, lAttributeOptions, lAttributeType, lAllAttributes) -> attributeProcessor.process(artifact, lPublishingAppender, lAttributeOptions, lAttributeType, lAllAttributes, presentationType, publishInline, footer, IncludeBookmark.NO), attributeName -> orcsTokenService.getAttributeType((String)attributeName), orderedAttributeTypeSupplier, attributeTypeToken2 -> includeHeadings.isNever() || !allowedOutlineTypes.isAllowed(artifact, headingArtifactTypeToken) || !attributeTypeToken2.equals(headingAttributeTypeToken), artifact, mainContentOptional, outlineSectionResult, includeMainContentForHeadings, contentAttributeType, allAttributes).ifPresent(publishingAppender::append);
        if (includeMetadata && formatIndicator.isMarkdown()) {
            WordRenderUtil.processMetadataOptions(formatIndicator, metadataOptionsArray, applicabilityTokens, artifact, publishingAppender);
        }
        WordRenderUtil.processRelationTable(formatIndicator, relationTableOptions, artifact, publishingAppender, orcsTokenService);
        if (formatIndicator.isWordMl() && !artifact.hasAttributeContent(CoreAttributeTypes.WordTemplateContent) && Strings.isValidAndNonBlank((String)footer)) {
            publishingAppender.append(footer);
        }
        publishingAppender.endArtifact();
        if (artifactPostProcess != null) {
            artifactPostProcess.accept(artifact);
        }
        return outlineSectionResult.isStarted();
    }

    public static void processRelationTable(FormatIndicator formatIndicator, RelationTableOptions relationTableOptions, PublishingArtifact artifact, PublishingAppender publishingAppender, OrcsTokenService orcsTokenService) {
        try {
            RelationTableAppender tableAppender;
            switch (formatIndicator) {
                case MARKDOWN: {
                    tableAppender = new HtmlRelationTableAppender();
                    break;
                }
                case WORD_ML: {
                    tableAppender = new WordRelationTableAppender();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported format: " + (Object)((Object)formatIndicator));
                }
            }
            RelationTableBuilder builder = new RelationTableBuilder(relationTableOptions, artifact, orcsTokenService, tableAppender);
            builder.buildRelationTable();
            publishingAppender.append(tableAppender.getTable());
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"WordRenderUtil::processRelationTable, failed to process relation table.").indentInc().segment((CharSequence)"Publishing Artifact Name", (Object)artifact.getName()).segment((CharSequence)"Publishing Artifact ID", (Object)artifact.getArtifactId()).segment((CharSequence)"Publishing Relation Table Artifact Types", relationTableOptions.getRelationTableArtifactTypeNamesAndOrIds()).segment((CharSequence)"Publishing Relation Table Relation Type Sides", relationTableOptions.getRelationTableRelationTypeSides()).segment((CharSequence)"Publishing Relation Table Columns", relationTableOptions.getRelationTableColumns()).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
    }

    public static void renderAttribute(FormatIndicator formatIndicator, AttributeTypeToken attributeType, RelationOrderFunction relationOrderFunction, ArtifactReadable artifactReadable, PublishingAppender publishingAppender, String label, String format) {
        String name = attributeType.getUnqualifiedName();
        if (attributeType.equals(CoreAttributeTypes.RelationOrder)) {
            if (Objects.isNull(relationOrderFunction)) {
                return;
            }
            publishingAppender.startParagraph();
            publishingAppender.addRunWithTextEscape((CharSequence)name);
            publishingAppender.endParagraph();
            String data = (String)relationOrderFunction.apply(artifactReadable);
            publishingAppender.append(data);
        } else {
            String value = artifactReadable.getAttributeValuesAsString(attributeType);
            publishingAppender.startParagraph();
            publishingAppender.append(WordCoreUtil.replaceRendererOptionToken(formatIndicator, label, format, name, value));
            publishingAppender.endParagraph();
        }
    }

    public static String renderWordAttribute(PublishingArtifact artifact, ArtifactId viewId, PublishingAppender publishingAppender, RendererMap rendererMap, PresentationType presentationType, String label, String footer, String desktopClientLoopbackUrl, boolean artifactIsChanged, IncludeBookmark includeBookmark, TransactionToken historicalArtifactTransactionToken, Set<String> unknownGuids, RenderWordTemplateContentOperation renderWordTemplateContentOperation, ExceptionHandler exceptionHandler) {
        String wordMlContentDataAndFooter;
        block14: {
            if (Objects.nonNull(publishingAppender) && Strings.isValidAndNonBlank((String)label)) {
                publishingAppender.addParagraph(label);
            }
            ArtifactId artifactId = ArtifactId.create(artifact);
            BranchId branchId = BranchId.valueOf(artifact.getBranch().getId());
            IncludeBookmark safeIncludeBookmark = includeBookmark != null && includeBookmark.isYes() && !artifact.isBookmarked() ? IncludeBookmark.YES : IncludeBookmark.NO;
            WordTemplateContentData wtcData = new WordTemplateContentData();
            wtcData.setArtId(artifactId);
            wtcData.setBranch(branchId);
            wtcData.setViewId(viewId);
            wtcData.setFooter(footer);
            wtcData.setIsEdit(presentationType == PresentationType.SPECIALIZED_EDIT);
            wtcData.setLinkType((LinkType)((Object)rendererMap.getRendererOptionValue(RendererOption.LINK_TYPE)));
            wtcData.setPresentationType(presentationType);
            wtcData.setTxId(historicalArtifactTransactionToken);
            wtcData.setDesktopClientLoopbackUrl(desktopClientLoopbackUrl);
            wtcData.setArtIsChanged(artifactIsChanged);
            wtcData.setIncludeBookmark(safeIncludeBookmark);
            wordMlContentDataAndFooter = "";
            try {
                Pair content = (Pair)renderWordTemplateContentOperation.apply(wtcData);
                if (Objects.nonNull(content)) {
                    wordMlContentDataAndFooter = (String)content.getFirst();
                    Set contentUnknownGuids = (Set)content.getSecond();
                    if (!contentUnknownGuids.isEmpty()) {
                        unknownGuids.addAll((Collection)content.getSecond());
                    }
                }
            }
            catch (Exception e) {
                if (Objects.nonNull(publishingAppender)) {
                    publishingAppender.addParagraphNoEscape("Failed to parse content for artifact.");
                    publishingAppender.startParagraph();
                    publishingAppender.addRunWithTextEscape("Artifact: ", artifact.toStringWithId());
                    publishingAppender.endParagraph();
                    publishingAppender.startParagraph();
                    publishingAppender.addRunWithTextEscape("Branch: ", branchId.toString());
                    publishingAppender.endParagraph();
                }
                OseeCoreException renderException = new OseeCoreException(new Message().title((CharSequence)"Failed to parse content for artifact.").indentInc().segment((CharSequence)"Artifact", (Object)artifact.toStringWithId()).segment((CharSequence)"Branch", (Object)branchId).reasonFollowsWithTrace((Throwable)e).toString(), (Throwable)e);
                if (!Objects.nonNull(exceptionHandler)) break block14;
                exceptionHandler.accept(renderException);
            }
        }
        if (Objects.nonNull(publishingAppender)) {
            if (PresentationType.SPECIALIZED_EDIT.equals((Object)presentationType)) {
                publishingAppender.addEditParagraphNoEscape(WordCoreUtil.getStartEditImage(artifact.getGuid()));
                if (Objects.nonNull(wordMlContentDataAndFooter)) {
                    publishingAppender.append(wordMlContentDataAndFooter);
                }
                publishingAppender.addEditParagraphNoEscape(WordCoreUtil.getEndEditImage(artifact.getGuid()));
            } else if (Objects.nonNull(wordMlContentDataAndFooter)) {
                publishingAppender.append(wordMlContentDataAndFooter);
                if (WordCoreUtil.containsLists(wordMlContentDataAndFooter)) {
                    publishingAppender.resetListValue();
                }
            } else if (Objects.nonNull(footer)) {
                publishingAppender.append(footer);
            }
        }
        return wordMlContentDataAndFooter;
    }

    public static void setupPublishingTemplate(FormatIndicator formatIndicator, PublishingTemplate publishingTemplate, PublishingAppender publishingAppender, String outlineNumber, String outlineType) {
        if (formatIndicator.isWordMl()) {
            publishingTemplate.update(WordCoreUtil::cleanupPageNumberTypeStart1);
            publishingTemplate.update(templateContent -> WordCoreUtil.initializePublishingTemplateOutliningNumbers(outlineNumber, templateContent, outlineType));
        }
    }

    @FunctionalInterface
    public static interface AttributeProcessor {
        public void process(PublishingArtifact var1, PublishingAppender var2, AttributeOptions var3, AttributeTypeToken var4, boolean var5, PresentationType var6, boolean var7, String var8, IncludeBookmark var9);
    }

    @FunctionalInterface
    public static interface AttributeTypeFunction
    extends Function<String, AttributeTypeToken> {
    }

    @FunctionalInterface
    public static interface AttributeTypeTokenAcceptor {
        public boolean isOk(AttributeTypeToken var1);
    }

    @FunctionalInterface
    public static interface DataRightsProvider {
        public DataRightResult getDataRights(BranchId var1, String var2, List<ArtifactId> var3);
    }

    @FunctionalInterface
    public static interface ExceptionHandler
    extends Consumer<Throwable> {
    }

    @FunctionalInterface
    static interface InternalAttributeProcessor {
        public void process(PublishingAppender var1, AttributeOptions var2, AttributeTypeToken var3, boolean var4);
    }

    @FunctionalInterface
    public static interface OrderedAttributeTypeSupplier
    extends Supplier<Iterable<AttributeTypeToken>> {
    }

    @FunctionalInterface
    public static interface RelationOrderFunction
    extends Function<ArtifactReadable, String> {
    }

    @FunctionalInterface
    public static interface RenderWordTemplateContentOperation
    extends Function<WordTemplateContentData, Pair<String, Set<String>>> {
    }
}

