/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public enum RequiredIndicator implements ToMessage
{
    RESTRICTED_RIGHTS(0, "Restricted Rights"),
    GOVERNMENT_PURPOSE_RIGHTS(1, "Government Purpose Rights"),
    UNSPECIFIED(2, "Unspecified"),
    PROPRIETARY(3, "Proprietary"),
    LIMITED_RIGHTS(4, "Limited Rights"),
    UNLIMITED_RIGHTS(5, "Unlimited Rights"),
    EXPORT_CONTROLLED_ITAR(6, "Export Controlled ITAR");

    private static final Map<RequiredIndicatorEnum, RequiredIndicator> requiredIndicatorEnumMap;
    private static final Map<String, RequiredIndicator> requiredIndicatorMap;
    private RequiredIndicatorEnum enumToken;

    static {
        requiredIndicatorMap = Arrays.stream(RequiredIndicator.values()).collect(Collectors.toUnmodifiableMap(RequiredIndicator::getDisplayName, Function.identity()));
        requiredIndicatorEnumMap = Arrays.stream(RequiredIndicator.values()).collect(Collectors.toUnmodifiableMap(RequiredIndicator::getEnumToken, Function.identity()));
    }

    public static Optional<RequiredIndicator> valueOfAttribute(String attributeValueString) {
        return Optional.ofNullable(requiredIndicatorMap.get(attributeValueString));
    }

    public static Optional<RequiredIndicator> valueOfEnumToken(RequiredIndicatorEnum enumToken) {
        return Optional.ofNullable(requiredIndicatorEnumMap.get((Object)enumToken));
    }

    private RequiredIndicator(int enumTokenOrdinal, String enumTokenName) {
        this.enumToken = new RequiredIndicatorEnum(enumTokenOrdinal, enumTokenName);
    }

    public String getDisplayName() {
        return this.enumToken.getName();
    }

    public RequiredIndicatorEnum getEnumToken() {
        return this.enumToken;
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.isNull(message) ? new Message() : message;
        outMessage.segment((CharSequence)this.name(), (Object)this.enumToken.getName());
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    public static class RequiredIndicatorEnum
    extends EnumToken {
        public RequiredIndicatorEnum(int ordinal, String name) {
            super(ordinal, name, new NamespaceToken[0]);
        }
    }
}

