/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.publishing.EnumRendererMap;
import org.eclipse.osee.framework.core.publishing.RendererMapDeserializer;
import org.eclipse.osee.framework.core.publishing.RendererMapSerializer;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.publishing.UnmodifiableRendererMap;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

@JsonSerialize(using=RendererMapSerializer.class)
@JsonDeserialize(using=RendererMapDeserializer.class)
public interface RendererMap
extends Iterable<Map.Entry<RendererOption, Object>>,
ToMessage {
    public static RendererMap deserialize(@NonNull JsonParser jsonParser) throws IOException {
        Objects.requireNonNull(jsonParser);
        EnumRendererMap rendererOptions = new EnumRendererMap();
        JsonNode readTree = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (Objects.isNull(readTree)) {
            throw new OseeCoreException("RendererMap::deserialize, failed to get JsonNode readTree.", new Object[0]);
        }
        if (!readTree.isObject()) {
            throw new OseeCoreException("ReadTree is not Object", new Object[0]);
        }
        ObjectNode objectNode = (ObjectNode)readTree;
        Iterator fieldIterator = objectNode.fields();
        while (fieldIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIterator.next();
            String key = (String)field.getKey();
            RendererOption rendererOption = RendererOption.ofKey(key).orElseThrow();
            JsonNode value = (JsonNode)field.getValue();
            Object valueObject = rendererOption.readValue(value);
            rendererOptions.setRendererOption(rendererOption, valueObject);
        }
        return rendererOptions;
    }

    public static RendererMap of() {
        return UnmodifiableRendererMap.emptyRendererMap;
    }

    public static RendererMap of(Object ... objects) {
        return Objects.isNull(objects) || objects.length == 0 ? UnmodifiableRendererMap.emptyRendererMap : new UnmodifiableRendererMap(objects);
    }

    public static RendererMap of(RendererMap rendererMap) {
        return Objects.isNull(rendererMap) ? UnmodifiableRendererMap.emptyRendererMap : new UnmodifiableRendererMap(rendererMap);
    }

    public void free();

    public <T> T getRendererOptionValue(RendererOption var1);

    public boolean isRendererOptionSet(RendererOption var1);

    public boolean isRendererOptionSetAndFalse(RendererOption var1);

    public boolean isRendererOptionSetAndTrue(RendererOption var1);

    @Override
    public Iterator<Map.Entry<RendererOption, Object>> iterator();

    public Set<RendererOption> keySet();

    public <T> T removeRendererOption(RendererOption var1);

    default public void serialize(@NonNull JsonGenerator jsonGenerator) throws IOException {
        Objects.requireNonNull(jsonGenerator);
        jsonGenerator.writeStartObject();
        for (Map.Entry<RendererOption, Object> mapEntry : this) {
            jsonGenerator.writeObjectField(mapEntry.getKey().getKey(), mapEntry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    public <T> T setRendererOption(RendererOption var1, T var2);

    public RendererMap unmodifiableRendererMap();
}

