/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class ProcessedArtifactTracker {
    private static final String[] addErrorTitles = new String[]{"ProcessedArtifactTracker:add, artifact identifier and GUID have already been recorded.", "ProcessedArtifactTracker:add, artifact GUID has already been recorded.", "ProcessedArtifactTracker:add, artifact identifier has already been recorded."};
    private static final int initialMapSize = 2048;
    private final Map<ArtifactId, ArtifactRecord> artifactRecordByArtifactId = new HashMap<ArtifactId, ArtifactRecord>(2048);
    private final Map<String, ArtifactRecord> artifactRecordByGuid = new HashMap<String, ArtifactRecord>(2048);

    public void add(PublishingArtifact artifact) {
        String guid;
        ArtifactRecord artifactRecord;
        Objects.requireNonNull(artifact, "ProcessedArtifactTracker::add, parameter \"artifact\" cannot be null.");
        if (ArtifactReadable.SENTINEL.equals(artifact)) {
            throw new IllegalArgumentException("ProcessedArtifactTracker::add, parameter \"artifact\" cannot be SENTINEL.");
        }
        if (this.isCachedAndNotDone(artifact)) {
            return;
        }
        ArtifactId artifactId = ArtifactId.create(artifact);
        int titleIndex = (Objects.isNull(this.artifactRecordByArtifactId.put(artifactId, artifactRecord = new ArtifactRecord(artifactId, guid = artifact.getGuid()))) ? 1 : 0) + (Objects.isNull(this.artifactRecordByGuid.put(guid, artifactRecord)) ? 2 : 0);
        if (titleIndex < 3) {
            throw new OseeCoreException(new Message().title((CharSequence)addErrorTitles[titleIndex]).indentInc().segment((CharSequence)"Artifact Id", (Object)artifactId).segment((CharSequence)"GUID", (Object)guid).toString(), new Object[0]);
        }
    }

    public void add(Collection<PublishingArtifact> artifacts) {
        Objects.requireNonNull(artifacts, "ProcessedArtifactTracker::add, parameter \"artifacts\" cannot be null.");
        artifacts.forEach(this::add);
    }

    public void clear() {
        this.artifactRecordByArtifactId.clear();
        this.artifactRecordByGuid.clear();
    }

    public boolean contains(ArtifactId artifactId) {
        Objects.requireNonNull(artifactId, "ProcessedArtifactTracker::contains, parameter \"artifactId\" cannot be null.");
        if (ArtifactId.SENTINEL.equals(artifactId)) {
            throw new IllegalArgumentException("ProcessedArtifactTracker::contains, parameter \"artifactId\" cannot be SENTINEL.");
        }
        return this.artifactRecordByArtifactId.containsKey(artifactId);
    }

    public boolean contains(String artifactGuid) {
        Objects.requireNonNull(artifactGuid, "ProcessedArtifactTracker::contains, parameter \"artifactGuid\" cannot be null.");
        return this.artifactRecordByGuid.containsKey(artifactGuid);
    }

    public boolean containsByLinkReference(String linkReference) {
        Objects.requireNonNull(linkReference, "ProcessedArtifactTracker::containsByLinkReference, parameter \"linkReference\" cannot be null.");
        return WordCoreUtil.isLinkReferenceAnArtifactId(linkReference) ? this.artifactRecordByArtifactId.containsKey(ArtifactId.valueOf(linkReference)) : this.artifactRecordByGuid.containsKey(linkReference);
    }

    public Optional<String> get(ArtifactId artifactId) {
        Objects.requireNonNull(artifactId, "ProcessedArtifactTracker::get, parameter \"artifactId\" cannot be null.");
        if (ArtifactId.SENTINEL.equals(artifactId)) {
            throw new IllegalArgumentException("ProcessedArtifactTracker::get, parameter \"artifactId\" cannot be SENTINEL.");
        }
        ArtifactRecord artifactRecord = this.artifactRecordByArtifactId.get(artifactId);
        return Objects.nonNull(artifactRecord) ? Optional.ofNullable(artifactRecord.guid) : Optional.empty();
    }

    public Optional<ArtifactId> get(String artifactGuid) {
        Objects.requireNonNull(artifactGuid, "ProcessedArtifactTracker::get, parameter \"artifactGuid\" cannot be null.");
        ArtifactRecord artifactRecord = this.artifactRecordByGuid.get(artifactGuid);
        return Objects.nonNull(artifactRecord) ? Optional.ofNullable(artifactRecord.artifactId) : Optional.empty();
    }

    private Optional<ArtifactRecord> getByLinkReference(String linkReference) {
        Objects.requireNonNull(linkReference, "ProcessedArtifactTracker::setBookmaked, parameter \"linkReference\" cannot be null.");
        ArtifactRecord artifactRecord = WordCoreUtil.isLinkReferenceAnArtifactId(linkReference) ? this.artifactRecordByArtifactId.get(ArtifactId.valueOf(linkReference)) : this.artifactRecordByGuid.get(linkReference);
        return Optional.ofNullable(artifactRecord);
    }

    public void incrementAttributeCount(ArtifactId artifactId) {
        Objects.requireNonNull(artifactId, "ProcessedArtifactTracker::contains, parameter \"artifactId\" cannot be null.");
        if (ArtifactId.SENTINEL.equals(artifactId)) {
            throw new IllegalArgumentException("ProcessedArtifactTracker::contains, parameter \"artifactId\" cannot be SENTINEL.");
        }
        ArtifactRecord artifactRecord = this.artifactRecordByArtifactId.get(artifactId);
        if (Objects.isNull(artifactRecord)) {
            throw new IllegalStateException(new Message().title((CharSequence)"ProcessedArtifactTracker::incrementAttributeCount, attempt to get artifact record for an untracked artifact.").indentInc().segment((CharSequence)"Artifact Id", (Object)artifactId.getIdString()).toString());
        }
        ++artifactRecord.attributeCount;
    }

    public boolean isBookmarked(String linkReference) {
        return this.getByLinkReference(linkReference).map(ArtifactRecord::isBookmarked).orElse(false);
    }

    public boolean isCachedAndNotDone(ArtifactId artifactId) {
        ArtifactRecord artifactRecord;
        return Objects.nonNull(artifactId) && !ArtifactId.SENTINEL.equals(artifactId) && Objects.nonNull(artifactRecord = this.artifactRecordByArtifactId.get(artifactId)) ? artifactRecord.cached && !artifactRecord.ok : false;
    }

    public boolean isNotBookmarked(Map.Entry<String, ArtifactReadable> hyperlinkEntry) {
        return !this.isBookmarked(hyperlinkEntry.getKey());
    }

    public boolean isOk(ArtifactId artifactId) {
        ArtifactRecord artifactRecord;
        return Objects.nonNull(artifactId) && !ArtifactId.SENTINEL.equals(artifactId) && Objects.nonNull(artifactRecord = this.artifactRecordByArtifactId.get(artifactId)) ? artifactRecord.ok : false;
    }

    public boolean isPublished(String linkReference) {
        return this.getByLinkReference(linkReference).map(ArtifactRecord::isPublished).orElse(false);
    }

    public void setBookmarked(String linkReference) {
        this.getByLinkReference(linkReference).ifPresentOrElse(ArtifactRecord::setBookmarked, () -> {
            throw new IllegalStateException(new Message().title((CharSequence)"ProcessedArtifactTracker::setBookmarked, attepmt to get artifact record by link reference for an untracked artifact.").indentInc().segment((CharSequence)"Link Reference", (Object)linkReference).toString());
        });
    }

    public void setCached(ArtifactId artifactId) {
        Objects.requireNonNull(artifactId, "ProcessedArtifactTracker::setChached, parameter \"artifactId\" cannot be null.");
        if (ArtifactId.SENTINEL.equals(artifactId)) {
            throw new IllegalArgumentException("ProcessedArtifactTracker::setCached, parameter \"artifactId\" cannot be SENTINEL.");
        }
        ArtifactRecord artifactRecord = this.artifactRecordByArtifactId.get(artifactId);
        if (Objects.isNull(artifactRecord)) {
            throw new IllegalStateException(new Message().title((CharSequence)"ProcessedArtifactTracker::setCached, attempt to get artifact record for an untracked artifact.").indentInc().segment((CharSequence)"Artifact Id", (Object)artifactId).toString());
        }
        artifactRecord.setCached();
    }

    public void setOk(ArtifactId artifactId) {
        Objects.requireNonNull(artifactId, "ProcessedArtifactTracker::setOk, parameter \"artifactId\" cannot be null.");
        if (ArtifactId.SENTINEL.equals(artifactId)) {
            throw new IllegalArgumentException("ProcessedArtifactTracker::setOk, parameter \"artifactId\" cannot be SENTINEL.");
        }
        ArtifactRecord artifactRecord = this.artifactRecordByArtifactId.get(artifactId);
        if (Objects.isNull(artifactRecord)) {
            throw new IllegalStateException(new Message().title((CharSequence)"ProcessedArtifactTracker::add, attempt to set OK status for untracked artifact.").indentInc().segment((CharSequence)"ArtifactId", (Object)artifactId).toString());
        }
        artifactRecord.ok = true;
    }

    public void setOk(Collection<? extends ArtifactId> artifactIds) {
        Objects.requireNonNull(artifactIds, "ProcessedArtifactTracker::setOk, parameter \"artifactIds\" cannot be null.");
        artifactIds.forEach(this::setOk);
    }

    public int size() {
        return this.artifactRecordByArtifactId.size();
    }

    private class ArtifactRecord {
        ArtifactId artifactId;
        int attributeCount;
        boolean bookmarked;
        boolean cached;
        String guid;
        boolean ok;

        ArtifactRecord(ArtifactId artifactId, String guid) {
            assert (Objects.nonNull(artifactId) && !(artifactId instanceof ArtifactReadable) && !(artifactId instanceof ArtifactToken)) : "ArtifactRecord::new, parameter \"artifactId\" is null or a reference to a full artifact.";
            assert (Objects.nonNull(guid)) : "ArtifactRecord::new, parameter \"guid\" cannot be null.";
            this.artifactId = artifactId;
            this.guid = guid;
            this.cached = false;
            this.ok = false;
            this.bookmarked = false;
            this.attributeCount = 0;
        }

        boolean isBookmarked() {
            return this.bookmarked;
        }

        boolean isCached() {
            return this.cached;
        }

        boolean isPublished() {
            return this.attributeCount > 0;
        }

        void setBookmarked() {
            this.bookmarked = true;
        }

        void setCached() {
            this.cached = true;
        }
    }
}

