/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.IdSerializer;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

@JsonSerialize(using=IdSerializer.class)
public interface ModificationType
extends NamedId {
    public static final ModificationType SENTINEL = ModificationType.internalCreate(Id.SENTINEL, "");
    public static final ModificationType NEW = ModificationType.internalCreate(1L, "New");
    public static final ModificationType MODIFIED = ModificationType.internalCreate(2L, "Modified");
    public static final ModificationType DELETED = ModificationType.internalCreate(3L, "Deleted");
    public static final ModificationType MERGED = ModificationType.internalCreate(4L, "Merged");
    public static final ModificationType ARTIFACT_DELETED = ModificationType.internalCreate(5L, "Artifact Deleted");
    public static final ModificationType INTRODUCED = ModificationType.internalCreate(6L, "Introduced");
    public static final ModificationType UNDELETED = ModificationType.internalCreate(7L, "Undeleted");
    public static final ModificationType REPLACED_WITH_VERSION = ModificationType.internalCreate(8L, "Replace_with_version");
    public static final ModificationType DELETED_ON_DESTINATION = ModificationType.internalCreate(9L, "Deleted on Destination");
    public static final ModificationType APPLICABILITY = ModificationType.internalCreate(10L, "Applicability");
    public static final ModificationType[] values = new ModificationType[]{SENTINEL, NEW, MODIFIED, DELETED, MERGED, ARTIFACT_DELETED, INTRODUCED, UNDELETED, REPLACED_WITH_VERSION, DELETED_ON_DESTINATION, APPLICABILITY};

    public static ModificationType internalCreate(Long id, String name) {
        final class ModificationTypeImpl
        extends NamedIdBase
        implements ModificationType {
            public ModificationTypeImpl(Long id, String name) {
                super(id, name);
            }
        }
        return new ModificationTypeImpl(id, name);
    }

    public static ModificationType valueOf(String id) {
        return (ModificationType)Id.valueOf((String)id, ModificationType::valueOf);
    }

    default public boolean isIncluded(DeletionFlag deletionFlag) {
        return !deletionFlag.equals((Object)DeletionFlag.EXCLUDE_DELETED) || !this.isDeleted();
    }

    public static ModificationType valueOf(long id) {
        if (id == -1L) {
            return SENTINEL;
        }
        if (id > (long)values.length) {
            throw new OseeArgumentException("[%s] is not a valid ModificationType value", new Object[]{id});
        }
        return values[(int)id];
    }

    default public boolean isEdited() {
        return this == MERGED || this == MODIFIED;
    }

    default public boolean isDeleted() {
        return this == DELETED || this == ARTIFACT_DELETED;
    }

    default public boolean isUnDeleted() {
        return this == UNDELETED;
    }

    default public boolean isArtifactDeleted() {
        return this == ARTIFACT_DELETED;
    }

    default public boolean isHardDeleted() {
        return this == DELETED;
    }

    default public boolean isExistingVersionUsed() {
        return this.matches(new Id[]{ARTIFACT_DELETED, DELETED, INTRODUCED, REPLACED_WITH_VERSION});
    }
}

