/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.enums.PresentationType;

public enum CommandGroup {
    EDIT(PresentationType.SPECIALIZED_EDIT, false),
    PREVIEW(PresentationType.PREVIEW, true),
    SHOW(PresentationType.SPECIALIZED_EDIT, true);

    private static List<CommandGroup> allGroups;
    private static List<CommandGroup> readOnlyGroups;
    boolean isReadOnlyPresentation;
    PresentationType presentationType;

    static {
        allGroups = List.of(CommandGroup.values());
        readOnlyGroups = Stream.of(CommandGroup.values()).filter(CommandGroup::isReadOnly).collect(Collectors.toList());
    }

    public static List<CommandGroup> getCommandGroups(boolean readOnly) {
        return readOnly ? readOnlyGroups : allGroups;
    }

    private CommandGroup(PresentationType type, boolean isReadOnlyPresentation) {
        this.presentationType = type;
        this.isReadOnlyPresentation = isReadOnlyPresentation;
    }

    public PresentationType getPresentationType() {
        return this.presentationType;
    }

    public boolean isEdit() {
        return !this.isReadOnlyPresentation;
    }

    public boolean isReadOnly() {
        return this.isReadOnlyPresentation;
    }
}

