/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.MapEntryAttributeUtil;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.FileExtension;

public class AttributeTypeMapEntry
extends AttributeTypeGeneric<Map.Entry<String, String>> {
    private final Supplier<String> keyDescriptionSupplier;
    private final Supplier<String> valueDescriptionSupplier;

    public AttributeTypeMapEntry(Long identifier, NamespaceToken namespace, String name, String description, Supplier<String> keyDescriptionSupplier, Supplier<String> valueDescriptionSupplier, String defaultKey, String defaultValue) {
        super(identifier, namespace, name, "application/json", description, TaggerTypeToken.SENTINEL, FileExtension.JSON.getFileExtension(), Map.entry(defaultKey, defaultValue), null, DisplayHint.MultiLine);
        this.keyDescriptionSupplier = keyDescriptionSupplier;
        this.valueDescriptionSupplier = valueDescriptionSupplier;
    }

    public String getKeyDescription() {
        return Objects.nonNull(this.keyDescriptionSupplier) ? this.keyDescriptionSupplier.get() : "";
    }

    public String getValueDescription() {
        return Objects.nonNull(this.valueDescriptionSupplier) ? this.valueDescriptionSupplier.get() : "";
    }

    @Override
    public boolean isMapEntry() {
        return true;
    }

    @Override
    public boolean isUri() {
        return false;
    }

    @Override
    public String storageStringFromValue(Map.Entry<String, String> mapEntry) {
        return MapEntryAttributeUtil.jsonEncode(mapEntry);
    }

    @Override
    public Map.Entry<String, String> valueFromStorageString(String value) {
        return MapEntryAttributeUtil.jsonDecode(value);
    }
}

