/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public final class AttributeTypeInputStream
extends AttributeTypeGeneric<InputStream> {
    public static final InputStream defaultValue = new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8));

    public AttributeTypeInputStream(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType, String fileExtension) {
        super(id, namespace, name, mediaType, description, taggerType, fileExtension, defaultValue, null, new DisplayHint[0]);
    }

    @Override
    public boolean isInputStream() {
        return true;
    }

    @Override
    public InputStream valueFromStorageString(String storedValue) {
        try {
            return Lib.stringToInputStream((String)storedValue);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    @Override
    public String storageStringFromValue(InputStream value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDisplayableString(InputStream date) {
        return date != null ? new SimpleDateFormat("MM/dd/yyyy hh:mm a").format(date) : "";
    }
}

