/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.OperationTypeToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdDescription;

public abstract class AttributeTypeGeneric<T>
extends NamedIdDescription
implements AttributeTypeToken {
    public static final AttributeTypeString SENTINEL = AttributeTypeToken.createString(Id.SENTINEL, NamespaceToken.OSEE, "Sentinel", "Sentinel", "", "");
    private final String mediaType;
    private final TaggerTypeToken taggerType;
    private final NamespaceToken namespace;
    private final String fileExtension;
    private final T defaultValue;
    private final Set<OperationTypeToken> operationTypes;
    protected final Set<DisplayHint> displayHints = new HashSet<DisplayHint>();

    public AttributeTypeGeneric(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType, String fileExtension, T defaultValue, Set<OperationTypeToken> operationTypes, DisplayHint ... hints) {
        super(id, name, description);
        this.namespace = namespace;
        this.mediaType = mediaType;
        this.taggerType = taggerType;
        this.fileExtension = fileExtension;
        this.defaultValue = defaultValue;
        DisplayHint[] displayHintArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayHint hint = displayHintArray[n2];
            this.displayHints.add(hint);
            ++n2;
        }
        this.operationTypes = operationTypes != null ? operationTypes : new HashSet();
    }

    public T getBaseAttributeTypeDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    public T valueFromDouble(double value) {
        return null;
    }

    public abstract T valueFromStorageString(String var1);

    public String storageStringFromValue(T value) {
        return value.toString();
    }

    public String getDisplayableString(T value) {
        return this.storageStringFromValue(value);
    }

    @Override
    public TaggerTypeToken getTaggerType() {
        return this.taggerType;
    }

    @Override
    public NamespaceToken getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isTaggable() {
        return this.taggerType.isValid();
    }

    @Override
    public Set<DisplayHint> getDisplayHints() {
        return this.displayHints;
    }

    public void addDisplayHint(DisplayHint displayHint) {
        this.displayHints.add(displayHint);
    }

    @Override
    public Set<OperationTypeToken> getOperationTypes() {
        return this.operationTypes;
    }
}

