/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;

public class ArtifactTokenDeserializer
extends StdDeserializer<ArtifactToken> {
    private static final long serialVersionUID = 596564602216588283L;

    public ArtifactTokenDeserializer() {
        this(ArtifactToken.class);
    }

    public ArtifactTokenDeserializer(Class<?> object) {
        super(object);
    }

    public ArtifactToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode readTree = (JsonNode)jp.getCodec().readTree(jp);
        Long id = readTree.get("id").asLong();
        String name = readTree.get("name").textValue();
        Long typeId = ArtifactToken.SENTINEL.getId();
        String typeName = ArtifactToken.SENTINEL.getName();
        if (readTree.has("typeId")) {
            typeId = readTree.get("typeId").asLong();
        }
        if (readTree.has("typeName")) {
            typeName = readTree.get("typeName").textValue();
        }
        return ArtifactToken.valueOf((long)id, name, ArtifactTypeToken.valueOf(typeId, typeName, new ArtifactTypeToken[0]));
    }
}

