/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.operation;

import java.util.List;
import org.eclipse.osee.framework.core.access.object.AccessObject;
import org.eclipse.osee.framework.core.access.operation.AccessCache;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.PermissionEnum;

public class AccessRankOperations {
    private final AccessCache cache;

    public AccessRankOperations(AccessCache cache) {
        this.cache = cache;
    }

    public PermissionEnum acquirePermissionRank(ArtifactToken subject, AccessObject accessObject) {
        PermissionEnum userPermission = (PermissionEnum)((Object)this.cache.accessControlListCache.get((Object)subject.getId(), (Object)accessObject));
        if (this.cache.subjectToGroupCache.containsKey((Object)subject.getId())) {
            for (ArtifactId groupPermissionId : (List)this.cache.subjectToGroupCache.getValues((Object)subject.getId())) {
                PermissionEnum groupPermission = (PermissionEnum)((Object)this.cache.accessControlListCache.get((Object)groupPermissionId.getId(), (Object)accessObject));
                if (groupPermission == null) continue;
                if (userPermission == null) {
                    userPermission = groupPermission;
                    continue;
                }
                if (groupPermission.getRank() <= userPermission.getRank()) continue;
                userPermission = groupPermission;
            }
        }
        if (userPermission == null) {
            userPermission = this.cache.objectToSubjectCache.containsKey((Object)accessObject) ? PermissionEnum.DENY : PermissionEnum.FULLACCESS;
        }
        return userPermission;
    }
}

