/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.context;

import java.util.Collection;
import org.eclipse.osee.framework.core.access.AccessTypeMatch;
import org.eclipse.osee.framework.core.access.context.AccessType;
import org.eclipse.osee.framework.core.access.context.AllowDeny;
import org.eclipse.osee.framework.core.access.context.IParentProvider;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;

public class ArtifactAndChildrenArtifactTypesAccessType
implements AccessType {
    private AllowDeny allowDeny;
    private ArtifactToken artifact;
    private Collection<ArtifactTypeToken> childArtTypes;

    public ArtifactAndChildrenArtifactTypesAccessType(AllowDeny allowDeny, ArtifactToken artifact, Collection<ArtifactTypeToken> childArtTypes) {
        this.allowDeny = allowDeny;
        this.artifact = artifact;
        this.childArtTypes = childArtTypes;
    }

    public AllowDeny getAllowDeny() {
        return this.allowDeny;
    }

    public void setAllowDeny(AllowDeny allowDeny) {
        this.allowDeny = allowDeny;
    }

    @Override
    public boolean isArtifactType() {
        return true;
    }

    public ArtifactToken getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ArtifactToken artifact) {
        this.artifact = artifact;
    }

    public Collection<ArtifactTypeToken> getChildArtTypes() {
        return this.childArtTypes;
    }

    public void setChildArtTypes(Collection<ArtifactTypeToken> childArtTypes) {
        this.childArtTypes = childArtTypes;
    }

    public String toString() {
        return "ArtAndChildArtTypes [allow=" + (Object)((Object)this.allowDeny) + ", art=" + this.artifact + ", childArtTypes=" + this.childArtTypes + "]";
    }

    @Override
    public AccessTypeMatch computeMatch(ArtifactToken otherArt, AttributeTypeToken attrType, RelationTypeToken relType, IParentProvider parentProvider) {
        boolean match = false;
        boolean computed = false;
        if (otherArt.equals(this.artifact)) {
            computed = true;
            match = true;
        } else {
            for (ArtifactTypeToken childArtType : this.childArtTypes) {
                if (!this.artifact.getArtifactType().inheritsFrom(childArtType) || !ArtifactAndChildrenArtifactTypesAccessType.checkIfDecendentOf(otherArt, this.artifact, parentProvider)) continue;
                computed = true;
                match = true;
                break;
            }
        }
        if (computed && match) {
            if (this.allowDeny == AllowDeny.Allow) {
                return AccessTypeMatch.Allow;
            }
            if (this.allowDeny == AllowDeny.Deny) {
                return AccessTypeMatch.Deny;
            }
        }
        return AccessTypeMatch.NotComputed;
    }

    protected static boolean checkIfDecendentOf(ArtifactToken decendent, ArtifactToken artToMatch, IParentProvider parentProvider) {
        if (decendent.equals(artToMatch)) {
            return true;
        }
        ArtifactToken parent = parentProvider.getParent(decendent);
        if (parent != null && parent.isValid()) {
            return ArtifactAndChildrenArtifactTypesAccessType.checkIfDecendentOf(parent, artToMatch, parentProvider);
        }
        return false;
    }
}

