/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.access.context.AccessType;
import org.eclipse.osee.framework.core.access.context.AllowDeny;
import org.eclipse.osee.framework.core.access.context.ArtifactAndChildrenArtifactTypesAccessType;
import org.eclipse.osee.framework.core.access.context.ArtifactAndChildrenRelationTypesAccessType;
import org.eclipse.osee.framework.core.access.context.ArtifactTypeAccessType;
import org.eclipse.osee.framework.core.access.context.AttributeTypeAccessType;
import org.eclipse.osee.framework.core.access.context.RelationTypeAccessType;
import org.eclipse.osee.framework.core.data.AccessContextToken;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.token.QualificationMethodAttributeType;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class AccessContext
extends NamedIdBase {
    private String guid;
    private List<AccessType> typeAccess = new ArrayList<AccessType>();
    private final AccessContextToken accessToken;
    private static final Map<AccessContextToken, AccessContext> accessContexts = new HashMap<AccessContextToken, AccessContext>();

    public AccessContext(AccessContextToken accessToken) {
        super(accessToken.getId(), accessToken.getName());
        this.accessToken = accessToken;
        accessContexts.put(accessToken, this);
    }

    public static AccessContext getAccessContext(AccessContextToken accessToken) {
        return accessContexts.get(accessToken);
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public List<AccessType> getTypeAccess() {
        return this.typeAccess;
    }

    public void setTypeAccess(List<AccessType> typeAccess) {
        this.typeAccess = typeAccess;
    }

    public void allowEditArtifactType(ArtifactTypeToken ... artifactTypes) {
        ArtifactTypeToken[] artifactTypeTokenArray = artifactTypes;
        int n = artifactTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeToken artType = artifactTypeTokenArray[n2];
            this.typeAccess.add(new ArtifactTypeAccessType(AllowDeny.Allow, artType));
            ++n2;
        }
    }

    public void denyEditArtifactType(ArtifactTypeToken ... artifactTypes) {
        ArtifactTypeToken[] artifactTypeTokenArray = artifactTypes;
        int n = artifactTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeToken artType = artifactTypeTokenArray[n2];
            this.typeAccess.add(new ArtifactTypeAccessType(AllowDeny.Deny, artType));
            ++n2;
        }
    }

    public void denyEditArtifactAndChildrenArtifactTypes(ArtifactToken artifact, ArtifactTypeToken ... childArtTypes) {
        this.typeAccess.add(new ArtifactAndChildrenArtifactTypesAccessType(AllowDeny.Deny, artifact, Collections.asHashSet((Object[])childArtTypes)));
    }

    public void allowEditArtifactAndChildrenArtifactTypes(ArtifactToken artifact, ArtifactTypeToken ... childArtTypes) {
        this.typeAccess.add(new ArtifactAndChildrenArtifactTypesAccessType(AllowDeny.Allow, artifact, Collections.asHashSet((Object[])childArtTypes)));
    }

    public void denyEditArtifactAndChildrenRelationTypes(ArtifactToken artifact, RelationTypeToken relationType, ArtifactTypeToken artAandBType) {
        this.typeAccess.add(new ArtifactAndChildrenRelationTypesAccessType(AllowDeny.Deny, artifact, relationType, artAandBType));
    }

    public void allowEditArtifactAndChildrenRelationTypes(ArtifactToken artifact, RelationTypeToken relationType, ArtifactTypeToken artAandBType) {
        this.typeAccess.add(new ArtifactAndChildrenRelationTypesAccessType(AllowDeny.Allow, artifact, relationType, artAandBType));
    }

    public void allowEditRelationType(RelationTypeToken relationType) {
        this.typeAccess.add(new RelationTypeAccessType(AllowDeny.Allow, relationType, CoreArtifactTypes.Artifact));
    }

    public void allowEditRelationTypeOfArtifactType(RelationTypeToken relationType, ArtifactTypeToken artifactType) {
        this.typeAccess.add(new RelationTypeAccessType(AllowDeny.Allow, relationType, artifactType));
    }

    public void allowEditAttributeTypeOfArtifactType(QualificationMethodAttributeType attributeType, ArtifactTypeToken artifactType) {
        this.typeAccess.add(new AttributeTypeAccessType(AllowDeny.Allow, attributeType, artifactType));
    }

    public void allowEditArtifactAndChildrenRelationTypes(ArtifactToken artifact, RelationTypeToken relationType) {
        this.typeAccess.add(new ArtifactAndChildrenRelationTypesAccessType(AllowDeny.Allow, artifact, relationType, CoreArtifactTypes.Artifact));
    }

    public AccessContextToken getAccessToken() {
        return this.accessToken;
    }
}

