/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.session;

import java.util.Collections;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.security.JaxRsSessionProvider;
import org.eclipse.osee.jaxrs.server.session.AuthenticitySessionStorage;
import org.eclipse.osee.jaxrs.server.session.AuthenticityToken;
import org.eclipse.osee.jaxrs.server.session.SessionData;
import org.eclipse.osee.jaxrs.server.session.SessionStorage;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;

public class JaxRsSessionProviderImpl
implements JaxRsSessionProvider {
    private AuthenticitySessionStorage authenticitySessionStorage;
    private SessionStorage sessionStorage;
    private Log logger;
    private JdbcClient jdbcClient;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJdbcService(JdbcService jdbcService) {
        JdbcClient jdbcClient;
        this.jdbcClient = jdbcClient = jdbcService.getClient();
    }

    public void start() {
        this.authenticitySessionStorage = new AuthenticitySessionStorage(this.logger, this.jdbcClient);
        this.sessionStorage = new SessionStorage(this.logger, this.jdbcClient);
    }

    @Override
    public String createAuthenticitySessionToken(Long subjectId) {
        String token = this.getSessionAuthenticityToken(subjectId);
        if (Strings.isValid((String)token)) {
            this.authenticitySessionStorage.removeAuthenticitySessionTokens(Collections.singletonList(this.authenticitySessionStorage.getSession(subjectId)));
        }
        AuthenticityToken authenticityToken = new AuthenticityToken();
        token = UUID.randomUUID().toString();
        authenticityToken.setSubjectId(subjectId);
        authenticityToken.setToken(token);
        this.authenticitySessionStorage.insertAuthenticityTokens(authenticityToken);
        return token;
    }

    @Override
    public String removeSessionAuthenticityToken(Long subjectId) {
        String toReturn = "";
        AuthenticityToken authenticityToken = this.authenticitySessionStorage.getSession(subjectId);
        if (authenticityToken != null) {
            this.authenticitySessionStorage.removeAuthenticitySessionTokens(Collections.singletonList(authenticityToken));
            toReturn = authenticityToken.getToken();
        }
        return toReturn;
    }

    @Override
    public String getSessionAuthenticityToken(Long subjectId) {
        AuthenticityToken authenticityToken = this.authenticitySessionStorage.getSession(subjectId);
        return authenticityToken == null ? "" : authenticityToken.getToken();
    }

    @Override
    public OseePrincipal getSubjectById(Long subjectId) {
        return null;
    }

    @Override
    public HttpSession getSession() {
        return null;
    }

    @Override
    public void storeSession(SessionData session) {
        this.sessionStorage.insertSessions(session);
    }

    @Override
    public SessionData getSession(String sessionId) {
        return this.sessionStorage.getSession(sessionId);
    }

    @Override
    public SessionData removeSession(String sessionId) {
        SessionData session = this.sessionStorage.getSession(sessionId);
        if (session != null) {
            this.sessionStorage.deleteSessioin(Collections.singletonList(session));
        }
        return session;
    }
}

