/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal;

import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.jaxrs.server.internal.JaxRsDynamicServiceManager;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsApplicationRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public final class JaxRsProvidersManager
extends JaxRsDynamicServiceManager<Object> {
    @Override
    public void register(JaxRsApplicationRegistry registry, ServiceReference<Object> reference) {
        String componentName = JaxRsUtils.getComponentName(reference);
        Bundle bundle = reference.getBundle();
        Object provider = bundle.getBundleContext().getService(reference);
        if (this.isJaxRsProvider(provider)) {
            registry.registerProvider(componentName, bundle, provider);
        }
    }

    @Override
    public void deregister(JaxRsApplicationRegistry registry, ServiceReference<Object> reference) {
        String componentName = JaxRsUtils.getComponentName(reference);
        registry.deregisterProvider(componentName);
    }

    private boolean isJaxRsProvider(Object service) {
        return service != null && (this.hasRegisterableAnnotation(service) || service instanceof Feature || service instanceof DynamicFeature);
    }

    private boolean hasRegisterableAnnotation(Object service) {
        boolean result = this.hasJaxRsAnnotation(service.getClass());
        if (!result) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = service.getClass().getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                result = result || this.hasJaxRsAnnotation(type);
                ++n2;
            }
        }
        return result;
    }

    private boolean hasJaxRsAnnotation(Class<?> type) {
        return type.isAnnotationPresent(Provider.class);
    }
}

