/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal;

import java.util.Map;
import javax.ws.rs.core.Application;
import org.eclipse.osee.jaxrs.server.internal.JaxRsConfiguration;
import org.eclipse.osee.jaxrs.server.internal.JaxRsDynamicServiceManager;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsApplicationRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public final class JaxRsApplicationManager
extends JaxRsDynamicServiceManager<Application> {
    private JaxRsConfiguration config;

    @Override
    public void update(Map<String, Object> props) {
        super.update(props);
        this.config = JaxRsConfiguration.fromProperties(props).build();
        JaxRsApplicationRegistry registry = this.getRegistry();
        if (registry != null) {
            registry.configure(this.config);
        }
    }

    @Override
    public void register(JaxRsApplicationRegistry registry, ServiceReference<Application> reference) {
        String componentName = JaxRsUtils.getComponentName(reference);
        Bundle bundle = reference.getBundle();
        Application application = (Application)bundle.getBundleContext().getService(reference);
        registry.register(componentName, bundle, application);
    }

    @Override
    public void deregister(JaxRsApplicationRegistry registry, ServiceReference<Application> reference) {
        String componentName = JaxRsUtils.getComponentName(reference);
        registry.deregister(componentName);
    }
}

