/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide.api.client.model;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;

@XmlRootElement
public class ClientInfo {
    private static Pattern namePattern = Pattern.compile("Name: \\[(.*)\\]");
    private static Pattern versionPattern = Pattern.compile("Version:\\[(.*)\\]");
    private static Pattern buildTypePattern = Pattern.compile("BuildType:\\[(.*)\\]");
    private static Pattern userIdPattern = Pattern.compile("User Id:\\[(.*)\\]");
    private static Pattern installationPattern = Pattern.compile("Installation Location: \\[(.*)\\]");
    private String infoStr;
    private boolean alive;
    private final Date date;

    public ClientInfo() {
        this("");
    }

    public ClientInfo(String infoStr) {
        this.infoStr = infoStr;
        this.date = new Date();
    }

    public String getName() {
        return this.getValue(namePattern);
    }

    public String getVersion() {
        return this.getValue(versionPattern);
    }

    public String getUserId() {
        return this.getValue(userIdPattern);
    }

    public String getBuildType() {
        return this.getValue(buildTypePattern);
    }

    public String getInstallation() {
        return this.getValue(installationPattern);
    }

    public String getDate() {
        return DateUtil.get((Date)this.date, (String)"MM/dd/yyyy hh:mm a");
    }

    public String getValue(Pattern pattern) {
        String name = "unknown";
        Matcher m = pattern.matcher(this.infoStr);
        if (m.find()) {
            name = m.group(1);
        }
        return name;
    }

    public String toString() {
        return "ClientInfo [info=" + this.infoStr + ", getName()=" + this.getName() + ", getVersion()=" + this.getVersion() + ", getUserId()=" + this.getUserId() + ", getBuildType()=" + this.getBuildType() + ", getInstallationPattern()=" + this.getInstallation() + "]";
    }

    public void setInfoStr(String infoStr) {
        this.infoStr = infoStr;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public String getInfoStr() {
        return this.infoStr;
    }
}

