/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal;

import java.security.PrivilegedActionException;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.eclipse.osee.authentication.ldap.LdapAuthenticationType;
import org.eclipse.osee.authentication.ldap.LdapReferralHandlingType;
import org.eclipse.osee.authentication.ldap.internal.ContextConfigProvider;
import org.eclipse.osee.authentication.ldap.internal.LdapConnection;
import org.eclipse.osee.authentication.ldap.internal.util.IgnoreCertValidationSSLSocketFactory;
import org.eclipse.osee.authentication.ldap.internal.util.LdapUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class LdapClient
implements ContextConfigProvider {
    private static final String LDAP_SSL_SCHEME = "ldaps:";
    private static final String LDAP_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String CONTEXT__LDAP_FACTORY_SOCKET = "java.naming.ldap.factory.socket";
    private static final String CONTEXT__LDAP_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private final LdapConnectionFactory connectionFactory;
    private String serverAddress;
    private long readTimeoutInMillis;
    private boolean isSslVerifyEnabled;
    private LdapReferralHandlingType referral;

    public LdapClient(LdapConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public long getReadTimeoutInMillis() {
        return this.readTimeoutInMillis;
    }

    public void setReadTimeoutInMillis(long readTimeoutInMillis) {
        this.readTimeoutInMillis = readTimeoutInMillis;
    }

    public boolean isSslVerifyEnabled() {
        return this.isSslVerifyEnabled;
    }

    public void setSslVerifyEnabled(boolean isSslVerifyEnabled) {
        this.isSslVerifyEnabled = isSslVerifyEnabled;
    }

    public LdapReferralHandlingType getReferralHandling() {
        return this.referral;
    }

    public void setReferralHandling(LdapReferralHandlingType referral) {
        this.referral = referral;
    }

    public boolean isSslScheme() {
        return Strings.isValid((String)this.serverAddress) && this.serverAddress.startsWith(LDAP_SSL_SCHEME);
    }

    @Override
    public Hashtable<String, String> getContextConfig() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", LDAP_INITIAL_CONTEXT_FACTORY);
        props.put("java.naming.provider.url", this.getServerAddress());
        props.put("java.naming.referral", this.getReferralHandling().getContextReferralName());
        long timeout = this.getReadTimeoutInMillis();
        if (timeout >= 0L) {
            props.put(CONTEXT__LDAP_READ_TIMEOUT, Long.toString(timeout));
        }
        if (this.isSslScheme() && !this.isSslVerifyEnabled()) {
            Class<IgnoreCertValidationSSLSocketFactory> factory = IgnoreCertValidationSSLSocketFactory.class;
            props.put(CONTEXT__LDAP_FACTORY_SOCKET, factory.getName());
        }
        return props;
    }

    public LdapConnection getConnection(LdapAuthenticationType authType, String username, String password) throws NamingException, LoginException, PrivilegedActionException {
        Hashtable<String, String> env = this.getContextConfig();
        env.put("java.naming.security.authentication", authType.getContextAuthenticationName());
        if (LdapAuthenticationType.GSSAPI != authType) {
            env.put("java.naming.security.principal", LdapUtil.getValue(username, ""));
            env.put("java.naming.security.credentials", LdapUtil.getValue(password, ""));
        }
        return this.connectionFactory.createConnection(this, authType, env);
    }

    public static interface LdapConnectionFactory {
        public LdapConnection createConnection(ContextConfigProvider var1, LdapAuthenticationType var2, Hashtable<String, String> var3) throws NamingException, LoginException, PrivilegedActionException;
    }
}

