/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.operations;

import java.rmi.activation.Activator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.task.create.TasksFromAction;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsConstants;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsChangeSetListener;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.logging.OseeLog;

public class CreateTasksFromActionsOperation {
    private final TasksFromAction tfa;
    private final AtsApi atsApi;
    private IAtsWorkItem destTeamWf;
    private List<IAtsTeamWorkflow> sourceTeamWfs;

    public CreateTasksFromActionsOperation(TasksFromAction tfa, AtsApi atsApi) {
        this.tfa = tfa;
        this.atsApi = atsApi;
    }

    public TasksFromAction run() {
        this.validate();
        if (this.tfa.getRd().isErrors()) {
            return this.tfa;
        }
        this.create();
        return this.tfa;
    }

    private void create() {
        Date date = new Date();
        NewTaskSet taskSet = new NewTaskSet();
        AtsUser createdBy = this.atsApi.getUserService().getUserById(this.tfa.getCreatedBy());
        taskSet.setAsUserId(createdBy.getUserId());
        taskSet.setCommitComment(AtsConstants.CreateTasksFromActions.name());
        taskSet.setResults(this.tfa.getRd());
        NewTaskData taskData = new NewTaskData();
        taskSet.add(taskData);
        taskData.setTeamWfId(this.tfa.getDestTeamWf().getId());
        for (IAtsTeamWorkflow srcWf : this.sourceTeamWfs) {
            JaxAtsTask jTask = new JaxAtsTask();
            taskData.add(jTask);
            jTask.setName(srcWf.getName());
            jTask.setCreatedByUserId(createdBy.getUserId());
            jTask.setCreatedDate(date);
            jTask.setDescription("See Related Team Workflow");
            jTask.addRelation(CoreRelationTypes.SupportingInfo_SupportingInfo, new long[]{srcWf.getId()});
            jTask.addRelation(AtsRelationTypes.Derive_From, new long[]{srcWf.getId()});
        }
        taskSet = this.atsApi.getTaskService().createTasks(taskSet, (IAtsChangeSetListener)new CreateTasksChangeSetListener(this.tfa));
        if (taskSet.getTransaction().isValid()) {
            this.tfa.getRd().log("Success.  Created tasks and cancelled workflows");
            this.tfa.getRd().setTxId(taskSet.getTransaction().getIdString());
        }
    }

    public void validate() {
        this.destTeamWf = this.atsApi.getWorkItemService().getWorkItem(this.tfa.getDestTeamWf().getId());
        if (this.destTeamWf == null) {
            this.tfa.getRd().errorf("Destination Workflow [%s] does not exist", new Object[]{this.tfa.getDestTeamWf()});
            return;
        }
        if (!this.destTeamWf.isTeamWorkflow()) {
            this.tfa.getRd().errorf("Destination Workflow Item %s is not a Team Workflow", new Object[]{this.destTeamWf.toStringWithAtsId()});
            return;
        }
        if (this.destTeamWf.isCompletedOrCancelled()) {
            this.tfa.getRd().errorf("Destination Team Workflow in [%s] state: %s", new Object[]{this.destTeamWf.getCurrentStateType(), this.destTeamWf.toStringWithAtsId()});
            return;
        }
        this.tfa.getRd().logf("Destination Team Workflow: %s\n", new Object[]{this.destTeamWf.toStringWithAtsId()});
        this.sourceTeamWfs = new ArrayList<IAtsTeamWorkflow>();
        for (ArtifactToken sourceId : this.tfa.getSourceTeamWfs()) {
            ArtifactToken sourceArt = this.atsApi.getQueryService().getArtifact(sourceId.getId());
            IAtsWorkItem sourceWf = this.atsApi.getWorkItemService().getWorkItem(sourceArt);
            if (sourceWf == null) {
                this.tfa.getRd().errorf("Selected Team Workflow %s does not exist", new Object[]{sourceId});
                return;
            }
            if (!this.destTeamWf.isTeamWorkflow()) {
                this.tfa.getRd().errorf("Selected Workflow Item %s is not a Team Workflow", new Object[]{sourceWf.toStringWithAtsId()});
                return;
            }
            IAtsTeamWorkflow sourceTeamWf = (IAtsTeamWorkflow)sourceWf;
            if (this.destTeamWf.isCompletedOrCancelled()) {
                this.tfa.getRd().errorf("Selected Team Workflow in %s state: %s", new Object[]{sourceWf.getCurrentStateType(), this.destTeamWf.toStringWithAtsId()});
                return;
            }
            this.tfa.getRd().logf("Source Team Workflow: %s\n", new Object[]{sourceTeamWf.toStringWithAtsId()});
            this.sourceTeamWfs.add(sourceTeamWf);
        }
    }

    private class CreateTasksChangeSetListener
    implements IAtsChangeSetListener {
        private final TasksFromAction tfa;

        public CreateTasksChangeSetListener(TasksFromAction tfa) {
            this.tfa = tfa;
        }

        public void changesStored(IAtsChangeSet changes) {
            try {
                ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
                for (ArtifactToken sourceTeamWf : this.tfa.getSourceTeamWfs()) {
                    IAtsWorkItem workItem = CreateTasksFromActionsOperation.this.atsApi.getWorkItemService().getWorkItem(sourceTeamWf.getId());
                    workItems.add(workItem);
                }
                TransitionData tData = new TransitionData(AtsConstants.CreateTasksFromActions.name(), workItems, TeamState.Cancelled.getName(), Collections.emptyList(), this.tfa.getReason(), changes, new TransitionOption[]{TransitionOption.None});
                tData.setExecute(false);
                TransitionResults results = CreateTasksFromActionsOperation.this.atsApi.getWorkItemService().transition(tData);
                if (!results.isSuccess() || results.isErrors()) {
                    this.tfa.getRd().errorf(results.toString(), new Object[0]);
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"Error in NotifyFunctionalArea", (Throwable)ex);
            }
        }
    }
}

