/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.journal;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.journal.JournalData;
import org.eclipse.osee.ats.rest.internal.workitem.journal.JournalKey;
import org.eclipse.osee.framework.core.util.OseeInf;

public class JournalWebOperations {
    private final IAtsWorkItem workItem;
    private final AtsApi atsApi;
    private String page;
    private final AtsUser user;

    public JournalWebOperations(IAtsWorkItem workItem, AtsUser user, AtsApi atsApi) {
        this.workItem = workItem;
        this.user = user;
        this.atsApi = atsApi;
    }

    public String getHtml() {
        this.page = OseeInf.getResourceContents((String)"templates/journal/journal.html", JournalWebOperations.class);
        JournalData jData = this.atsApi.getWorkItemService().getJournalData(this.workItem, new JournalData());
        String comments = jData.getResults().isErrors() ? jData.getResults().toString() : jData.getCurrentMsg();
        this.page = this.page.replaceFirst(JournalKey.PUT_COMMENTS_HERE.name(), comments);
        String url = String.format("<b><a target=\"_blank\" href=\"/ats/ui/action/%s\">View Action Details</a></b><br/><br/>", this.workItem.getAtsId());
        this.page = this.page.replaceFirst(JournalKey.PUT_ACTION_DETAILS_HERE.name(), url);
        this.handlePage();
        this.handleForm();
        return this.page;
    }

    private void handleForm() {
        String form = OseeInf.getResourceContents((String)"templates/journal/journalForm.html", JournalWebOperations.class);
        this.page = this.page.replaceFirst(JournalKey.PUT_FORM_HERE.name(), form);
        this.page = this.page.replaceAll(JournalKey.PUT_ATS_ID_HERE.name(), this.workItem.getAtsId());
        this.page = this.page.replaceFirst(JournalKey.PUT_USER_NAME_HERE.name(), this.user.getName());
        this.page = this.page.replaceFirst(JournalKey.PUT_USER_AID_HERE.name(), this.user.getIdString());
    }

    private void handlePage() {
        this.page = this.page.replaceFirst(JournalKey.PUT_TITLE_HERE.name(), String.format("\"%s\" - %s - \"%s\"", this.workItem.getArtifactType().getName(), this.workItem.getAtsId(), this.workItem.getName()));
    }
}

