/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.util.AbstractAtsAttributeResolverServiceImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public class AtsAttributeResolverServiceImpl
extends AbstractAtsAttributeResolverServiceImpl {
    public AtsAttributeResolverServiceImpl(AtsApi atsApi) {
        super(atsApi);
    }

    private ArtifactReadable getArtifact(IAtsObject atsObject) {
        return (ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject);
    }

    private ArtifactReadable getArtifact(ArtifactId artifact) {
        return (ArtifactReadable)this.atsApi.getQueryService().getArtifact(artifact);
    }

    public <T> T getSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, T defaultReturnValue) {
        return (T)this.getArtifact(atsObject).getSoleAttributeValue(attributeType, defaultReturnValue);
    }

    public List<String> getAttributesToStringList(IAtsObject atsObject, AttributeTypeToken attributeType) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object obj : this.getArtifact(atsObject).getAttributeValues(attributeType)) {
            values.add(obj.toString());
        }
        return values;
    }

    public boolean isAttributeTypeValid(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        return this.getArtifact((IAtsObject)workItem).isAttributeTypeValid((AttributeTypeId)attributeType);
    }

    public String getSoleAttributeValueAsString(IAtsObject atsObject, AttributeTypeToken attributeType, String defaultValue) {
        return this.getArtifact(atsObject).getAttributeValuesAsString(attributeType);
    }

    public String getSoleAttributeValueAsString(ArtifactId artifact, AttributeTypeToken attributeType, String defaultValue) {
        return (String)this.getArtifact(artifact).getSoleAttributeValue(attributeType, (Object)defaultValue);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeId attributeType, Object value) {
        throw new OseeStateException("Invalid: Must use setSoleAttributeValue(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value, IAtsChangeSet changes)", new Object[0]);
    }

    public int getAttributeCount(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        return this.getArtifact((IAtsObject)workItem).getAttributeCount(attributeType);
    }

    public int getAttributeCount(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.getArtifact(atsObject).getAttributeCount(attributeType);
    }

    public int getAttributeCount(ArtifactId artifact, AttributeTypeToken attributeType) {
        return this.getArtifact(artifact).getAttributeCount(attributeType);
    }

    public void addAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value) {
        throw new OseeStateException("Not Implemented", new Object[0]);
    }

    public <T> Collection<IAttribute<T>> getAttributes(IAtsObject atsObject, AttributeTypeToken attributeType) {
        ArrayList<IAttribute<T>> attrs = new ArrayList<IAttribute<T>>();
        for (AttributeReadable attr : this.getArtifact(atsObject).getAttributes(attributeType)) {
            attrs.add((IAttribute<T>)attr);
        }
        return attrs;
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType) {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType, IAtsChangeSet changes) {
        changes.deleteSoleAttribute(workItem, attributeType);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, Object value, IAtsChangeSet changes) {
        changes.setSoleAttributeValue(atsObject, attributeType, value);
    }

    public void addAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType, Object value, IAtsChangeSet changes) {
        changes.addAttribute((IAtsObject)workItem, attributeType, value);
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType, Object value, IAtsChangeSet changes) {
        changes.deleteAttribute((IAtsObject)workItem, attributeType, value);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<T> attr, AttributeTypeId attributeType, T value, IAtsChangeSet changes) {
        changes.setValue(workItem, attr, attributeType, value);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr, IAtsChangeSet changes) {
        changes.deleteAttribute(workItem, attr);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr) {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<String> attr, AttributeTypeId attributeType, T value) {
        throw new OseeStateException("Invalid: Must use deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, IAtsChangeSet changes)", new Object[0]);
    }

    public <T> T getSoleAttributeValue(ArtifactId artifact, AttributeTypeToken attributeType, T defaultValue) {
        return (T)this.getArtifact(artifact).getSoleAttributeValue(attributeType, defaultValue);
    }

    public <T> Collection<T> getAttributeValues(ArtifactId artifact, AttributeTypeToken attributeType) {
        return this.getArtifact(artifact).getAttributeValues(attributeType);
    }

    public <T> Collection<T> getAttributeValues(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.getAttributeValues((ArtifactId)atsObject.getStoreObject(), attributeType);
    }

    public <T> Collection<IAttribute<T>> getAttributes(ArtifactId artifact, AttributeTypeToken attributeType) {
        Assert.isNotNull((Object)artifact, (String)"Artifact can not be null");
        Assert.isNotNull((Object)attributeType, (String)"Attribute Type can not be null");
        LinkedList<IAttribute<T>> attributes = new LinkedList<IAttribute<T>>();
        for (AttributeReadable attr : ((ArtifactReadable)artifact).getAttributes(attributeType)) {
            attributes.add((IAttribute<T>)attr);
        }
        return attributes;
    }

    public List<String> getAttributesToStringList(ArtifactId artifact, AttributeTypeToken attributeType) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object value : ((ArtifactReadable)artifact).getAttributeValues(attributeType)) {
            values.add(value.toString());
        }
        return values;
    }

    public <T> Collection<IAttribute<T>> getAttributes(ArtifactId artifact) {
        LinkedList<IAttribute<T>> attributes = new LinkedList<IAttribute<T>>();
        for (AttributeReadable attr : this.getArtifact(artifact).getAttributes()) {
            attributes.add((IAttribute<T>)attr);
        }
        return attributes;
    }

    public <T> Collection<IAttribute<T>> getAttributes(IAtsWorkItem workItem) {
        return this.getAttributes((ArtifactId)workItem.getStoreObject());
    }

    public List<String> getAttributesToStringListFromArt(ArtifactToken artifact, AttributeTypeToken attributeType) {
        return ((ArtifactReadable)artifact).getAttributeValues(attributeType);
    }

    public List<String> getAttributesToStringListFromArt(ArtifactToken artifact, AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        return ((ArtifactReadable)artifact).getAttributeValues(attributeType, deletionFlag);
    }
}

