/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.review;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Path;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.AtsReviewEndpointApi;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;

@Path(value="review")
public class AtsReviewEndpointImpl
implements AtsReviewEndpointApi {
    private final AtsApi atsApi;

    public AtsReviewEndpointImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public IAtsAbstractReview getReview(String id) {
        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItemByAnyId(id);
        if (workItem == null || !workItem.isReview()) {
            throw new UnsupportedOperationException();
        }
        return (IAtsAbstractReview)workItem;
    }

    public Collection<IAtsAbstractReview> getReviews(String ids) {
        List workItems = this.atsApi.getQueryService().getWorkItemsByIds(ids);
        ArrayList<IAtsAbstractReview> reviews = new ArrayList<IAtsAbstractReview>();
        workItems.stream().filter(w -> w.isReview()).forEach(r -> {
            boolean bl = reviews.add((IAtsAbstractReview)r);
        });
        return reviews;
    }
}

