/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.notify;

import org.eclipse.osee.ats.rest.internal.notify.ServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class ExportClassLoader
extends ClassLoader {
    private static ExportClassLoader exportClassloaderInstance;
    private final PackageAdmin packageAdmin;

    public static ExportClassLoader getInstance() {
        if (exportClassloaderInstance == null) {
            exportClassloaderInstance = new ExportClassLoader();
        }
        return exportClassloaderInstance;
    }

    public ExportClassLoader(PackageAdmin packageAdmin) {
        super(ExportClassLoader.class.getClassLoader());
        this.packageAdmin = packageAdmin;
    }

    public ExportClassLoader() {
        this(ServiceUtil.getPackageAdmin());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Bundle bundle = this.getExportingBundle(name);
            if (bundle != null) {
                return bundle.loadClass(name);
            }
            throw new ClassNotFoundException("could not locate a class for " + name);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("could not locate a class for " + name, e);
        }
    }

    public Bundle getExportingBundle(String name) {
        String pkg = name.substring(0, name.lastIndexOf(46));
        ExportedPackage[] list = this.packageAdmin.getExportedPackages(pkg);
        if (list != null) {
            ExportedPackage[] exportedPackageArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                ExportedPackage ep = exportedPackageArray[n2];
                Bundle bundle = ep.getExportingBundle();
                int state = bundle.getState();
                if (state == 4 || state == 8 || state == 32 || state == 16) {
                    return bundle;
                }
                ++n2;
            }
        }
        return null;
    }
}

