/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.notify;

import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotifyEndpointApi;
import org.eclipse.osee.ats.api.notify.TestEmail;
import org.eclipse.osee.ats.rest.internal.notify.AtsNotificationServiceImpl;
import org.eclipse.osee.ats.rest.internal.notify.OseeEmailServer;
import org.eclipse.osee.framework.core.util.OseeEmail;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class AtsNotifyEndpointImpl
implements AtsNotifyEndpointApi {
    private final AtsApi atsApi;

    public AtsNotifyEndpointImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public Response sendNotifications(AtsNotificationCollector notifications) {
        System.err.println(String.format("server: [%s] - [%s]", AtsNotificationServiceImpl.class.getSimpleName(), notifications));
        this.atsApi.getNotificationService().sendNotifications(notifications);
        return Response.ok().build();
    }

    public XResultData sendTestEmail(TestEmail testEmail) {
        XResultData rd = new XResultData();
        rd.log("Send Test Email - Server");
        try {
            OseeEmailServer emailMessage = OseeEmailServer.create(Arrays.asList(testEmail.getEmail()), testEmail.getEmail(), testEmail.getEmail(), testEmail.getSubject(), AHTML.simplePage((String)AHTML.bold((String)"Hello World - this should be bold")), OseeEmail.BodyType.Html, Arrays.asList(testEmail.getEmail()), "Abridged - " + testEmail.getSubject());
            emailMessage.send(rd);
        }
        catch (Exception ex) {
            rd.error(Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }
}

