/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoCscis;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.core.demo.DemoUtil;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.rest.internal.demo.AbstractPopulateDemoDatabase;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public class Pdd22CreateUnCommittedConflictedAction
extends AbstractPopulateDemoDatabase {
    private ActionResult actionResult;

    public Pdd22CreateUnCommittedConflictedAction(XResultData rd, AtsApi atsApi) {
        super(rd, atsApi);
    }

    @Override
    public void run() {
        this.rd.logf("Running [%s]...\n", new Object[]{this.getClass().getSimpleName()});
        Collection aias = DemoUtil.getActionableItems((ArtifactToken[])new ArtifactToken[]{DemoArtifactToken.SAW_Requirements_AI});
        Date createdDate = new Date();
        AtsUser createdBy = this.atsApi.getUserService().getCurrentUser();
        String priority = "3";
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getClass().getName());
        this.actionResult = this.atsApi.getActionService().createAction(null, DemoArtifactToken.SAW_UnCommitedConflicted_Req_TeamWf.getName(), "Problem with the Diagram View", ChangeTypes.Problem, priority, false, null, aias, createdDate, createdBy, Arrays.asList(new ArtifactTokenActionListener()), changes);
        changes.execute();
        IAtsTeamWorkflow reqTeamWf = null;
        for (IAtsTeamWorkflow teamWf : this.actionResult.getTeamWfs()) {
            changes = this.atsApi.createChangeSet(String.valueOf(this.getClass().getName()) + " - 2");
            this.transitionToWithPersist(teamWf, TeamState.Implement, (AtsUser)teamWf.getAssignees().iterator().next(), teamWf.getAssignees(), this.atsApi);
            teamWf = this.setVersionAndReload(teamWf, (ArtifactToken)DemoArtifactToken.SAW_Bld_2);
            if (!teamWf.getTeamDefinition().getName().contains("Requirements")) continue;
            reqTeamWf = teamWf;
        }
        if (reqTeamWf == null) {
            throw new OseeArgumentException("Can't locate Req team.", new Object[0]);
        }
        Result result = this.atsApi.getBranchService().createWorkingBranchValidate(reqTeamWf);
        if (result.isFalse()) {
            throw new OseeArgumentException("Error creating working branch: " + result.getText(), new Object[0]);
        }
        BranchData bData = this.atsApi.getBranchService().createWorkingBranch(reqTeamWf);
        if (bData.getResults().isErrors()) {
            throw new OseeStateException("Error creating working branch %s\n", new Object[]{bData.getResults().toString()});
        }
        if (bData.getNewBranch().isInvalid()) {
            throw new OseeStateException("New Branch is invalid\n", new Object[0]);
        }
        BranchToken workingBranch = this.atsApi.getBranchService().getBranch(bData.getNewBranch());
        changes = this.atsApi.createChangeSet(this.getClass().getName(), workingBranch);
        ArtifactToken branchArtifact = (ArtifactToken)DemoUtil.getArtTypeRequirements((boolean)this.isDebug(), (ArtifactTypeToken)CoreArtifactTypes.SoftwareRequirementMsWord, (String)DemoUtil.HAPTIC_CONSTRAINTS_REQ, (BranchToken)workingBranch).iterator().next();
        changes.setSoleAttributeValue((ArtifactId)branchArtifact, (AttributeTypeToken)CoreAttributeTypes.CSCI, (Object)DemoCscis.Interface.name());
        changes.setSoleAttributeValue((ArtifactId)branchArtifact, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
        ArtifactToken comArt = this.atsApi.getQueryService().getArtifactFromName(CoreArtifactTypes.Component, DemoSubsystems.Robot_API.name(), workingBranch);
        changes.relate((ArtifactId)branchArtifact, CoreRelationTypes.Allocation_Component, (ArtifactId)comArt);
        ArtifactToken parentArtifact = (ArtifactToken)DemoUtil.getArtTypeRequirements((boolean)this.isDebug(), (ArtifactTypeToken)CoreArtifactTypes.SoftwareRequirementMsWord, (String)DemoUtil.HAPTIC_CONSTRAINTS_REQ, (BranchToken)workingBranch).iterator().next();
        changes.setSoleAttributeValue((ArtifactId)parentArtifact, (AttributeTypeToken)CoreAttributeTypes.CSCI, (Object)DemoCscis.Navigation.name());
        changes.setSoleAttributeValue((ArtifactId)parentArtifact, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Cognitive_Decision_Aiding.name());
        changes.execute();
    }

    private class ArtifactTokenActionListener
    implements INewActionListener {
        private ArtifactTokenActionListener() {
        }

        public ArtifactToken getArtifactToken(List<IAtsActionableItem> applicableAis) {
            return DemoArtifactToken.SAW_UnCommitedConflicted_Req_TeamWf;
        }
    }
}

