/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoCscis;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.demo.DemoUtil;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TeamWorkFlowManager;
import org.eclipse.osee.ats.rest.internal.demo.AbstractPopulateDemoDatabase;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class Pdd21CreateUnCommittedAction
extends AbstractPopulateDemoDatabase {
    private ActionResult actionResult;

    public Pdd21CreateUnCommittedAction(XResultData rd, AtsApi atsApi) {
        super(rd, atsApi);
    }

    public TeamWorkFlowManager getTeamWfMgr(IAtsTeamWorkflow teamWf) {
        return new TeamWorkFlowManager(teamWf, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck, TransitionOption.OverrideWorkingBranchCheck});
    }

    @Override
    public void run() {
        this.rd.logf("Running [%s]...\n", new Object[]{this.getClass().getSimpleName()});
        String title = "SAW (uncommitted) More Reqt Changes for Diagram View";
        Collection aias = DemoUtil.getActionableItems((ArtifactToken[])new ArtifactToken[]{DemoArtifactToken.SAW_Code_AI, DemoArtifactToken.SAW_SW_Design_AI, DemoArtifactToken.SAW_Requirements_AI, DemoArtifactToken.SAW_Test_AI});
        Date createdDate = new Date();
        AtsUser createdBy = this.atsApi.getUserService().getCurrentUser();
        String priority = "3";
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getClass().getSimpleName());
        this.actionResult = this.atsApi.getActionService().createAction(null, title, "Problem with the Diagram View", ChangeTypes.Problem, priority, false, null, aias, createdDate, createdBy, Arrays.asList(new ArtifactTokenActionListener()), changes);
        changes.execute();
        IAtsTeamWorkflow reqTeamWf = null;
        for (IAtsTeamWorkflow teamWf : this.actionResult.getTeamWfs()) {
            Pair<IAtsTeamWorkflow, Result> result;
            boolean isSwDesign = teamWf.getTeamDefinition().getName().contains("SW Design");
            if (isSwDesign) {
                teamWf = this.transitionAndReload(teamWf, TeamState.Analyze);
                if (this.atsApi.getReviewService().getReviews(teamWf).size() != 1) {
                    throw new OseeCoreException("Error, 1 review should have been created instead of " + this.atsApi.getReviewService().getReviews(teamWf).size(), new Object[0]);
                }
                changes = this.atsApi.createChangeSet("Transition Workflows");
                for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews(teamWf)) {
                    changes.setSoleAttributeValue((IAtsWorkItem)review, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
                }
                changes.execute();
                teamWf = this.reload(teamWf);
                teamWf = this.transitionAndReload(teamWf, TeamState.Authorize);
                teamWf = this.reload(teamWf);
                if (this.atsApi.getReviewService().getReviews(teamWf).size() != 2) {
                    throw new OseeCoreException("Error, 2 atsApi.getReviewService().getReviews(teamWf) should exist instead of " + this.atsApi.getReviewService().getReviews(teamWf).size(), new Object[0]);
                }
                changes = this.atsApi.createChangeSet("Transition Workflows");
                for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews(teamWf)) {
                    changes.setSoleAttributeValue((IAtsWorkItem)review, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
                }
                changes.execute();
                teamWf = this.reload(teamWf);
            }
            if (((Result)(result = this.transitionToWithPersist(teamWf, TeamState.Implement, (AtsUser)teamWf.getAssignees().iterator().next(), teamWf.getAssignees(), this.atsApi)).getSecond()).isFalse()) {
                throw new OseeStateException("Error transitioning " + ((Result)result.getSecond()).toString(), new Object[0]);
            }
            teamWf = (IAtsTeamWorkflow)result.getFirst();
            if (!(teamWf = this.setVersionAndReload(teamWf, (ArtifactToken)DemoArtifactToken.SAW_Bld_2)).getTeamDefinition().getName().contains("Requirements")) continue;
            reqTeamWf = teamWf;
        }
        if (reqTeamWf == null) {
            throw new OseeArgumentException("Can't locate Req team.", new Object[0]);
        }
        Result result = this.atsApi.getBranchService().createWorkingBranchValidate(reqTeamWf);
        if (result.isFalse()) {
            throw new OseeArgumentException("Error creating working branch: " + result.getText(), new Object[0]);
        }
        BranchData bData = this.atsApi.getBranchService().createWorkingBranch(reqTeamWf);
        if (bData.getResults().isErrors()) {
            throw new OseeStateException("Error creating working branch %s\n", new Object[]{bData.getResults().toString()});
        }
        if (bData.getNewBranch().isInvalid()) {
            throw new OseeStateException("New Branch is invalid\n", new Object[0]);
        }
        BranchToken workingBranch = this.atsApi.getBranchService().getBranch(bData.getNewBranch());
        if (workingBranch.isInvalid()) {
            throw new OseeStateException("Working Branch is invalid\n", new Object[0]);
        }
        changes = this.atsApi.createChangeSet(String.valueOf(this.getClass().getSimpleName()) + " 2.5", workingBranch);
        for (ArtifactToken art : DemoUtil.getSoftwareRequirements((boolean)false, (DemoUtil.SoftwareRequirementStrs)DemoUtil.SoftwareRequirementStrs.Functional, (BranchToken)workingBranch)) {
            changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.CSCI, (Object)DemoCscis.Interface.name());
            changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
            ArtifactToken robotArt = this.atsApi.getQueryService().getArtifactFromName(CoreArtifactTypes.Component, DemoSubsystems.Robot_API.name(), workingBranch);
            changes.relate((ArtifactId)art, CoreRelationTypes.Allocation_Component, (ArtifactId)robotArt);
        }
        changes.execute();
        changes = this.atsApi.createChangeSet(String.valueOf(this.getClass().getSimpleName()) + " - 3", workingBranch);
        for (ArtifactToken art : DemoUtil.getSoftwareRequirements((boolean)false, (DemoUtil.SoftwareRequirementStrs)DemoUtil.SoftwareRequirementStrs.daVinci, (BranchToken)workingBranch)) {
            changes.deleteArtifact((ArtifactId)art);
        }
        ArtifactToken parentArt = DemoUtil.getInterfaceInitializationSoftwareRequirement((boolean)false, (BranchToken)workingBranch);
        int x = 1;
        while (x < 4) {
            String name = "Claw Interface Init " + x;
            ArtifactToken newArt = changes.createArtifact(CoreArtifactTypes.SoftwareRequirementMsWord, name);
            changes.setSoleAttributeValue((ArtifactId)newArt, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
            changes.addChild((ArtifactId)parentArt, (ArtifactId)newArt);
            ++x;
        }
        changes.execute();
    }

    private class ArtifactTokenActionListener
    implements INewActionListener {
        private ArtifactTokenActionListener() {
        }

        public ArtifactToken getArtifactToken(List<IAtsActionableItem> applicableAis) {
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Test_AI)) {
                return DemoArtifactToken.SAW_UnCommited_Test_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Code_AI)) {
                return DemoArtifactToken.SAW_UnCommited_Code_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Requirements_AI)) {
                return DemoArtifactToken.SAW_UnCommited_Req_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_SW_Design_AI)) {
                return DemoArtifactToken.SAW_UnCommited_SWDesign_TeamWf;
            }
            throw new UnsupportedOperationException();
        }
    }
}

