/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import java.util.Arrays;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.core.config.OrganizePrograms;
import org.eclipse.osee.ats.rest.internal.demo.AtsDbConfigAIsAndTeamsDemoOp;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class AtsDbConfigDemoOp {
    private final AtsApi atsApi;

    public AtsDbConfigDemoOp(XResultData rd, AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData run() {
        new AtsDbConfigAIsAndTeamsDemoOp(this.atsApi).run();
        this.atsApi.getConfigService().getConfigurationsWithPend();
        this.configureForParallelCommit();
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set ATS Admin");
        changes.relate((ArtifactId)AtsUserGroups.AtsTempAdmin, CoreRelationTypes.Users_User, (ArtifactId)DemoUsers.Joe_Smith);
        changes.execute();
        new OrganizePrograms(this.atsApi).run();
        this.createDemoWebConfig();
        this.atsApi.setConfigValue("single_server_deployment", "true");
        this.createMarkdownRequirements();
        this.addBacklogCustomization();
        return new XResultData();
    }

    private void addBacklogCustomization() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Default Customization");
        String testCust = OseeInf.getResourceContents((String)"atsConfig/TestCust.xml", AtsDbConfigDemoOp.class);
        String custXml = "";
        String[] stringArray = testCust.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("<")) {
                custXml = line;
            }
            ++n2;
        }
        changes.addAttribute((ArtifactId)CoreArtifactTokens.XViewerCustomization, (AttributeTypeToken)CoreAttributeTypes.XViewerCustomization, (Object)custXml);
        changes.execute();
    }

    private void createDemoWebConfig() {
        ArtifactToken headingArt = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsTopFolder);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create Web Programs");
        ArtifactToken oseeWebArt = changes.createArtifact(headingArt, AtsArtifactToken.WebPrograms);
        ArtifactToken sawProgram = this.atsApi.getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_PL_Program);
        changes.relate((ArtifactId)oseeWebArt, CoreRelationTypes.UniversalGrouping_Members, (ArtifactId)sawProgram);
        changes.execute();
    }

    private void configureForParallelCommit() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("configureForParallelCommit");
        Version sawBld1Ver = this.atsApi.getVersionService().getVersionById((ArtifactId)DemoArtifactToken.SAW_Bld_1);
        Version sawBld2Ver = this.atsApi.getVersionService().getVersionById((ArtifactId)DemoArtifactToken.SAW_Bld_2);
        Version sawBld3Ver = this.atsApi.getVersionService().getVersionById((ArtifactId)DemoArtifactToken.SAW_Bld_3);
        changes.relate((Object)sawBld1Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld2Ver);
        changes.relate((Object)sawBld2Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld1Ver);
        changes.relate((Object)sawBld2Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld3Ver);
        changes.execute();
    }

    private void createMarkdownRequirements() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Populate Demo DB - Create Markdown", DemoBranches.SAW_Bld_1);
        ArtifactToken parent = this.atsApi.getQueryService().getArtifact((ArtifactId)CoreArtifactTokens.SoftwareRequirementsFolder, (BranchId)DemoBranches.SAW_Bld_1);
        ArtifactToken robotArt = changes.createArtifact(parent, DemoArtifactToken.RobotApiSwMarkdown);
        for (String childName : Arrays.asList("CISST fundamental data types", "Events", "Functional Specification", "Interface Initialization", "Read-only Robots", "Robot Interfaces", "Robot collaboration", "Virtual fixtures")) {
            ArtifactToken artifact = changes.createArtifact(robotArt, CoreArtifactTypes.SoftwareRequirementMarkdown, childName);
            String markdown = String.format("## %s \n\nThe API shall generate %s to notify the user application about asynchronous actions detected by the lower level software.  The %s of the individual and collaborative robot objects shall be documented in an external database/document.", childName, childName, childName, childName);
            changes.setSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.MarkdownContent, (Object)markdown);
        }
        changes.execute();
    }
}

