/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.DecisionReviewState;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.PeerToPeerReviewState;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Named;

public abstract class AbstractPopulateDemoDatabaseTest {
    protected final XResultData rd;
    protected final AtsApi atsApi;

    public AbstractPopulateDemoDatabaseTest(XResultData rd, AtsApi atsApi) {
        this.rd = rd;
        this.atsApi = atsApi;
    }

    public abstract void run();

    protected void assertEquals(int expected, int actual) {
        if (expected != actual) {
            this.rd.errorf("Expected %s but actual was %s\n", new Object[]{expected, actual});
        }
    }

    protected void assertNotNull(Object obj) {
        if (obj == null) {
            this.rd.errorf("Object should not be null\n", new Object[0]);
        }
    }

    protected IAtsTeamDefinition getTeamDef(ArtifactId artifactId) {
        return this.atsApi.getTeamDefinitionService().getTeamDefinitionById(artifactId);
    }

    protected void testTeamContents(IAtsTeamWorkflow teamWf, String title, String priority, String versionName, String currentStateName, String actionableItemStr, String assigneeStr, ArtifactTypeToken artifactType, IAtsTeamDefinition teamDef) {
        this.assertEquals(currentStateName, teamWf.getCurrentStateName());
        this.assertEquals(priority, (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)""));
        String targetedVerStr = "";
        IAtsVersion version = this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)teamWf);
        if (version != null) {
            targetedVerStr = version.getName();
        }
        this.assertEquals(versionName, targetedVerStr);
        this.assertEquals(artifactType, teamWf.getArtifactType());
        this.assertEquals((IAtsObject)teamDef, (IAtsObject)teamWf.getTeamDefinition());
        this.assertEquals(assigneeStr, teamWf.getAssigneesStr());
        this.assertEquals(actionableItemStr, this.atsApi.getActionableItemService().getActionableItemsStr((IAtsWorkItem)teamWf));
    }

    private void assertEquals(String expected, String actual) {
        if (!expected.equals(actual)) {
            this.rd.errorf("Expected %s but actual was %s\n", new Object[]{expected, actual});
        }
    }

    protected void assertEquals(ArtifactTypeToken expected, ArtifactTypeToken actual) {
        if (!expected.equals(actual)) {
            this.rd.errorf("Expected %s but actual was %s\n", new Object[]{expected, actual});
        }
    }

    protected void assertEquals(IAtsObject expected, IAtsObject actual) {
        if (!expected.equals(actual)) {
            this.rd.errorf("Expected %s but actual was %s\n", new Object[]{expected, actual});
        }
    }

    protected void assertTrue(boolean actual) {
        if (!actual) {
            this.rd.errorf("Expected true\n", new Object[0]);
        }
    }

    public void testSwDesign1PeerAnd1DecisionReview(IAtsTeamWorkflow designTeamWf) {
        this.assertNotNull(designTeamWf);
        IAtsPeerToPeerReview peerWf = null;
        IAtsDecisionReview decWf = null;
        for (IAtsAbstractReview revWf : this.atsApi.getReviewService().getReviews(designTeamWf)) {
            if (revWf.getName().contains("PeerToPeer")) {
                peerWf = (IAtsPeerToPeerReview)revWf;
                continue;
            }
            decWf = (IAtsDecisionReview)revWf;
        }
        this.assertNotNull(peerWf);
        this.assertNotNull(decWf);
        this.testReviewContents((IAtsAbstractReview)peerWf, "Auto-created Peer Review from ruleId atsAddPeerToPeerReview.test.addPeerToPeerReview.Authorize.None.TransitionTo", PeerToPeerReviewState.Prepare.getName(), "UnAssigned");
        this.testReviewContents((IAtsAbstractReview)decWf, "Auto-created Decision Review from ruleId: atsAddDecisionReview.test.addDecisionReview.Analyze.None.TransitionTo", DecisionReviewState.Decision.getName(), "UnAssigned");
    }

    public void testReviewContents(IAtsAbstractReview review, String title, String currentStateName, String ... assigneeStrs) {
        this.assertEquals(title, review.getName());
        this.assertEquals(currentStateName, review.getCurrentStateName());
        List assigneeNames = Named.getNames((Collection)review.getAssignees());
        this.assertEquals(assigneeStrs.length, assigneeNames.size());
        String[] stringArray = assigneeStrs;
        int n = assigneeStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String assignee = stringArray[n2];
            if (!assigneeNames.contains(assignee)) {
                this.fail(String.format("revArt.getAssignees(), does not contain user: %s", assignee));
            }
            ++n2;
        }
    }

    protected void fail(String message) {
        this.rd.errorf("Fail: %s\n", new Object[]{message});
    }
}

